<?php 
/**
 * Plugin Name: Facebook Page Widget (Matomo Plugin)
 * Plugin URI: http://plugins.matomo.org/FacebookPageWidgetByAmperage
 * Description: Show Facebook Page plugin as a configurable widget.
 * Author: Amperage Marketing & Fundraising, Kurt Zenisek
 * Author URI: https://www.amperagemarketing.com
 * Version: 5.0.1
 */
?><?php
/**
 * Piwik - free/libre analytics platform
 *
 * @link http://piwik.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 */

namespace Piwik\Plugins\FacebookPageWidgetByAmperage;

 
if (defined( 'ABSPATH')
&& function_exists('add_action')) {
    $path = '/matomo/app/core/Plugin.php';
    if (defined('WP_PLUGIN_DIR') && WP_PLUGIN_DIR && file_exists(WP_PLUGIN_DIR . $path)) {
        require_once WP_PLUGIN_DIR . $path;
    } elseif (defined('WPMU_PLUGIN_DIR') && WPMU_PLUGIN_DIR && file_exists(WPMU_PLUGIN_DIR . $path)) {
        require_once WPMU_PLUGIN_DIR . $path;
    } else {
        return;
    }
    add_action('plugins_loaded', function () {
        if (function_exists('matomo_add_plugin')) {
            matomo_add_plugin(__DIR__, __FILE__, true);
        }
    });
}

class FacebookPageWidgetByAmperage extends \Piwik\Plugin
{
    /**
     * @see Piwik\Plugin::registerEvents
     */
    public function registerEvents()
    {
        return array(
            'AssetManager.getStylesheetFiles' => 'getStylesheetFiles'
        );
    }

    public function getStylesheetFiles(&$files)
    {
        $files[] = "plugins/FacebookPageWidgetByAmperage/stylesheets/facebook-page.less";
    }
}
