<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Entities\Article as Item;
use App\Models\ArticleModel;
use App\Services\InventoryService;
use CodeIgniter\API\ResponseTrait;
use CodeIgniter\HTTP\ResponseInterface;

class Article extends BaseController
{
    use ResponseTrait;
    protected ArticleModel $articleModel;



    public function __construct()
    {
        //$this->cachePage(HOUR);
        $this->articleModel = new ArticleModel();
    }

    public function index(): ResponseInterface
    {
        $articles =  $this->articleModel
            ->select("items.id, items.name,items.category category, coalesce(items_category.name,'sin categoría') categoryName,
            items.cost,items.public_price,items.special_price,items.qty_special_price,
            items.wholesale_price,items.qty_wholesale_price,items.created_at,items.updated_at,items.deleted_at")
            ->join("items_category","items.category = items_category.id","left")
            ->findAll();
        return $this->respond($articles);

    }
    public function show($id): ResponseInterface
    {
        return $this->respond($this->articleModel->find($id));
    }

    public function create(): ResponseInterface
    {
        $item = new Item($this->request->getPost());
        $item->name = addslashes($item->name);
      
        try {
            $itemId = $this->articleModel->insert($item);
        } catch (\ReflectionException $e) {
            return $this->fail($e->getMessage());
        }

        if (!is_numeric($itemId))
        {
            $return = $this->fail($this->articleModel->errors());
        }else{
            $return = $this->respondCreated($this->articleModel->find($itemId));
        }

        return $return;

    }

    public function update($id): ResponseInterface
    {
        $item = $this->articleModel
            ->find($id)
            ->fill($this->request->getRawInput());

        try {
           
            $updated = $this->articleModel->save($item);
        } catch (\ReflectionException $e) {
            return $this->fail( $e->getMessage());
        }

        return $updated?$this->respond($item):$this->fail($this->articleModel->errors());
    }

    public function delete($id): ResponseInterface
    {
        $item = $this->articleModel->find($id);
        $inventory = new InventoryService(model("App\\Models\\InventoryModel"));
        $articles = $inventory->getInventory(0,"item",$id);
        $deleted =  $this->articleModel->delete($id);
        if(!empty($articles))
        {
            $deleted = $deleted && $inventory->deleteInventory($articles);
            
        }
        return $this->respondDeleted(["article" => $item, "intentory"=>$articles, "deleted" => $deleted]);
    }
    
    public function stock()
    {
        return $this->respond( $this->articleModel
            ->join("inventory","inventory.item = items.id","left")
            ->join("stores","inventory.store = stores.id","left")
            ->select("items.id, items.name, inventory.code, stock, coalesce(stores.name,'sin tienda') store ")
            ->selectSum("inventory.stock", "stock")
            ->groupBy("items.id,store")
            //->builder()->getCompiledSelect());
           ->findAll());
    }
}
