<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class TableTransfers extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id"=>[
                "type" =>"INT",
                "constraint"=>11,
                "auto_increment"=>true,
            ],
            "inventory"=>[
                "type" =>"INT",
                "constraint"=>11,
            ],
            "item"=>[
                "type" =>"INT",
                "constraint"=>11,
            ],
            "qty"=>[
                "type"=>"INT",
                "constraint"=>11
            ],
            "store_dispatch"=>[
                "type" =>"INT",
                "constraint"=>11,
            ],
            "store_receive"=>[
                "type" =>"INT",
                "constraint"=>11,
            ],
            "created_by"=>[
                "type" =>"INT",
                "constraint"=>11,
            ],
            "created_at"=>[
                "type" =>"DATETIME",
                "default"=>new RawSql("CURRENT_TIMESTAMP")
            ],
            "updated_at"=>[
                "type" =>"DATETIME",
                "null"=>true
            ],
            "deleted_at"=>[
                "type" =>"DATETIME",
                "null"=>true
            ]
        ])
            ->addPrimaryKey("id")
            ->createTable("transfers");

    }

    public function down()
    {
        $this->forge->dropTable("transfers",true);
    }
}
