<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class TableSaleItems extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id"=>[
                "type"=>"int",
                "constraint"=>11,
                "auto_increment"=>true
            ],
            "sale"=>[
                "type"=>"int",
                "constraint"=>11,
            ],
            "qty"=>[
                "type"=>"int",
                "constraint"=>11,
            ],
            "item"=>[
                "type"=>"int",
                "constraint"=>11,
            ],
           "inventory"=>[
                "type"=>"int",
                "constraint"=>11,
            ],
            "sale_price" =>[
                "type"=>"decimal",
                "constraint"=>"10,2"
            ],
            "final_price" =>[
                "type"=>"decimal",
                "constraint"=>"10,2"
            ]
            
            
            
        ])->addPrimaryKey("id")
            ->createTable("sale_items");
    }

    public function down()
    {
        $this->forge->dropTable("sale_items");
    }
}
