<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class CreditPaymentsTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            "id"=>[
                "type"=>"int",
                "constraint"=>11,
                "auto_increment"=>true,
            ],
            "credit"=>[
                "type" => "int",
                "constraint"=>11
            ],
            "payment_type"=>[
                "type"=>"enum",
                "constraint"=>["cash","transfer","card"],
                "default"=>"cash"
            ],
            "amount"=>[
                "type"=>"decimal",
                "constraint"=>"11,2",
            ],
            "created_by"=>[
                "type"=>"int",
                "constraint"=>11,

            ],
            "document"=>[
                "type"=>"varchar",
                "constraint"=>250,
                "null"=>true
            ],
            "created_at"=>[
                "type" =>"DATETIME",
                "default"=>new RawSql("CURRENT_TIMESTAMP")
            ],
            "updated_at"=>[
                "type" =>"DATETIME",
                "null"=>true
            ],
            "deleted_at"=>[
                "type" =>"DATETIME",
                "null"=>true
            ]
        ])->addPrimaryKey("id")->createTable("credit_payments");
    }

    public function down()
    {
        $this->forge->dropTable("credit_payments");
    }
}
