<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddFieldSaleType extends Migration
{
    public function up()
    {
        $this->forge->addColumn('sales', [
            "type"=>[
                "type"=>"ENUM",
                "constraint"=>["cash","aside","credit"]
            ]
        ]);
        $this->forge->modifyColumn('sales',[
            "aut"=>[
                "type"=>"VARCHAR",
                "constraint"=>"100",
                "null"=>true,
            ]
        ]);
    }

    public function down()
    {
        $this->forge->dropColumn('sales', 'type');
    }
}
