<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddMultiPaymentToSale extends Migration
{
    public function up()
    {
        $this->forge->modifyColumn("sales",[
            "payment_type"=>[
                "type"=>"ENUM",
                "constraint"=>[
                    "cash",
                    "card",
                    "transfer",
                    "credit",
                    "aside",
                    "mullti"
                ],
                "default"=>"cash"
            ]
        ]);
    }

    public function down()
    {
        $this->forge->modifyColumn("sales",[
            "payment_type"=>[
                "type"=>"ENUM",
                "constraint"=>[
                    "cash",
                    "card",
                    "transfer",
                    "credit",
                    "aside"
                ]
            ]
        ]);
    }
}
