<?php

namespace App\Database\Seeds;

use App\Models\ArticleModel;
use CodeIgniter\Database\Seeder;

class ItemsPrices extends Seeder
{
    public function run()
    {
        $articles = model(ArticleModel::class)->findAll();
        $items = [];
        $cost = 1000;
        
        foreach ($articles as $key => $article)
        {
            if($article->cost ===0.00) {
                
                $thisCost = ($cost++) + 10;
                $public = $thisCost * 2;
                $special = $public / 1.25;
                $wholesale = $special / 1.25;
                
                $items[] = [
                    "id" => $article->id,
                    "cost" => ($cost++) + 10,
                    "public_price" => $public,
                    "special_price" => $special,
                    "qty_special_price" => 1,
                    "wholesale_price" => $wholesale,
                    "qty_wholesale_price" => 1
                
                ];
            }
        }
        $this->db->table("items")->updateBatch($items,['id']);
    }
}
