<?php
$br = "<br>";
?>
    <style>
        td{
            font-size: 10px;
            width: 15mm;
            /*border: .5px blue;*/
        }
        th{
            width: 40mm;
            font-size: 10px;
        }
     
        img{
            margin: auto;
            display: block;
            background: rgb(5, 5, 5);
        }
        .title{
            font-size: 15px;
        }
        .left{
            text-align: left;
        }
        .center{
            text-align: center;
        }
        .right{
            text-align: right;
        }
        
        .font-100{
            font-weight: 100;
        }
        .smallText{
            font-size: 9px;
        }
        .bData{
            font-size: 8px;
            margin-bottom: 8px;
        }
        .brand{
            display: flex;
            flex-direction: column; /* Organiza los elementos en una columna */
            align-items: center; /* Centra horizontalmente */
            justify-content: center; /* Centra verticalmente */
        }
        .saleData{
            font-size: 8px;
            margin-top: 2px;
            margin-bottom: 2px;
        }
        .saleType{
            font-size: 10px;
            margin-top: 2px;
            margin-bottom: 2px;
        }
        .saleDiv{
            margin-bottom: 4px;
        }
        .table-container {
            width: 50mm;
            margin: 0 auto;
        }
        .receipt-table {
            width: 100%;
            border-collapse: collapse;
            font-family: Arial, sans-serif;
            font-size: 9px;
        }
        .receipt-table thead th {
            text-align: left;
            border-bottom: 1px solid #000;
            padding: 2px 2px;
            font-weight: bold;
        }
        .receipt-table tbody td {
            padding: 2px 2px;
        }
        .col-quantity {
            width: 8%;
            text-align: left;
        }
        .col-description {
            width: 65%;
            text-align: left;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
        .col-price {
            width: 27%;
            text-align: right;
        }
        /* Estilo general de la tabla */
        .summary-table {
            width:58mm;
            border-collapse: collapse;
            margin-top: 2px;
        }

        .summary-table td {
            padding: 2px;
        }

        /* Columna de etiquetas */
        .summary-table .label {
            text-align: right; /* Alinea el texto al extremo derecho */
            font-weight: bold;
            width: 60%; /* Proporción del ancho de la tabla */
        }

        /* Columna de valores */
        .summary-table .value {
            text-align: left; /* Alinea el texto al extremo izquierdo */
            width: 30%; /* Proporción del ancho de la tabla */
        }

        /* Resalta el total */
        .summary-table .total {
            font-size: 11px;
            font-weight: bold;
        }

        .summary-table .total-value {
            font-size:11px;
            font-weight: bold;
        }

        .divider {
            border-top: 1px solid black; /* Línea negra de 1px de alto */
            margin: 3px 0; /* Espaciado superior e inferior */
            width: 100%; /* Ancho completo del contenedor */
        }
        .paymentText{
            font-size: 8px;
        }
        .paymentHeader{
            font-size: 11px;
        }
    </style>
<page>

    <div class="brand center">
        <img class="brand" src="assets/img/branding/bnw.png"  width='64'>
    </div>
    <div class="center bData" >
        <span><?=env("app.title")?></span> <br>
        <span><?= $company->owner?></span> <br>
        <span>RFC:<?=$company->rfc?></span> <br>
        <span>Regimen Simplificado de Confianza</span> <br>
        <span>Sucursal:<?=$company->store->name?></span> <br>
        <span><?=$company->store->address?></span> <br>
        <span>Tel: <?=$company->store->phone?></span>
    </div>

    <div class="saleDiv center">
        <span class="saleType">Tipo de venta: <?=@$type?></span>
            <br>
        <span class="saleData">Fecha: <?= str_replace(" ", " de ",$sales->created_at->toLocalizedString('dd MMMM yyyy'))?></span>
        <span class="saleData">Hora: <?=$sales->created_at->toTimeString() .' hrs.' ?></span>
    </div>

    <div class="table-container">
        <table class="receipt-table">
            <thead>
            <tr>
                <th class="col-quantity">#</th>
                <th class="col-description">Descripción</th>
                <th class="col-price">Precio</th>
            </tr>
            </thead>
            <tbody>
                <?php
                $subtotal = 0;
                foreach($items as $index => $item):?>
                    <tr>
                        <td class="col-quantity"><?=$item->qty?></td>
                        <td class="col-description"><?=$item->name?></td>
                        <td class="col-price">
                            <?= number_to_currency(($item->unit_price??$item->final_price)*$item->qty,"MXN",'es_MX',2) ?>
                        </td>
                    </tr>
                    <?php
                    $subtotal+=($item->unit_price*$item->qty);
                endforeach;  ?>
            </tbody>
        </table>
    </div>
    <table class="summary-table">
        <tr>
            <td class="label">Subtotal:</td>
            <td class="value"><?=number_to_currency($subtotal,"MXN",'es_MX',2)?></td>
        </tr>
        <tr>
            <td class="label">Descuentos:</td>
            <td class="value"><?=number_to_currency($sales->discount??"0.00","MXN",'es_MX',2)?></td>
        </tr>
        <tr>
            <td class="label total">Total:</td>
            <td class="value total-value"><?= number_to_currency($sales->amount,"MXN",'es_MX',2)?></td>
        </tr>
    </table>

    <div class="center smallText">
        <?=$sales->amount_letter ?>
    </div>
    <div class="divider"></div>

    <div class="">
         <span class="paymentHeader">Información del pago:</span>
    </div>
    <div>
        <?php if($sales->payment_type === 'multi'): ?>
            <span class="paymentText"> <span><?=@$payments[$sales->payment_type] ?></span></span><br>
        <?php endif;
        $paid = 0;
        foreach ($payments as $payment):
            $paid += $payment->amount;
            ?>
            <span class="paymentText">Tipo de pago : <?=@$payment_types[$payment->payment_type]?></span><br>
            <span class="paymentText">Recibido: $<?=@$payment->amount?></span><br>
            <span class="paymentText">Cambio: $<?=@$payment->cashback?></span><br>

            <?php if($payment->payment_type == "card") :?>
            <span class="paymentText">No. de autorización:
                <span class="right font-100"><?=$payment->aut ?></span><br>
            </span>

        <?php endif;?>
        <?php endforeach;?>

        <?php if($sales->type === 'aside'):?>
            <span class="left">Pendiente:</span>
            <span class="right">
                <?= number_to_currency($sales->amount - @$paid,"MXN",'es_MX',2) ?>
            </span>
        <?php endif;?>
    </div>

    <div class="center saleData">
        <span class="font-100">Cliente: <?=ucwords($sales->customer_name) ?> </span><br>
        <?php if($sales->customer!== 1):?>
            <span class="font-100"><?=ucwords($sales->customer_address) ?></span>
        <?php endif;?>
        <span class="">Lo atendió: </span><span><?= $user->name." ". $user->last_name?></span>
    </div>
    <div class="center saleData smallText">
        <span class="center">Muchas gracias por tu compra.<br>Disfruta tus productos.</span> <br>
        <span class="center">Si tiene alguna queja, favor de escanear el QR </span>
    </div>
    <p class="center saleData" style="margin-bottom: 6px;">
        <span style="margin-top: 5px; text-align: center">Desarrollado en Sistematlan</span> <br>
        <span style="margin-top: 5px;">Más información: sistematlan.com/pos</span>
    </p>
</page>
<qrcode value="https://api.whatsapp.com/send?phone=5219621537465&text=Hola%2C%20buen%20d%C3%ADa.%20Me%20gustar%C3%ADa%20hablar%20con%20alguien%20sobre%20una%20compra%20que%20hice%20en%20la%20tienda%20La%20Bendici%C3%B3n%20%F0%9F%8F%AA%20" ec="H" style="width: 50mm; background-color: white; color: black;"></qrcode>
