<?= $this->extend('app') ?>

<?= $this->section('componentStyles') ?>
<link rel="stylesheet" href="../../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
<link rel="stylesheet" href="../../assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css" />
<link rel="stylesheet" href="../../assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css" />
<link rel="stylesheet" href="../../assets/vendor/libs/datatables-checkboxes-jquery/datatables.checkboxes.css" />
<link rel="stylesheet" href="../../assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css" />
<link rel="stylesheet" href="../../assets/vendor/libs/datatables-rowgroup-bs5/rowgroup.bootstrap5.css" />
<link rel="stylesheet" href="../../assets/vendor/libs/sweetalert2/sweetalert2.css" />
<link rel="stylesheet" href="../../assets/vendor/libs/bootstrap-datepicker/bootstrap-datepicker.css" />
<link rel="stylesheet" href="../../assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.css" />
<?= $this->endSection() ?>

<?= $this->section('content') ?>
<div class="d-flex flex-column flex-md-row align-items-center justify-content-between">
    <h4 class="py-3 col-lg-9">
        <span class="text-muted fw-light"><?= env('app.title')?> /</span> Ventas
    </h4>
    <div class="form-floating col-lg-3 form-floating-outline">
        <input type="text" id="bs-rangepicker-range" class="form-control" />
        <label for="bs-rangepicker-range">Fechas</label>
    </div>
</div>


<?=$this->include('partials/alerts');?>

<div class="card mt-4">
    <div class="card-datatable table-responsive pt-0">
        <table id="salesDatatable" class="datatables-basic table table-bordered">
            <thead>
            <tr>
                <th></th>
                <th>Folio</th>
                <th>Fecha</th>
                <th>Tienda</th>
                <th>Artículos</th>
                <th>Tipo de venta</th>
                <th>Tipo de pago</th>
                <th>Descuento</th>
                <th>Monto</th>
                <th>Estatus</th>
                <th>Vendedor</th>
                <th>Acciones</th>
            </tr>
            </thead>
        </table>
    </div>
</div>


<?= $this->endSection() ?>

<?= $this->section('componentScripts') ?>
<script src="../../assets/vendor/libs/block-ui/block-ui.js"></script>
<script src="../../assets/vendor/libs/moment/moment.js"></script>
<script src="../../assets/vendor/libs/datatables-bs5/datatables-bootstrap5.js"></script>
<script src="../../assets/vendor/libs/sweetalert2/sweetalert2.js"></script>
<script src="../../assets/vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js"></script>
<script src="../../assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"></script>
<script>
    var allStores = <?= json_encode($stores)?>;
    let toDeliver;
    let saleTypes = {
        "cash" :"Contado",
        "aside":"Apartado",
        "credit":"Crédito"
    }
    let payment_types = {
        "cash"  :"Efectivo",
        "card"  :"Tarjeta",
        "transfer":"Transferencia"
    }
    
    indexedStores = allStores.reduce((acc,current)=>{
        acc[current.id] = current
        return acc
    },[]);
    console.log('All sales js loaded');
    var dt_basic_table = $('.datatables-basic'), dt_basic;
    let paymentType;
    let users;
    let deliverCounter = 0;
    $(function(){

        // All sales datatable
        dt_basic = dt_basic_table.DataTable({
            ajax: {
                url: '/sale'+location.search,
                dataSrc: ""
            },
            columns: [
                { data: 'id' },
                { data: 'id' },
                { data: 'created_at', render:function (data){
                        let date = data.date.split(' ');
                        return date[0];
                    }
                },
                { data: 'store', render:function (data){
                        return indexedStores[data].name;
                    }},
                { data: 'items' },
                { data: 'type', render:function (data){
                        if(saleTypes[data] === undefined){
                            return "Por definir"
                        }
                        return saleTypes[data];
                    
                    }
                },
                { data: 'payment_type', render:function (data){
                        if(payment_types[data] === undefined){
                            return "Por definir"
                        }
                        return payment_types[data];
                    }
                },
                { data: 'discount', render:function (data){
                    let badge;
                    if (data === null){
                        badge = `<span class="badge rounded-pill bg-label-secondary">Sin descuento</span>`
                    } else {
                        let discountFormat = '$'+formatMoney(data);
                        badge = `<span class="badge rounded-pill bg-label-primary">${discountFormat}</span>`
                    }
                    return badge;
                    }
                },
                { data: 'amount', render:function (data){
                    let amountFormat = '$'+formatMoney(data);
                    return amountFormat;
                    }
                },
                { data: 'delivery', render:function (data){
                    let badge;
                        if (data === 'store' || data === 'delivered'){
                            badge = `<span class="badge rounded-pill bg-label-secondary">Entregado</span>`
                        } else {
                            badge = `<span class="badge rounded-pill bg-label-warning">Por entregar</span>`
                        }
                        return badge;
                    }
                },
                { data: 'username'},
                { data: '', render: function (data, type, row){
                        let saleJson = JSON.stringify(row);
                        return `
                            <a href="javascript:void(0);" onclick='openSaleModal(${saleJson})'
                                class='btn btn-sm btn-text-secondary rounded-pill disabled btn-icon item-edit'
                                data-bs-toggle="modal" data-bs-target="#editStore">
                                <i class='mdi mdi-pencil-outline'></i>
                            </a>
                            <a href="/ticket/${row.uuid}" target="_blank"
                                class='btn btn-sm btn-text-secondary rounded-pill btn-icon item-edit'>
                                <i class='mdi mdi-receipt-text'></i>
                            </a>
                            <a href="javascript:void(0);" onclick='deleteSale(${saleJson})'
                                class='btn btn-sm btn-text-secondary rounded-pill  btn-icon item-edit'>
                                <i class='mdi mdi-delete'></i>
                            </a>
                                `
                    }
                }
            ],
            columnDefs: [
                {
                    // For Responsive
                    className: 'control',
                    orderable: false,
                    searchable: false,
                    responsivePriority: 2,
                    targets: 0,
                    render: function (data, type, full, meta) {
                        return '';
                    }
                },
                // {
                //     // For Checkboxes
                //     targets: 1,
                //     orderable: false,
                //     searchable: false,
                //     responsivePriority: 3,
                //     checkboxes: true,
                //     render: function () {
                //         return '<input type="checkbox" class="dt-checkboxes form-check-input">';
                //     },
                //     checkboxes: {
                //         selectAllRender: '<input type="checkbox" class="form-check-input">'
                //     }
                // },
                
                {
                    // Actions
                    targets: -1,
                    title: 'Acciones',
                    orderable: false,
                    searchable: false,

                }
            ],
            order: [[2, 'desc']],
            dom: '<"card-header flex-column flex-md-row"<"head-label text-center"><"dt-action-buttons text-end pt-3 pt-md-0"B>><"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6 d-flex justify-content-center justify-content-md-end"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
            displayLength: 10,
            lengthMenu: [7,10, 25, 50, 75, 100],
            buttons: [
                // Tickets button
                {
                    className: 'btn btn-label-primary me-2',
                    text: '<i class="mdi mdi-calendar me-sm-1"></i> <span class="d-none d-sm-inline-block">Tickets</span>',
                    action: function ( e, dt, node, config ) {
                        getTickets();
                    }
                },
                // Export button
                {
                        extend: 'collection',
                        className: 'btn btn-label-primary dropdown-toggle me-2',
                        text: '<i class="mdi mdi-export-variant me-sm-1"></i> <span class="d-none d-sm-inline-block">Exportar</span>',
                        buttons: [
                            {
                                extend: 'csv',
                                text: '<i class="mdi mdi-file-excel-outline me-1"></i>Excel',
                                className: 'dropdown-item',
                                exportOptions: {
                                    columns: [1,2,3,4,5,6,7,9]
                                }
                            },
                            {
                                extend: 'pdf',
                                text: '<i class="mdi mdi-file-pdf-box me-1"></i>PDF',
                                className: 'dropdown-item',
                                exportOptions: {
                                    columns: [1,2,3,4,5,6,7,9],
                                }
                            }
                        ]
                    }
            ],
            responsive: {
                details: {
                    display: $.fn.dataTable.Responsive.display.modal({
                        header: function (row) {
                            var data = row.data();
                            return 'Detalles de la venta ';
                        }
                    }),
                    type: 'column',
                    renderer: function (api, rowIdx, columns) {
                        var data = $.map(columns, function (col, i) {
                            return col.title !== '' // ? Do not show row in modal popup if title is blank (for check box)
                                ? '<tr data-dt-row="' +
                                col.rowIndex +
                                '" data-dt-column="' +
                                col.columnIndex +
                                '">' +
                                '<td>' +
                                col.title +
                                ':' +
                                '</td> ' +
                                '<td>' +
                                col.data +
                                '</td>' +
                                '</tr>'
                                : '';
                        }).join('');

                        return data ? $('<table class="table"/><tbody />').append(data) : false;
                    }
                }
            },
            language: {
                url: '//cdn.datatables.net/plug-ins/2.0.8/i18n/es-MX.json',
            },
        });
        $('div.head-label').html('<h5 class="card-title mb-0">Histórico de ventas</h5>');

    });

    function blocking()
    {
        $('#card-block').block({
            message: '<div class="spinner-border text-primary" role="status"></div>',
            timeout: 2000,
            css: {
                backgroundColor: 'transparent',
                border: '0'
            },
            overlayCSS: {
                backgroundColor: '#fff',
                opacity: 0.8
            }
        });
    }

    function deleteSale(sale)
    {
        let saleID = sale.id;
        Swal.fire({
            title: '¿Estás seguro?',
            text: "No serás capaz de recuperar esta venta y el artículo regresará al inventario de la tienda",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'Sí, cancelar venta!',
            cancelButtonText: 'Regresar',
            customClass: {
                confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                cancelButton: 'btn btn-outline-secondary waves-effect'
            },
            buttonsStyling: false
        }).then(function (result) {
            if (result.isConfirmed) {
                $.ajax({
                    method: 'POST',
                    url: '/sale/'+saleID,
                    data: {
                        '_method': 'DELETE'
                    },
                    dataType: 'JSON'
                }).done(function(response){
                    console.log(response);
                    Swal.fire({
                        icon: 'success',
                        title: '¡Venta cancelada!',
                        customClass: {
                            confirmButton: 'btn btn-success waves-effect'
                        }
                    });
                    dt_basic.ajax.reload();
                })
            }
        });
    }


    function getTickets()
    {
        let params = location.search;
        window.open('/tickets'+params, '_blank');
    }

</script>
<?= $this->endSection() ?>





