<?php

use CodeIgniter\Router\RouteCollection;

$filter = ['filter' => 'session'];

/**
 * @var RouteCollection $routes
 */
//AUTH
service('auth')->routes($routes);

$routes->get('/', 'Home::index', $filter);
$routes->get('/clientes', 'Home::clients', $filter);
$routes->get('/nuevo-pago', 'Home::newPayment', $filter);
$routes->get('/pagos', 'Home::payments', $filter);
$routes->get('/ventas', 'Home::sales', $filter);
$routes->get('/venta/(:num)', 'Home::saleDetail/$1', $filter);

$routes->get("/sale/user/(:any)","Sale::byClient/$1");

//RESOURCES
$routes->resource('client', $filter);
$routes->resource('sale', $filter);
$routes->resource('payment', $filter);


//$routes->get('/(:any)', 'Home::root/$1');