<?php

namespace App\Controllers;

use App\Models\ClientModel;
use App\Models\SaleModel;
use CodeIgniter\Exceptions\PageNotFoundException;

class Home extends BaseController
{
    protected ClientModel $clientModel;
    public function __construct()
    {
        $this->clientModel = new ClientModel();
    }

    public function index()
    {
        $viewData['title'] = 'Inicio';
        $viewData['subtitle'] = 'Panel';
        $viewData['clients'] = $this->clientModel->findAll();
        return view('components/start', $viewData);
    }

    public function clients()
    {
        $viewData['title'] = 'Clientes';
        $viewData['subtitle'] = 'Apps';
        return view('components/clients', $viewData);
    }

    public function sales()
    {
        $viewData['title'] = 'Ventas';
        $viewData['subtitle'] = 'Apps';
        $viewData['sales'] = (new \App\Models\SaleModel())->findAll();
        return view('components/sales', $viewData);
    }

    public function newPayment()
    {
        $viewData['title'] = 'Nuevo pago';
        $viewData['subtitle'] = 'Apps';
        $viewData['clients'] = $this->clientModel->findAll();
        return view('components/newPayments', $viewData);
    }

    public function payments()
    {
        $viewData['title'] = 'Pagos';
        $viewData['subtitle'] = 'Apps';
        $viewData['payments'] = (new \App\Models\PaymentModel())->findAll();
        return view('components/payments', $viewData);
    }

    public function saleDetail($id)
    {
        $viewData['title'] = 'Detalle de la venta';
        $viewData['subtitle'] = 'Apps';
        $viewData['sale'] = (new SaleModel())
            ->select('sales.*, users.username as created_by_name')
            ->join('users', 'users.id = sales.created_by')
            ->find($id);
        $viewData['client'] = (new ClientModel())->find($viewData['sale']->client);
        $viewData['payments'] = (new \App\Models\PaymentModel())
            ->select('payments.*, users.username as created_by_name')
            ->join('users', 'users.id = payments.created_by')
            ->where('sale', $id)
            ->findAll();
        $viewData['totalPayments'] = array_sum(array_column($viewData['payments'], 'amount'));
        return view('components/saleDetail', $viewData);
    }

    public function root($path = '')
    {
        if ($path === '') {
            throw PageNotFoundException::forPageNotFound();
        }

        // Disallow ".." (parent directory) and any backslashes.
        if (str_contains($path, '..') || str_contains($path, '\\')) {
            throw PageNotFoundException::forPageNotFound('Invalid path.');
        }

        $viewFile = APPPATH . 'Views/' . $path . '.php';
        $realViewPath = realpath($viewFile);
        $realViewsDir = realpath(APPPATH . 'Views');

        if ($realViewPath === false || !str_starts_with($realViewPath, $realViewsDir)) {
            throw PageNotFoundException::forPageNotFound();
        }

        return view($path);
    }
}
