<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\SaleModel;
use CodeIgniter\API\ResponseTrait;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\I18n\Time;

class Sale extends BaseController
{
    use ResponseTrait;
    protected SaleModel $saleModel;

    public function __construct()
    {
        $this->saleModel = new \App\Models\SaleModel();
    }

    public function index(): ResponseInterface
    {
        //return $this->respond($this->saleModel->findAll());
        $sales = $this->saleModel
            ->select('sales.*, clients.name as name, 
                                        clients.last_name as last_name, 
                                        clients.email as email, 
                                        clients.phone as phone')
            ->join('clients', 'clients.id = sales.client')
            ->findAll();

        return $this->respond($sales);
    }

    public function show($id): ResponseInterface
    {
        return $this->respond($this->saleModel->find($id));
    }

    public function create(): ResponseInterface
    {
        $sale = new \App\Entities\Sale($this->request->getPost());

        try {
            $inserted = $this->saleModel->save($sale);

            if ($inserted) {
                $saleId = $this->saleModel->getInsertID();

                // Crear el pago inicial si existe front_payment
                $frontPayment = $this->request->getPost('front_payment');
                if ($frontPayment && $frontPayment > 0) {
                    $paymentModel = new \App\Models\PaymentModel();
                    $paymentData = [
                        'sale' => $saleId,
                        'amount' => $frontPayment,
                        'payment_method' => $this->request->getPost('payment_method'),
                        'payment_date' => $this->request->getPost('order_date'),
                        'created_by' => $this->request->getPost('created_by')
                    ];
                    $paymentModel->insert($paymentData);
                }

                //Asignacion de dia de pago
                $creationDay = $this->request->getPost('order_date');
                $day = explode('-', $creationDay)[2];
                if ($day > 7 && $day <= 21) {
                    $this->saleModel->update($saleId, ['payment_day' => 15]);
                }else{
                    $this->saleModel->update($saleId, ['payment_day' => 1]);
                }

            }
        }catch (\ReflectionException $e) {
            return $this->fail($e->getMessage());
        }
        return $inserted ? $this->respondCreated($this->saleModel->find($this->saleModel->getInsertID()))
            : $this->fail($e->getMessage(), ResponseInterface::HTTP_INTERNAL_SERVER_ERROR);
    }

    public function update($id)
    {
        $sale = $this->saleModel->find($id);
        $sale->fill($this->request->getRawInput());
        $sale->updated_at = Time::now();
        try{
            $updated = $this->saleModel->save($sale);
        }catch (\ReflectionException $e) {
            return $this->fail($e->getMessage());
        }
        return $updated ? $this->response->setJSON(['message' => 'Registro actualizado correctamente'])
            : $this->fail($e->getMessage(), ResponseInterface::HTTP_INTERNAL_SERVER_ERROR);
    }

    public function delete($id): ResponseInterface
    {
        try {
            $deleted = $this->saleModel->delete($id);
        }catch (\ReflectionException $e) {
            return $this->fail($e->getMessage());
        }
        return $deleted ? $this->response->setJSON(['message' => 'Registro eliminado correctamente'])
            : $this->fail($e->getMessage(), ResponseInterface::HTTP_INTERNAL_SERVER_ERROR);
    }

    public function byClient($id)
    {
        return $this->respond($this->saleModel->where('client', $id)->findAll());
    }
}
