<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;
use CodeIgniter\Database\RawSql;

class AddPaymentTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'payment_date' => [
                'type'       => 'DATE',
            ],
            'sale' => [
                'type'       => 'INT',
                'unsigned' => true,
            ],
            'amount' => [
                'type'       => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'pending' => [
                'type'       => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'payment_method' => [
                'type'       => 'VARCHAR',
                'constraint' => '25',
            ],
            'created_at'=>[
                'type'=>'DATETIME',
                'default'=>new RawSql('CURRENT_TIMESTAMP')
            ],
            'created_by'=>[
                'type'=>'INT',
                'unsigned'=>true,
            ],
            'updated_at'=>[
                'type'=>'datetime',
                'null'=>true
            ],
            'updated_by'=>[
                'type'=>'INT',
                'unsigned'=>true,
            ],
            'deleted_at'=>[
                'type'=>'datetime',
                'null'=>true
            ],
            'deleted_by'=>[
                'type'=>'INT',
                'unsigned'=>true,
            ]
        ]);
        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('sale', 'sales', 'id', 'CASCADE', 'RESTRICT');
        $this->forge->createTable('payments');
    }

    public function down()
    {
        $this->forge->dropTable('payments');
    }
}
