<!doctype html>

<html lang="en">
    <head>
        <?= $this->include('partials/title-meta')?>

        <?= $this->include('partials/head-css') ?>

        <?= $this->renderSection('styles') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?>

            <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <?=$this->include('partials/toast')?>
                <!-- container -->

                <!-- notificación -->
                <div class="container-fluid">
                    <?=$this->include('partials/page-title')?>

                    <?= $this->renderSection('content') ?>
                </div>
                <!-- /notificación -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->

        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?>
        <?= $this->include('partials/footer-scripts') ?>
        <script src="/plugins/jquery/jquery.min.js"></script>
        <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script>
            const formatter = new Intl.NumberFormat('es-MX', {
                style: 'currency',
                currency: 'MXN',
            });

            function showToast(type, message) {
                const toastEl = document.getElementById('liveToast');

                toastEl.classList.forEach(cls => {
                    if (cls.startsWith('bg-')) {
                        toastEl.classList.remove(cls);
                    }
                });

                toastEl.classList.add(`bg-${type}`);

                const body = toastEl.querySelector('.toast-body');
                if (body) {
                    body.textContent = message;
                }

                const toast = bootstrap.Toast.getOrCreateInstance(toastEl);
                toast.show();
            }

            /**
             * Deletes a specified resource by sending a DELETE request to the provided URL.
             *
             * @param {number|string} id - The unique identifier of the resource to be deleted.
             * @param {string} url - The base URL to which the DELETE request will be sent.
             * @return {void} This function does not return a value.
             */
            function deleteThing(id, url){
                console.log(id, url);
                Swal.fire({
                    title: "¿Estás seguro de eliminar?",
                    text: "Despues de esto, no hay forma de recuperarlo!",
                    icon: "warning",
                    showCancelButton: true,
                    cancelButtonText: "Cancelar",
                    confirmButtonColor: "#02bc9c",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Sí, borrar!"
                }).then((result) => {
                    if (result.isConfirmed) {
                        $.ajax({
                            method: 'DELETE',
                            url: `${url}/${id}`,
                            dataType: 'JSON',
                            success: function(response){
                                showToast('success', response.message);
                                dt_table.ajax.reload();
                            },
                            error: function(xhr, status, error){
                                showToast('danger', error.message);
                            }
                        })
                    }
                });
            }

            /**
             * Updates an existing item on the server with new data.
             *
             * @param {string|number} id - The unique identifier of the item to be updated.
             * @param {Object} newData - The data to update the item with.
             * @param {string} url - The base URL for the API endpoint.
             * @return {void} This function does not return a value.
             */
            function editThing(id, newData, url){
                $.ajax({
                    method: 'PUT',
                    url: `${url}/${id}`,
                    data: newData,
                    dataType: 'JSON',
                    success: function(response){
                        showToast('success', response.message);
                        dt_table.ajax.reload();
                    },
                })
            }

            function wip()
            {
                showToast('info', 'El lunes sin falta carnal');
            }
        </script>
        <?= $this->renderSection('scripts') ?>
    </body>
</html>
