<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Create Article')) ?>

        <!-- Quill Plugin CSS -->
        <link href="/plugins/quill/quill.core.css" rel="stylesheet" type="text/css" />
        <link href="/plugins/quill/quill.snow.css" rel="stylesheet" type="text/css" />

        <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Blog', 'title' => 'Create Article')) ?>

                    <div class="container-xxl">
                        <div class="row justify-content-center">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header justify-content-between">
                                        <h5 class="mb-0">Create New Blog Post</h5>
                                        <small class="text-muted">Last saved: just now</small>
                                    </div>
                                    <div class="card-body">
                                        <form>
                                            <!-- Post Title -->
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold" for="title">Post Title</label>
                                                <input class="form-control" id="title" placeholder="Enter your blog title" required="" type="text" />
                                            </div>
                                            <!-- Slug -->
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold" for="slug">Slug</label>
                                                <input class="form-control" id="slug" placeholder="e.g. how-to-build-a-blog-with-bootstrap" type="text" />
                                            </div>
                                            <!-- Author & Publish Date -->
                                            <div class="row g-3">
                                                <div class="col-md-6">
                                                    <label class="form-label fw-semibold" for="author">Author</label>
                                                    <input class="form-control" id="author" placeholder="Enter author name" type="text" />
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label fw-semibold" for="publishDate">Publish Date &amp; Time</label>
                                                    <input class="form-control flatpickr-input" data-date-format="d M, Y" data-enable-time="" data-provider="flatpickr" id="publishDate" type="text" />
                                                </div>
                                            </div>
                                            <!-- Category -->
                                            <div class="mb-3 mt-3">
                                                <label class="form-label fw-semibold" for="category">Category</label>
                                                <select class="form-select" id="category">
                                                    <option disabled="" selected="">Select category</option>
                                                    <option>Technology</option>
                                                    <option>Design</option>
                                                    <option>Development</option>
                                                    <option>Business</option>
                                                    <option>Lifestyle</option>
                                                </select>
                                            </div>
                                            <!-- Featured Image -->
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold" for="image">Featured Image</label>
                                                <input class="form-control" id="image" type="file" />
                                                <small class="text-muted">Recommended size: 1200x600px</small>
                                            </div>
                                            <!-- Content -->
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold">Post Content</label>
                                                <div id="snow-editor" style="height: 300px">
                                                    <h3>Create, manage, and publish engaging blog articles effortlessly.</h3>
                                                    <p><br /></p>
                                                    <ul>
                                                        <li>Write and format posts with an intuitive rich-text editor.</li>
                                                        <li>Organize articles by categories, tags, and authors for easy navigation.</li>
                                                        <li>Built-in SEO tools to help your content rank higher on search engines.</li>
                                                        <li>Preview articles before publishing to ensure perfect layout and style.</li>
                                                        <li>Fully responsive design ensures your blog looks great on any device.</li>
                                                    </ul>
                                                    <p><br /></p>
                                                    <p>The Blog Article module helps you create professional-looking posts quickly. Ideal for personal blogs, news platforms, or content-driven websites.</p>
                                                </div>
                                            </div>
                                            <!-- Excerpt -->
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold" for="excerpt">Excerpt (Short Summary)</label>
                                                <textarea class="form-control" id="excerpt" placeholder="Enter a short summary for your post..." rows="2"></textarea>
                                            </div>
                                            <!-- Tags -->
                                            <div class="mb-3">
                                                <label class="form-label fw-semibold" for="tags">Tags</label>
                                                <input class="form-control" id="tags" placeholder="e.g. bootstrap, web design, ui, frontend" type="text" />
                                                <small class="text-muted">Separate tags with commas.</small>
                                            </div>
                                            <!-- SEO Settings -->
                                            <div class="border-top pt-3 mt-4">
                                                <h5 class="fw-bold text-uppercase mb-3 text-muted fs-sm">SEO Settings</h5>
                                                <div class="mb-3">
                                                    <label class="form-label" for="metaTitle">Meta Title</label>
                                                    <input class="form-control" id="metaTitle" placeholder="Enter SEO title" type="text" />
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label" for="metaDescription">Meta Description</label>
                                                    <textarea class="form-control" id="metaDescription" placeholder="Short description for search engines" rows="2"></textarea>
                                                </div>
                                                <div class="mb-3">
                                                    <label class="form-label" for="metaKeywords">Meta Keywords</label>
                                                    <input class="form-control" id="metaKeywords" placeholder="e.g. blog, bootstrap, tutorial" type="text" />
                                                </div>
                                            </div>
                                            <!-- Visibility -->
                                            <div class="border-top pt-3 mt-4">
                                                <h5 class="fw-bold text-uppercase mb-3 text-muted fs-sm">Visibility</h5>
                                                <div class="form-check form-switch mb-2">
                                                    <input class="form-check-input" id="featured" type="checkbox" />
                                                    <label class="form-check-label" for="featured">Mark as Featured Post</label>
                                                </div>
                                                <div class="form-check form-switch">
                                                    <input checked="" class="form-check-input" id="commentsEnabled" type="checkbox" />
                                                    <label class="form-check-label" for="commentsEnabled">Allow Comments</label>
                                                </div>
                                            </div>
                                            <!-- Status -->
                                            <div class="mt-4 mb-3">
                                                <label class="form-label fw-semibold">Status</label>
                                                <div>
                                                    <div class="form-check form-check-inline">
                                                        <input checked="" class="form-check-input" id="draft" name="status" type="radio" value="draft" />
                                                        <label class="form-check-label" for="draft">Draft</label>
                                                    </div>
                                                    <div class="form-check form-check-inline">
                                                        <input class="form-check-input" id="published" name="status" type="radio" value="published" />
                                                        <label class="form-check-label" for="published">Published</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Buttons -->
                                            <div class="d-flex justify-content-center gap-2 mt-3">
                                                <button class="btn btn-outline-secondary" type="reset">Reset</button>
                                                <button class="btn btn-success" type="submit">Save as Draft</button>
                                                <button class="btn btn-primary" type="submit">Publish Post</button>
                                            </div>
                                        </form>
                                    </div>
                                    <!-- end card-body-->
                                </div>
                                <!-- end card-->
                            </div>
                            <!-- end col-->
                        </div>
                        <!-- end row-->
                    </div>
                </div>
                <!-- container-fluid -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Quill Editor Js -->
        <script src="/plugins/quill/quill.js"></script>
        <!-- Quill Demo Js -->
        <script src="/js/pages/form-quilljs.js"></script>
    </body>
</html>
