<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Blog Article')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Blog', 'title' => 'Article')) ?>

                    <div class="row justify-content-center">
                        <div class="col-xxl-12">
                            <div class="card">
                                <div class="card-body p-lg-5">
                                    <div class="row g-5">
                                        <!-- Main content START -->
                                        <div class="col-lg-8">
                                            <!-- Title -->
                                            <h1 class="h3 mb-0">Mastering the Art of Focus: Tools &amp; Strategies for Deep Work</h1>
                                            <!-- Action -->
                                            <p class="d-flex flex-wrap gap-3 text-muted mb-0 mt-3 align-items-center fs-base">
                                                <span class="badge text-bg-dark badge-label">Productivity</span>
                                                <span class="d-flex align-items-center gap-1">
                                                    <i class="ti ti-calendar fs-md"></i>
                                                    Mar 18, 2025
                                                </span>
                                                <span class="d-flex align-items-center gap-1">
                                                    <i class="ti ti-message-circle fs-md"></i>
                                                    <a class="link-reset" href="#!">42</a>
                                                </span>
                                                <span class="d-flex align-items-center gap-1">
                                                    <i class="ti ti-eye fs-md"></i>
                                                    982
                                                </span>
                                            </p>
                                            <!-- Image -->
                                            <img alt="blog-img" class="img-fluid rounded mt-4" src="/images/blog/blog-post.jpg" />
                                            <div class="fs-md">
                                                <!-- Content -->
                                                <p class="mt-4">
                                                    In a world full of constant notifications and distractions, developing the ability to focus has become a superpower. This article dives into proven methods for cultivating deep work and staying productive in a digital age.
                                                </p>
                                                <p>
                                                    Eliminating distractions and building a workflow that encourages uninterrupted focus can drastically improve your efficiency. Whether you're coding, writing, or designing — deep work leads to higher quality output and greater
                                                    satisfaction.
                                                </p>
                                                <p>
                                                    Some effective strategies include time-blocking your calendar, using tools like Pomodoro timers, and creating a distraction-free workspace. Even just 90 minutes of intentional, focused work per day can compound into massive
                                                    progress over time.
                                                </p>
                                                <p class="mb-0">
                                                    By embracing stillness and training your attention,
                                                    <mark>you’ll uncover a new level of clarity and creativity</mark>
                                                    that transforms how you work and what you’re capable of achieving.
                                                </p>
                                            </div>
                                            <!-- Helpful box -->
                                            <div class="bg-light-subtle border border-light rounded d-md-flex justify-content-between align-items-center text-center p-3 mt-5">
                                                <!-- Title -->
                                                <h5 class="mb-0">Was this article helpful?</h5>
                                                <p class="py-3 p-md-0 mb-0">
                                                    <b>41</b>
                                                    out of
                                                    <b>72</b>
                                                    found this helpful
                                                </p>
                                                <!-- Check buttons -->
                                                <div aria-label="Basic radio toggle button group" class="btn-group" role="group">
                                                    <!-- Yes button -->
                                                    <input class="btn-check" id="btnradio1" name="btnradio" type="radio" />
                                                    <label class="btn btn-soft-success btn-sm mb-0" for="btnradio1">
                                                        <i class="ti ti-thumb-up me-1"></i>
                                                        Yes
                                                    </label>
                                                    <!-- No button -->
                                                    <input class="btn-check" id="btnradio2" name="btnradio" type="radio" />
                                                    <label class="btn btn-soft-danger btn-sm mb-0" for="btnradio2">
                                                        No
                                                        <i class="ti ti-thumb-down ms-1"></i>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="d-flex align-items-center gap-4 border mt-4 border-dashed p-4 rounded mb-14">
                                                <div class="text-center flex-shrink-0 me-7 me-lg-13">
                                                    <div class="mb-2">
                                                        <img alt="" class="avatar-xl rounded-circle" src="/images/users/user-1.jpg" />
                                                    </div>
                                                    <div class="mb-0">
                                                        <a class="fw-bold fs-sm" href="#!">Nathan Brooks</a>
                                                        <span class="text-muted fs-6 fw-semibold d-block mt-1">Productivity Coach</span>
                                                    </div>
                                                </div>
                                                <div class="mb-0">
                                                    <div class="text-muted fw-medium lh-base mb-2">
                                                        Nathan is passionate about helping creators, developers, and entrepreneurs reclaim their time and do meaningful work. He writes regularly about mindful productivity and digital wellness.
                                                    </div>
                                                    <a class="fw-semibold link-primary" href="#!">Author’s Profile</a>
                                                </div>
                                            </div>
                                            <div class="my-4 text-center">
                                                <h5 class="mb-3 text-uppercase fw-bold">Share This:</h5>
                                                <div class="d-flex justify-content-center gap-2 mt-4 mb-2">
                                                    <a class="btn btn-icon rounded-circle btn-primary" href="#!" title="Facebook">
                                                        <svg
                                                            class="icon icon-tabler icons-tabler-outline icon-tabler-brand-facebook"
                                                            fill="none"
                                                            height="18"
                                                            stroke="currentColor"
                                                            stroke-linecap="round"
                                                            stroke-linejoin="round"
                                                            stroke-width="2"
                                                            viewbox="0 0 24 24"
                                                            width="18"
                                                            xmlns="http://www.w3.org/2000/svg"
                                                        >
                                                            <path d="M0 0h24v24H0z" fill="none" stroke="none"></path>
                                                            <path d="M7 10v4h3v7h4v-7h3l1 -4h-4v-2a1 1 0 0 1 1 -1h3v-4h-3a5 5 0 0 0 -5 5v2h-3"></path>
                                                        </svg>
                                                    </a>
                                                    <a class="btn btn-icon rounded-circle btn-info" href="#!" title="Twitter-x">
                                                        <svg
                                                            class="icon icon-tabler icons-tabler-outline icon-tabler-brand-x"
                                                            fill="none"
                                                            height="18"
                                                            stroke="currentColor"
                                                            stroke-linecap="round"
                                                            stroke-linejoin="round"
                                                            stroke-width="2"
                                                            viewbox="0 0 24 24"
                                                            width="18"
                                                            xmlns="http://www.w3.org/2000/svg"
                                                        >
                                                            <path d="M0 0h24v24H0z" fill="none" stroke="none"></path>
                                                            <path d="M4 4l11.733 16h4.267l-11.733 -16z"></path>
                                                            <path d="M4 20l6.768 -6.768m2.46 -2.46l6.772 -6.772"></path>
                                                        </svg>
                                                    </a>
                                                    <a class="btn btn-icon rounded-circle btn-danger" href="#!" title="Instagram">
                                                        <svg
                                                            class="icon icon-tabler icons-tabler-outline icon-tabler-brand-instagram"
                                                            fill="none"
                                                            height="18"
                                                            stroke="currentColor"
                                                            stroke-linecap="round"
                                                            stroke-linejoin="round"
                                                            stroke-width="2"
                                                            viewbox="0 0 24 24"
                                                            width="18"
                                                            xmlns="http://www.w3.org/2000/svg"
                                                        >
                                                            <path d="M0 0h24v24H0z" fill="none" stroke="none"></path>
                                                            <path d="M4 8a4 4 0 0 1 4 -4h8a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-8a4 4 0 0 1 -4 -4z"></path>
                                                            <path d="M9 12a3 3 0 1 0 6 0a3 3 0 0 0 -6 0"></path>
                                                            <path d="M16.5 7.5v.01"></path>
                                                        </svg>
                                                    </a>
                                                    <a class="btn btn-icon rounded-circle btn-success" href="#!" title="Dribbble">
                                                        <svg
                                                            class="icon icon-tabler icons-tabler-outline icon-tabler-brand-dribbble"
                                                            fill="none"
                                                            height="18"
                                                            stroke="currentColor"
                                                            stroke-linecap="round"
                                                            stroke-linejoin="round"
                                                            stroke-width="2"
                                                            viewbox="0 0 24 24"
                                                            width="18"
                                                            xmlns="http://www.w3.org/2000/svg"
                                                        >
                                                            <path d="M0 0h24v24H0z" fill="none" stroke="none"></path>
                                                            <path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"></path>
                                                            <path d="M9 3.6c5 6 7 10.5 7.5 16.2"></path>
                                                            <path d="M6.4 19c3.5 -3.5 6 -6.5 14.5 -6.4"></path>
                                                            <path d="M3.1 10.75c5 0 9.814 -.38 15.314 -5"></path>
                                                        </svg>
                                                    </a>
                                                    <a class="btn btn-icon rounded-circle btn-secondary" href="#!" title="LinkedIn">
                                                        <svg
                                                            class="icon icon-tabler icons-tabler-outline icon-tabler-brand-linkedin"
                                                            fill="none"
                                                            height="18"
                                                            stroke="currentColor"
                                                            stroke-linecap="round"
                                                            stroke-linejoin="round"
                                                            stroke-width="2"
                                                            viewbox="0 0 24 24"
                                                            width="18"
                                                            xmlns="http://www.w3.org/2000/svg"
                                                        >
                                                            <path d="M0 0h24v24H0z" fill="none" stroke="none"></path>
                                                            <path d="M8 11v5"></path>
                                                            <path d="M8 8v.01"></path>
                                                            <path d="M12 16v-5"></path>
                                                            <path d="M16 16v-3a2 2 0 1 0 -4 0"></path>
                                                            <path d="M3 7a4 4 0 0 1 4 -4h10a4 4 0 0 1 4 4v10a4 4 0 0 1 -4 4h-10a4 4 0 0 1 -4 -4z"></path>
                                                        </svg>
                                                    </a>
                                                    <a class="btn btn-icon rounded-circle btn-danger" href="#!" title="YouTube">
                                                        <svg
                                                            class="icon icon-tabler icons-tabler-outline icon-tabler-brand-youtube"
                                                            fill="none"
                                                            height="18"
                                                            stroke="currentColor"
                                                            stroke-linecap="round"
                                                            stroke-linejoin="round"
                                                            stroke-width="2"
                                                            viewbox="0 0 24 24"
                                                            width="18"
                                                            xmlns="http://www.w3.org/2000/svg"
                                                        >
                                                            <path d="M0 0h24v24H0z" fill="none" stroke="none"></path>
                                                            <path d="M2 8a4 4 0 0 1 4 -4h12a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-12a4 4 0 0 1 -4 -4v-8z"></path>
                                                            <path d="M10 9l5 3l-5 3z"></path>
                                                        </svg>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Main content END -->
                                        <!-- Sidebar START -->
                                        <div class="col-lg-4">
                                            <h5 class="mb-3 text-uppercase fw-bold">Search</h5>
                                            <div class="app-search">
                                                <input class="form-control bg-light-subtle border-light" placeholder="Search post..." type="text" />
                                                <i class="ti ti-search app-search-icon text-muted"></i>
                                            </div>
                                            <!-- Related post -->
                                            <div class="align-items-center mt-5">
                                                <h5 class="mb-3 text-uppercase fw-bold">Related post:</h5>
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item ps-0">
                                                        <a class="link-reset fw-medium" href="#">
                                                            <i class="ti ti-article me-2"></i>
                                                            Unlocking the Secrets of Modern UI Design
                                                        </a>
                                                    </li>
                                                    <li class="list-group-item ps-0">
                                                        <a class="link-reset fw-medium" href="#">
                                                            <i class="ti ti-article me-2"></i>
                                                            How to Build a Portfolio with Tailwind CSS
                                                        </a>
                                                    </li>
                                                    <li class="list-group-item ps-0">
                                                        <a class="link-reset fw-medium" href="#">
                                                            <i class="ti ti-article me-2"></i>
                                                            Boost Productivity with These Web Dev Tools
                                                        </a>
                                                    </li>
                                                    <li class="list-group-item ps-0">
                                                        <a class="link-reset fw-medium" href="#">
                                                            <i class="ti ti-article me-2"></i>
                                                            The Future of Frontend: Trends to Watch in 2025
                                                        </a>
                                                    </li>
                                                    <li class="list-group-item ps-0">
                                                        <a class="link-reset fw-medium" href="#">
                                                            <i class="ti ti-article me-2"></i>
                                                            Essential Tips for Clean and Maintainable Code
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                            <!-- Popular tags -->
                                            <div class="align-items-center my-5">
                                                <h5 class="mb-3 text-uppercase fw-bold">Popular Tags:</h5>
                                                <div class="d-flex flex-wrap gap-1">
                                                    <a class="btn btn-light btn-sm" href="#">Web Design</a>
                                                    <a class="btn btn-light btn-sm" href="#">Frontend</a>
                                                    <a class="btn btn-light btn-sm" href="#">Tailwind CSS</a>
                                                    <a class="btn btn-light btn-sm" href="#">JavaScript</a>
                                                    <a class="btn btn-light btn-sm" href="#">React</a>
                                                    <a class="btn btn-light btn-sm" href="#">Startup</a>
                                                    <a class="btn btn-light btn-sm" href="#">DevTools</a>
                                                    <a class="btn btn-light btn-sm" href="#">Open Source</a>
                                                    <a class="btn btn-light btn-sm" href="#">Performance</a>
                                                    <a class="btn btn-light btn-sm" href="#">UX/UI</a>
                                                    <a class="btn btn-light btn-sm" href="#">SEO</a>
                                                </div>
                                            </div>
                                            <!-- Newsletter -->
                                            <div class="p-4 bg-light-subtle rounded-3 border">
                                                <h5 class="text-uppercase fw-bold mb-3">Subscribe to Newsletter</h5>
                                                <p class="text-muted fs-sm mb-3">Get the latest articles and updates directly to your inbox.</p>
                                                <form action="#">
                                                    <div class="input-group">
                                                        <input class="form-control" placeholder="Your email address" type="email" />
                                                        <button class="btn btn-dark" type="submit"><i class="ti ti-send-2"></i></button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <!-- Sidebar END -->
                                    </div>
                                    <!-- Row END -->
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
