<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Clients')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Apps', 'title' => 'Clients')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="8">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search clients..." type="text" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                        <button class="btn btn-secondary btn-icon" data-bs-target="#addClientModal" data-bs-toggle="modal" type="button">
                                            <i class="ti ti-plus fs-lg"></i>
                                        </button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Country Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="country">
                                                <option value="All">Country</option>
                                                <option value="US">USA</option>
                                                <option value="UK">UK</option>
                                                <option value="AU">Australia</option>
                                                <option value="DE">Germany</option>
                                                <option value="IN">India</option>
                                            </select>
                                            <i class="ti ti-world app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Project Type Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="type">
                                                <option value="All">Project Type</option>
                                                <option value="Project">Project</option>
                                                <option value="Contract">Contract</option>
                                                <option value="Retainer">Retainer</option>
                                                <option value="Dashboard">Dashboard</option>
                                            </select>
                                            <i class="ti ti-briefcase app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-custom table-centered table-select table-hover w-100 mb-0">
                                        <thead class="bg-light bg-opacity-25 thead-sm">
                                            <tr class="text-uppercase fs-xxs">
                                                <th scope="col" style="width: 1%">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" id="checkAll" type="checkbox" value="option" />
                                                </th>
                                                <th data-table-sort="name">Clients Name</th>
                                                <th data-table-sort="">Phone</th>
                                                <th data-column="country" data-table-sort="">Country</th>
                                                <th data-table-sort="">Enrolled</th>
                                                <th data-column="type" data-table-sort="">Type</th>
                                                <th data-table-sort="">Job Title</th>
                                                <th data-table-sort="">Status</th>
                                                <th class="text-center">Actions</th>
                                            </tr>
                                        </thead>
                                        <!-- end table-head -->
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="avatar-7" class="img-fluid rounded-circle" src="/images/users/user-7.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="text-nowrap mb-0 lh-base fs-base">
                                                                <a class="link-reset" data-sort="name" href="#!">Emily Parker</a>
                                                            </h5>
                                                            <p class="text-muted fs-xs mb-0">emily@startupwave.io</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+1 (415) 992-3412</td>
                                                <td>
                                                    <span class="d-flex align-items-center fs-sm fw-bold">
                                                        <img alt="" class="rounded-circle me-1" height="12" src="/images/flags/us.svg" />
                                                        US
                                                    </span>
                                                </td>
                                                <td>Feb 2, 2024</td>
                                                <td>Project</td>
                                                <td>Frontend Developer</td>
                                                <td>
                                                    <span class="badge bg-success-subtle text-success badge-label">Active</span>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="avatar-3" class="img-fluid rounded-circle" src="/images/users/user-3.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="text-nowrap mb-0 lh-base fs-base">
                                                                <a class="link-reset" data-sort="name" href="#!">Liam Scott</a>
                                                            </h5>
                                                            <p class="text-muted fs-xs mb-0">liam@creativelogic.net</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+44 20 7946 0958</td>
                                                <td>
                                                    <span class="d-flex align-items-center fs-sm fw-bold">
                                                        <img alt="" class="rounded-circle me-1" height="12" src="/images/flags/gb.svg" />
                                                        UK
                                                    </span>
                                                </td>
                                                <td>Jan 15, 2024</td>
                                                <td>Contract</td>
                                                <td>UI/UX Designer</td>
                                                <td>
                                                    <span class="badge bg-warning-subtle text-warning badge-label">Pending</span>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="avatar-4" class="img-fluid rounded-circle" src="/images/users/user-4.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="text-nowrap mb-0 lh-base fs-base">
                                                                <a class="link-reset" data-sort="name" href="#!">Sofia Müller</a>
                                                            </h5>
                                                            <p class="text-muted fs-xs mb-0">sofia@designhub.de</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+49 89 1234 5678</td>
                                                <td>
                                                    <span class="d-flex align-items-center fs-sm fw-bold">
                                                        <img alt="" class="rounded-circle me-1" height="12" src="/images/flags/de.svg" />
                                                        DE
                                                    </span>
                                                </td>
                                                <td>Mar 12, 2024</td>
                                                <td>Project</td>
                                                <td>Visual Designer</td>
                                                <td>
                                                    <span class="badge bg-success-subtle text-success badge-label">Active</span>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="avatar-5" class="img-fluid rounded-circle" src="/images/users/user-5.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="text-nowrap mb-0 lh-base fs-base">
                                                                <a class="link-reset" data-sort="name" href="#!">Carlos Méndez</a>
                                                            </h5>
                                                            <p class="text-muted fs-xs mb-0">carlos@techlaunch.mx</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+52 55 1234 9876</td>
                                                <td>
                                                    <span class="d-flex align-items-center fs-sm fw-bold">
                                                        <img alt="" class="rounded-circle me-1" height="12" src="/images/flags/mx.svg" />
                                                        MX
                                                    </span>
                                                </td>
                                                <td>Jan 8, 2024</td>
                                                <td>Contract</td>
                                                <td>Full Stack Developer</td>
                                                <td>
                                                    <span class="badge bg-danger-subtle text-danger badge-label">Inactive</span>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="avatar-6" class="img-fluid rounded-circle" src="/images/users/user-6.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="text-nowrap mb-0 lh-base fs-base">
                                                                <a class="link-reset" data-sort="name" href="#!">Nina Patel</a>
                                                            </h5>
                                                            <p class="text-muted fs-xs mb-0">nina@pixelhype.in</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+91 99876 54321</td>
                                                <td>
                                                    <span class="d-flex align-items-center fs-sm fw-bold">
                                                        <img alt="" class="rounded-circle me-1" height="12" src="/images/flags/in.svg" />
                                                        IN
                                                    </span>
                                                </td>
                                                <td>Feb 19, 2024</td>
                                                <td>Project</td>
                                                <td>Brand Strategist</td>
                                                <td>
                                                    <span class="badge bg-success-subtle text-success badge-label">Active</span>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="avatar-8" class="img-fluid rounded-circle" src="/images/users/user-8.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="text-nowrap mb-0 lh-base fs-base">
                                                                <a class="link-reset" data-sort="name" href="#!">Oliver Chen</a>
                                                            </h5>
                                                            <p class="text-muted fs-xs mb-0">oliver@brandflow.sg</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+65 6789 1234</td>
                                                <td>
                                                    <span class="d-flex align-items-center fs-sm fw-bold">
                                                        <img alt="" class="rounded-circle me-1" height="12" src="/images/flags/sg.svg" />
                                                        SG
                                                    </span>
                                                </td>
                                                <td>Jan 30, 2024</td>
                                                <td>Retainer</td>
                                                <td>Creative Director</td>
                                                <td>
                                                    <span class="badge bg-warning-subtle text-warning badge-label">Pending</span>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="avatar-9" class="img-fluid rounded-circle" src="/images/users/user-9.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="text-nowrap mb-0 lh-base fs-base">
                                                                <a class="link-reset" data-sort="name" href="#!">Maya Tanaka</a>
                                                            </h5>
                                                            <p class="text-muted fs-xs mb-0">maya@visiontokyo.jp</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+81 3 1234 5678</td>
                                                <td>
                                                    <span class="d-flex align-items-center fs-sm fw-bold">
                                                        <img alt="" class="rounded-circle me-1" height="12" src="/images/flags/jp.svg" />
                                                        JP
                                                    </span>
                                                </td>
                                                <td>Mar 5, 2024</td>
                                                <td>Project</td>
                                                <td>Product Designer</td>
                                                <td>
                                                    <span class="badge bg-success-subtle text-success badge-label">Active</span>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="avatar-10" class="img-fluid rounded-circle" src="/images/users/user-10.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="text-nowrap mb-0 lh-base fs-base">
                                                                <a class="link-reset" data-sort="name" href="#!">Lucas Ferreira</a>
                                                            </h5>
                                                            <p class="text-muted fs-xs mb-0">lucas@devstudio.br</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+55 11 99876 5432</td>
                                                <td>
                                                    <span class="d-flex align-items-center fs-sm fw-bold">
                                                        <img alt="" class="rounded-circle me-1" height="12" src="/images/flags/br.svg" />
                                                        BR
                                                    </span>
                                                </td>
                                                <td>Feb 24, 2024</td>
                                                <td>Contract</td>
                                                <td>Backend Engineer</td>
                                                <td>
                                                    <span class="badge bg-success-subtle text-success badge-label">Active</span>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="avatar-1" class="img-fluid rounded-circle" src="/images/users/user-1.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="text-nowrap mb-0 lh-base fs-base">
                                                                <a class="link-reset" data-sort="name" href="#!">Anna Schmidt</a>
                                                            </h5>
                                                            <p class="text-muted fs-xs mb-0">anna@uxhaus.de</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+49 30 4567 8910</td>
                                                <td>
                                                    <span class="d-flex align-items-center fs-sm fw-bold">
                                                        <img alt="" class="rounded-circle me-1" height="12" src="/images/flags/de.svg" />
                                                        DE
                                                    </span>
                                                </td>
                                                <td>Mar 9, 2024</td>
                                                <td>Retainer</td>
                                                <td>UX Consultant</td>
                                                <td>
                                                    <span class="badge bg-warning-subtle text-warning badge-label">Pending</span>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="avatar-2" class="img-fluid rounded-circle" src="/images/users/user-2.jpg" />
                                                        </div>
                                                        <div>
                                                            <h5 class="text-nowrap mb-0 lh-base fs-base">
                                                                <a class="link-reset" data-sort="name" href="#!">Jason Lee</a>
                                                            </h5>
                                                            <p class="text-muted fs-xs mb-0">jason@webfoundry.au</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>+61 2 9876 1234</td>
                                                <td>
                                                    <span class="d-flex align-items-center fs-sm fw-bold">
                                                        <img alt="" class="rounded-circle me-1" height="12" src="/images/flags/au.svg" />
                                                        AU
                                                    </span>
                                                </td>
                                                <td>Mar 14, 2024</td>
                                                <td>Contract</td>
                                                <td>Web Developer</td>
                                                <td>
                                                    <span class="badge bg-success-subtle text-success badge-label">Active</span>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                        <!-- end table-body -->
                                    </table>
                                    <!-- end table -->
                                </div>
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="clients"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                    <!-- Add New Client Modal -->
                    <div aria-hidden="true" aria-labelledby="addClientModalLabel" class="modal fade" id="addClientModal" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title fw-bold text-uppercase" id="addClientModalLabel">Add New Client</h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <form id="addClientForm">
                                    <div class="modal-body">
                                        <div class="row g-3">
                                            <!-- Client Name -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="clientName">Client Name</label>
                                                <input class="form-control" id="clientName" name="client_name" placeholder="Enter full name" required="" type="text" />
                                            </div>
                                            <!-- Email -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="clientEmail">Email</label>
                                                <input class="form-control" id="clientEmail" name="email" placeholder="client@example.com" required="" type="email" />
                                            </div>
                                            <!-- Phone -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="clientPhone">Phone</label>
                                                <input class="form-control" id="clientPhone" name="phone" placeholder="+1 (000) 000-0000" type="tel" />
                                            </div>
                                            <!-- Country -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="clientCountry">Country</label>
                                                <select class="form-select" id="clientCountry" name="country" required="">
                                                    <option value="">Select country...</option>
                                                    <option value="US">United States</option>
                                                    <option value="UK">United Kingdom</option>
                                                    <option value="DE">Germany</option>
                                                    <option value="MX">Mexico</option>
                                                    <option value="IN">India</option>
                                                    <!-- add more -->
                                                </select>
                                            </div>
                                            <!-- Enrolled Date -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="clientEnrolled">Enrolled Date</label>
                                                <input class="form-control flatpickr-input" data-altformat="F j, Y" data-provider="flatpickr" id="clientEnrolled" name="enrolled_date" type="date" />
                                            </div>
                                            <!-- Type -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="clientType">Type</label>
                                                <select class="form-select" id="clientType" name="type" required="">
                                                    <option value="">Select type...</option>
                                                    <option value="Project">Project</option>
                                                    <option value="Contract">Contract</option>
                                                </select>
                                            </div>
                                            <!-- Job Title -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="clientJobTitle">Job Title</label>
                                                <input class="form-control" id="clientJobTitle" name="job_title" placeholder="Frontend Developer" type="text" />
                                            </div>
                                            <!-- Status -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="clientStatus">Status</label>
                                                <select class="form-select" id="clientStatus" name="status">
                                                    <option value="Active">Active</option>
                                                    <option selected="" value="Pending">Pending</option>
                                                    <option value="Inactive">Inactive</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn btn-light" data-bs-dismiss="modal" type="button">Cancel</button>
                                        <button class="btn btn-primary" type="submit">Add Client</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
