<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Product Stocks')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Ecommerce', 'title' => 'Stocks')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="10">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search product name or SKU..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Category Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="category">
                                                <option value="All">Category</option>
                                                <option value="Electronics">Electronics</option>
                                                <option value="Mobiles">Mobiles</option>
                                                <option value="Audio">Audio</option>
                                                <option value="Furniture">Furniture</option>
                                                <option value="Appliances">Appliances</option>
                                                <option value="Wearables">Wearables</option>
                                                <option value="Cameras">Cameras</option>
                                                <option value="Computers">Computers</option>
                                                <option value="Accessories">Accessories</option>
                                            </select>
                                            <i class="ti ti-tag app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Stock Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="status">
                                                <option value="All">Stock Status</option>
                                                <option value="In Stock">In Stock</option>
                                                <option value="Low Stock">Low Stock</option>
                                                <option value="Out of Stock">Out of Stock</option>
                                            </select>
                                            <i class="ti ti-activity app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Price Range Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-range-filter="price">
                                                <option value="All">Price Range</option>
                                                <option value="0-50">$0 - $50</option>
                                                <option value="51-150">$51 - $150</option>
                                                <option value="151-500">$151 - $500</option>
                                                <option value="501-1000">$501 - $1,000</option>
                                                <option value="1000+">$1,000+</option>
                                            </select>
                                            <i class="ti ti-currency-dollar app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="d-flex gap-1">
                                        <a class="btn btn-danger ms-1" href="/apps-ecommerce-product-add">
                                            <i class="ti ti-plus fs-sm me-2"></i>
                                            Add Product
                                        </a>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-custom table-centered table-select table-hover w-100 mb-0">
                                        <thead class="bg-light align-middle bg-opacity-25 thead-sm">
                                            <tr class="text-uppercase fs-xxs">
                                                <th class="ps-3" style="width: 1%">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" id="select-all-products" type="checkbox" value="option" />
                                                </th>
                                                <th data-table-sort="">Product</th>
                                                <th>SKU</th>
                                                <th data-column="category" data-table-sort="">Category</th>
                                                <th data-table-sort="">Available Stock</th>
                                                <th data-table-sort="">Low Stock</th>
                                                <th data-column="price" data-table-sort="">Unit Price</th>
                                                <th data-column="status" data-table-sort="">Stock Status</th>
                                                <th data-table-sort="">Last Updated</th>
                                                <th class="text-center" style="width: 1%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Product Row -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" value="option" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/1.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1">
                                                                <a class="link-reset" data-sort="product" href="/apps-ecommerce-product-details">Smart LED TV 55"</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xs">Supplier: VisionTech</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>STK-1001</td>
                                                <td>Electronics</td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-success">320</h5></td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-danger">24</h5></td>
                                                <td>$749.00</td>
                                                <td>
                                                    <span class="badge badge-label badge-soft-success fs-xxs">In Stock</span>
                                                </td>
                                                <td>
                                                    08 Oct, 2025
                                                    <small class="text-muted">10:30 AM</small>
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="/apps-ecommerce-product-details">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/2.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1">
                                                                <a class="link-reset" href="/apps-ecommerce-product-details">Wireless Noise Cancel Headphones</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xs">Supplier: SoundMax</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>STK-1002</td>
                                                <td>Audio</td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-success">220</h5></td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-warning">15</h5></td>
                                                <td>$199.00</td>
                                                <td><span class="badge badge-label badge-soft-success fs-xxs">In Stock</span></td>
                                                <td>
                                                    07 Oct, 2025
                                                    <small class="text-muted">02:45 PM</small>
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/3.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1">
                                                                <a class="link-reset" href="/apps-ecommerce-product-details">Ergonomic Office Chair</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xs">Supplier: ComfortLine</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>STK-1003</td>
                                                <td>Furniture</td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-danger">0</h5></td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-danger">0</h5></td>
                                                <td>$249.00</td>
                                                <td><span class="badge badge-label badge-soft-danger fs-xxs">Out of Stock</span></td>
                                                <td>
                                                    06 Oct, 2025
                                                    <small class="text-muted">09:10 AM</small>
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/4.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1">
                                                                <a class="link-reset" href="/apps-ecommerce-product-details">Smartphone 12 Pro</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xs">Supplier: TechNova</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>STK-1004</td>
                                                <td>Mobiles</td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-success">510</h5></td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-danger">30</h5></td>
                                                <td>$999.00</td>
                                                <td><span class="badge badge-label badge-soft-success fs-xxs">In Stock</span></td>
                                                <td>
                                                    05 Oct, 2025
                                                    <small class="text-muted">04:00 PM</small>
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/5.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1">
                                                                <a class="link-reset" href="/apps-ecommerce-product-details">Bluetooth Speaker Mini</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xs">Supplier: AudioPro</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>STK-1005</td>
                                                <td>Audio</td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-success">420</h5></td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-warning">25</h5></td>
                                                <td>$79.00</td>
                                                <td><span class="badge badge-label badge-soft-success fs-xxs">In Stock</span></td>
                                                <td>
                                                    04 Oct, 2025
                                                    <small class="text-muted">01:20 PM</small>
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/6.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1">
                                                                <a class="link-reset" href="/apps-ecommerce-product-details">Portable Air Cooler</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xs">Supplier: CoolWave</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>STK-1006</td>
                                                <td>Appliances</td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-success">85</h5></td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-danger">8</h5></td>
                                                <td>$129.00</td>
                                                <td><span class="badge badge-label badge-soft-warning fs-xxs">Low Stock</span></td>
                                                <td>
                                                    03 Oct, 2025
                                                    <small class="text-muted">11:05 AM</small>
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/7.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1">
                                                                <a class="link-reset" href="/apps-ecommerce-product-details">Gaming Laptop GTX 4070</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xs">Supplier: ByteForce</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>STK-1007</td>
                                                <td>Computers</td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-success">90</h5></td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-danger">6</h5></td>
                                                <td>$1,899.00</td>
                                                <td><span class="badge badge-label badge-soft-success fs-xxs">In Stock</span></td>
                                                <td>
                                                    02 Oct, 2025
                                                    <small class="text-muted">05:15 PM</small>
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/8.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1">
                                                                <a class="link-reset" href="/apps-ecommerce-product-details">Wireless Mouse Pro</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xs">Supplier: ClickTech</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>STK-1008</td>
                                                <td>Accessories</td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-success">410</h5></td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-warning">20</h5></td>
                                                <td>$49.00</td>
                                                <td><span class="badge badge-label badge-soft-success fs-xxs">In Stock</span></td>
                                                <td>
                                                    01 Oct, 2025
                                                    <small class="text-muted">03:40 PM</small>
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/9.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1">
                                                                <a class="link-reset" href="/apps-ecommerce-product-details">4K Action Camera</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xs">Supplier: VisionGo</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>STK-1009</td>
                                                <td>Cameras</td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-success">155</h5></td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-warning">12</h5></td>
                                                <td>$349.00</td>
                                                <td><span class="badge badge-soft-success fs-xxs">In Stock</span></td>
                                                <td>
                                                    30 Sep, 2025
                                                    <small class="text-muted">01:20 PM</small>
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/10.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1">
                                                                <a class="link-reset" href="/apps-ecommerce-product-details">Smart Fitness Watch</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xs">Supplier: FitLife</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>STK-1010</td>
                                                <td>Wearables</td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-success">240</h5></td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-danger">18</h5></td>
                                                <td>$149.00</td>
                                                <td><span class="badge badge-label badge-soft-success fs-xxs">In Stock</span></td>
                                                <td>
                                                    29 Sep, 2025
                                                    <small class="text-muted">10:45 AM</small>
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center">
                                                        <div class="avatar-md me-3">
                                                            <img alt="Product" class="img-fluid rounded" src="/images/products/3.png" />
                                                        </div>
                                                        <div>
                                                            <h5 class="mb-1">
                                                                <a class="link-reset" href="/apps-ecommerce-product-details">Cordless Vacuum Cleaner</a>
                                                            </h5>
                                                            <p class="text-muted mb-0 fs-xs">Supplier: CleanHome</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>STK-1011</td>
                                                <td>Home Appliances</td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-warning">25</h5></td>
                                                <td><h5 class="fs-base mb-0 fw-medium text-danger">5</h5></td>
                                                <td>$249.00</td>
                                                <td><span class="badge badge-label badge-soft-warning fs-xxs">Low Stock</span></td>
                                                <td>
                                                    28 Sep, 2025
                                                    <small class="text-muted">09:30 AM</small>
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="products"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
