<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Shop Settings')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Ecommerce', 'title' => 'Shop Settings')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <form>
                                        <div class="ins-wizard" data-wizard="">
                                            <div class="row">
                                                <!-- Vertical Nav -->
                                                <div class="col-md-4 col-xxl-3">
                                                    <ul class="nav flex-column wizard-bordered wizard-tabs nav-pills" data-wizard-nav="" role="tablist">
                                                        <li class="nav-item">
                                                            <a class="nav-link active" data-bs-toggle="tab" href="#shopStepGeneral">
                                                                <span class="d-flex align-items-center">
                                                                    <div class="avatar-md">
                                                                        <span class="avatar-title bg-light rounded">
                                                                            <i class="ti ti-building-store fs-24"></i>
                                                                        </span>
                                                                    </div>
                                                                    <span class="flex-grow-1 ms-2 text-truncate">
                                                                        <span class="fw-semibold text-body d-block fs-base">General Info</span>
                                                                        <span class="fs-xs mb-0">Shop basics</span>
                                                                    </span>
                                                                </span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-bs-toggle="tab" href="#shopStepStore">
                                                                <span class="d-flex align-items-center">
                                                                    <div class="avatar-md">
                                                                        <span class="avatar-title bg-light rounded">
                                                                            <i class="ti ti-building fs-24"></i>
                                                                        </span>
                                                                    </div>
                                                                    <span class="flex-grow-1 ms-2 text-truncate">
                                                                        <span class="fw-semibold text-body d-block fs-base">Store Details</span>
                                                                        <span class="fs-xs mb-0">Business info</span>
                                                                    </span>
                                                                </span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-bs-toggle="tab" href="#shopStepBranding">
                                                                <span class="d-flex align-items-center">
                                                                    <div class="avatar-md">
                                                                        <span class="avatar-title bg-light rounded">
                                                                            <i class="ti ti-palette fs-24"></i>
                                                                        </span>
                                                                    </div>
                                                                    <span class="flex-grow-1 ms-2 text-truncate">
                                                                        <span class="fw-semibold text-body d-block fs-base">Branding</span>
                                                                        <span class="fs-xs mb-0">Logo &amp; colors</span>
                                                                    </span>
                                                                </span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-bs-toggle="tab" href="#shopStepCurrency">
                                                                <span class="d-flex align-items-center">
                                                                    <div class="avatar-md">
                                                                        <span class="avatar-title bg-light rounded">
                                                                            <i class="ti ti-pig-money fs-24"></i>
                                                                        </span>
                                                                    </div>
                                                                    <span class="flex-grow-1 ms-2 text-truncate">
                                                                        <span class="fw-semibold text-body d-block fs-base">Currency &amp; Tax</span>
                                                                        <span class="fs-xs mb-0">Regional setup</span>
                                                                    </span>
                                                                </span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-bs-toggle="tab" href="#shopStepShipping">
                                                                <span class="d-flex align-items-center">
                                                                    <div class="avatar-md">
                                                                        <span class="avatar-title bg-light rounded">
                                                                            <i class="ti ti-truck fs-24"></i>
                                                                        </span>
                                                                    </div>
                                                                    <span class="flex-grow-1 ms-2 text-truncate">
                                                                        <span class="fw-semibold text-body d-block fs-base">Shipping</span>
                                                                        <span class="fs-xs mb-0">Delivery setup</span>
                                                                    </span>
                                                                </span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-bs-toggle="tab" href="#shopStepPayment">
                                                                <span class="d-flex align-items-center">
                                                                    <div class="avatar-md">
                                                                        <span class="avatar-title bg-light rounded">
                                                                            <i class="ti ti-credit-card fs-24"></i>
                                                                        </span>
                                                                    </div>
                                                                    <span class="flex-grow-1 ms-2 text-truncate">
                                                                        <span class="fw-semibold text-body d-block fs-base">Payments</span>
                                                                        <span class="fs-xs mb-0">Gateways &amp; modes</span>
                                                                    </span>
                                                                </span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-bs-toggle="tab" href="#shopStepNotifications">
                                                                <span class="d-flex align-items-center">
                                                                    <div class="avatar-md">
                                                                        <span class="avatar-title bg-light rounded">
                                                                            <i class="ti ti-bell fs-24"></i>
                                                                        </span>
                                                                    </div>
                                                                    <span class="flex-grow-1 ms-2 text-truncate">
                                                                        <span class="fw-semibold text-body d-block fs-base">Notifications</span>
                                                                        <span class="fs-xs mb-0">Emails &amp; alerts</span>
                                                                    </span>
                                                                </span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-bs-toggle="tab" href="#shopStepInvoices">
                                                                <span class="d-flex align-items-center">
                                                                    <div class="avatar-md">
                                                                        <span class="avatar-title bg-light rounded">
                                                                            <i class="ti ti-file-text fs-24"></i>
                                                                        </span>
                                                                    </div>
                                                                    <span class="flex-grow-1 ms-2 text-truncate">
                                                                        <span class="fw-semibold text-body d-block fs-base">Invoices &amp; Receipts</span>
                                                                        <span class="fs-xs mb-0">Billing templates</span>
                                                                    </span>
                                                                </span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-bs-toggle="tab" href="#shopStepLegal">
                                                                <span class="d-flex align-items-center">
                                                                    <div class="avatar-md">
                                                                        <span class="avatar-title bg-light rounded">
                                                                            <i class="ti ti-world fs-24"></i>
                                                                        </span>
                                                                    </div>
                                                                    <span class="flex-grow-1 ms-2 text-truncate">
                                                                        <span class="fw-semibold text-body d-block fs-base">SEO &amp; Legal</span>
                                                                        <span class="fs-xs mb-0">Policies &amp; SEO</span>
                                                                    </span>
                                                                </span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-bs-toggle="tab" href="#shopStepIntegrations">
                                                                <span class="d-flex align-items-center">
                                                                    <div class="avatar-md">
                                                                        <span class="avatar-title bg-light rounded">
                                                                            <i class="ti ti-plug fs-24"></i>
                                                                        </span>
                                                                    </div>
                                                                    <span class="flex-grow-1 ms-2 text-truncate">
                                                                        <span class="fw-semibold text-body d-block fs-base">Integrations</span>
                                                                        <span class="fs-xs mb-0">3rd-party apps</span>
                                                                    </span>
                                                                </span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-bs-toggle="tab" href="#shopStepBackup">
                                                                <span class="d-flex align-items-center">
                                                                    <div class="avatar-md">
                                                                        <span class="avatar-title bg-light rounded">
                                                                            <i class="ti ti-database fs-24"></i>
                                                                        </span>
                                                                    </div>
                                                                    <span class="flex-grow-1 ms-2 text-truncate">
                                                                        <span class="fw-semibold text-body d-block fs-base">Backup &amp; Restore</span>
                                                                        <span class="fs-xs mb-0">Data recovery</span>
                                                                    </span>
                                                                </span>
                                                            </a>
                                                        </li>
                                                        <li class="nav-item">
                                                            <a class="nav-link" data-bs-toggle="tab" href="#shopStepAdvanced">
                                                                <span class="d-flex align-items-center">
                                                                    <div class="avatar-md">
                                                                        <span class="avatar-title bg-light rounded">
                                                                            <i class="ti ti-settings fs-24"></i>
                                                                        </span>
                                                                    </div>
                                                                    <span class="flex-grow-1 ms-2 text-truncate">
                                                                        <span class="fw-semibold text-body d-block fs-base">Advanced</span>
                                                                        <span class="fs-xs mb-0">System controls</span>
                                                                    </span>
                                                                </span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                    <!-- /.nav -->
                                                </div>
                                                <!-- /.col-md-4 -->
                                                <!-- Tab Content -->
                                                <div class="col-md-8 col-xxl-9">
                                                    <div class="tab-content border border-dashed rounded p-4" data-wizard-content="">
                                                        <!-- STEP 1: GENERAL INFO -->
                                                        <div class="tab-pane fade show active" id="shopStepGeneral">
                                                            <div class="row">
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">Shop Name</label>
                                                                    <input class="form-control" placeholder="e.g., Vona Store" required="" type="text" />
                                                                </div>
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">Support Email</label>
                                                                    <input class="form-control" placeholder="support@vona.com" required="" type="email" />
                                                                </div>
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">Phone</label>
                                                                    <input class="form-control" placeholder="+1 234 567 8901" type="tel" />
                                                                </div>
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">Business Hours</label>
                                                                    <input class="form-control" placeholder="Mon-Fri, 9 AM - 6 PM" type="text" />
                                                                </div>
                                                            </div>
                                                            <div class="d-flex justify-content-end mt-3">
                                                                <button class="btn btn-primary" data-wizard-next="" type="button">Next: Store Details →</button>
                                                            </div>
                                                        </div>
                                                        <!-- /.tab-pane (General Info) -->
                                                        <!-- STEP 2: STORE DETAILS -->
                                                        <div class="tab-pane fade" id="shopStepStore">
                                                            <div class="row">
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">Business Name</label>
                                                                    <input class="form-control" placeholder="e.g., Acme Retail LLC" type="text" />
                                                                </div>
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">Registration Number</label>
                                                                    <input class="form-control" placeholder="e.g., 123456789" type="text" />
                                                                </div>
                                                                <div class="col-xl-12 mb-3">
                                                                    <label class="form-label">Business Address</label>
                                                                    <textarea class="form-control" placeholder="123 Main Street, City, Country" rows="2"></textarea>
                                                                </div>
                                                            </div>
                                                            <div class="d-flex justify-content-between mt-3">
                                                                <button class="btn btn-secondary" data-wizard-prev="" type="button">← Back</button>
                                                                <button class="btn btn-primary" data-wizard-next="" type="button">Next: Branding →</button>
                                                            </div>
                                                        </div>
                                                        <!-- /.tab-pane (Store Details) -->
                                                        <!-- STEP 3: BRANDING -->
                                                        <div class="tab-pane fade" id="shopStepBranding">
                                                            <div class="row">
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">Logo Upload</label>
                                                                    <input class="form-control" type="file" />
                                                                </div>
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">Favicon</label>
                                                                    <input class="form-control" type="file" />
                                                                </div>
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">Primary Color</label>
                                                                    <input class="form-control form-control-color" type="color" value="#4f46e5" />
                                                                </div>
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">Accent Color</label>
                                                                    <input class="form-control form-control-color" type="color" value="#22c55e" />
                                                                </div>
                                                            </div>
                                                            <div class="d-flex justify-content-between mt-3">
                                                                <button class="btn btn-secondary" data-wizard-prev="" type="button">← Back</button>
                                                                <button class="btn btn-primary" data-wizard-next="" type="button">Next: Currency &amp; Tax →</button>
                                                            </div>
                                                        </div>
                                                        <!-- /.tab-pane (Branding) -->
                                                        <!-- STEP 4: CURRENCY & TAX -->
                                                        <div class="tab-pane fade" id="shopStepCurrency">
                                                            <div class="row">
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">Default Currency</label>
                                                                    <select class="form-select">
                                                                        <option>USD</option>
                                                                        <option>EUR</option>
                                                                        <option>GBP</option>
                                                                        <option>INR</option>
                                                                    </select>
                                                                </div>
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">Tax Rate (%)</label>
                                                                    <input class="form-control" placeholder="e.g., 7.5" type="number" />
                                                                </div>
                                                                <div class="col-xl-12">
                                                                    <div class="form-check form-switch">
                                                                        <input checked="" class="form-check-input" type="checkbox" />
                                                                        <label class="form-check-label">Enable Auto Tax Calculation</label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="d-flex justify-content-between mt-3">
                                                                <button class="btn btn-secondary" data-wizard-prev="" type="button">← Back</button>
                                                                <button class="btn btn-primary" data-wizard-next="" type="button">Next: Shipping →</button>
                                                            </div>
                                                        </div>
                                                        <!-- /.tab-pane (Currency & Tax) -->
                                                        <!-- STEP 5: SHIPPING -->
                                                        <div class="tab-pane fade" id="shopStepShipping">
                                                            <div class="row">
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">Default Origin</label>
                                                                    <input class="form-control" placeholder="California, USA" type="text" />
                                                                </div>
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">Free Shipping Threshold</label>
                                                                    <input class="form-control" placeholder="e.g., 100" type="number" />
                                                                </div>
                                                                <div class="col-xl-12 mb-3">
                                                                    <label class="form-label">Available Methods</label>
                                                                    <select class="form-select" multiple="">
                                                                        <option>Standard Delivery</option>
                                                                        <option>Express</option>
                                                                        <option>Pickup</option>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="d-flex justify-content-between mt-3">
                                                                <button class="btn btn-secondary" data-wizard-prev="" type="button">← Back</button>
                                                                <button class="btn btn-primary" data-wizard-next="" type="button">Next: Payments →</button>
                                                            </div>
                                                        </div>
                                                        <!-- /.tab-pane (Shipping) -->
                                                        <!-- STEP 6: PAYMENTS -->
                                                        <div class="tab-pane fade" id="shopStepPayment">
                                                            <div class="row">
                                                                <div class="col-xl-6 mb-3">
                                                                    <div class="form-check form-switch">
                                                                        <input checked="" class="form-check-input" type="checkbox" />
                                                                        <label class="form-check-label">Enable Stripe</label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-xl-6 mb-3">
                                                                    <div class="form-check form-switch">
                                                                        <input class="form-check-input" type="checkbox" />
                                                                        <label class="form-check-label">Enable PayPal</label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">Stripe Key</label>
                                                                    <input class="form-control" placeholder="pk_live_..." type="text" />
                                                                </div>
                                                                <div class="col-xl-6 mb-3">
                                                                    <label class="form-label">PayPal Client ID</label>
                                                                    <input class="form-control" placeholder="e.g., Abcd1234" type="text" />
                                                                </div>
                                                            </div>
                                                            <div class="d-flex justify-content-between mt-3">
                                                                <button class="btn btn-secondary" data-wizard-prev="" type="button">← Back</button>
                                                                <button class="btn btn-primary" data-wizard-next="" type="button">Next: Notifications →</button>
                                                            </div>
                                                        </div>
                                                        <!-- /.tab-pane (Payments) -->
                                                        <!-- STEP 7: NOTIFICATIONS -->
                                                        <div class="tab-pane fade" id="shopStepNotifications">
                                                            <div class="form-check form-switch mb-3">
                                                                <input checked="" class="form-check-input" type="checkbox" />
                                                                <label class="form-check-label">Enable Order Emails</label>
                                                            </div>
                                                            <div class="form-check form-switch mb-3">
                                                                <input class="form-check-input" type="checkbox" />
                                                                <label class="form-check-label">Enable Low Stock Alerts</label>
                                                            </div>
                                                            <div class="form-check form-switch mb-3">
                                                                <input class="form-check-input" type="checkbox" />
                                                                <label class="form-check-label">Enable SMS Notifications</label>
                                                            </div>
                                                            <div class="d-flex justify-content-between mt-3">
                                                                <button class="btn btn-secondary" data-wizard-prev="" type="button">← Back</button>
                                                                <button class="btn btn-primary" data-wizard-next="" type="button">Next: Invoices &amp; Receipts →</button>
                                                            </div>
                                                        </div>
                                                        <!-- /.tab-pane (Notifications) -->
                                                        <!-- STEP 8: INVOICES & RECEIPTS -->
                                                        <div class="tab-pane fade" id="shopStepInvoices">
                                                            <div class="mb-3">
                                                                <label class="form-label">Invoice Prefix</label>
                                                                <input class="form-control" placeholder="INV-" type="text" />
                                                            </div>
                                                            <div class="form-check form-switch mb-3">
                                                                <input checked="" class="form-check-input" type="checkbox" />
                                                                <label class="form-check-label">Include Tax Breakdown</label>
                                                            </div>
                                                            <div class="form-check form-switch mb-3">
                                                                <input class="form-check-input" type="checkbox" />
                                                                <label class="form-check-label">Enable PDF Download</label>
                                                            </div>
                                                            <div class="d-flex justify-content-between mt-3">
                                                                <button class="btn btn-secondary" data-wizard-prev="" type="button">← Back</button>
                                                                <button class="btn btn-primary" data-wizard-next="" type="button">Next: SEO &amp; Legal →</button>
                                                            </div>
                                                        </div>
                                                        <!-- /.tab-pane (Invoices) -->
                                                        <!-- STEP 9: SEO & LEGAL -->
                                                        <div class="tab-pane fade" id="shopStepLegal">
                                                            <div class="mb-3">
                                                                <label class="form-label">Meta Title</label>
                                                                <input class="form-control" placeholder="Your Shop Title" type="text" />
                                                            </div>
                                                            <div class="mb-3">
                                                                <label class="form-label">Meta Description</label>
                                                                <textarea class="form-control" placeholder="Brief description for SEO" rows="2"></textarea>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label class="form-label">Privacy Policy URL</label>
                                                                <input class="form-control" placeholder="https://example.com/privacy" type="url" />
                                                            </div>
                                                            <div class="mb-3">
                                                                <label class="form-label">Terms &amp; Conditions URL</label>
                                                                <input class="form-control" placeholder="https://example.com/terms" type="url" />
                                                            </div>
                                                            <div class="d-flex justify-content-between mt-3">
                                                                <button class="btn btn-secondary" data-wizard-prev="" type="button">← Back</button>
                                                                <button class="btn btn-primary" data-wizard-next="" type="button">Next: Integrations →</button>
                                                            </div>
                                                        </div>
                                                        <!-- /.tab-pane (SEO & Legal) -->
                                                        <!-- STEP 10: INTEGRATIONS -->
                                                        <div class="tab-pane fade" id="shopStepIntegrations">
                                                            <div class="mb-3">
                                                                <label class="form-label">Google Analytics ID</label>
                                                                <input class="form-control" placeholder="UA-XXXXX-Y" type="text" />
                                                            </div>
                                                            <div class="mb-3">
                                                                <label class="form-label">Facebook Pixel ID</label>
                                                                <input class="form-control" placeholder="1234567890" type="text" />
                                                            </div>
                                                            <div class="mb-3">
                                                                <label class="form-label">Mailchimp API Key</label>
                                                                <input class="form-control" placeholder="key-xxxxx" type="text" />
                                                            </div>
                                                            <div class="d-flex justify-content-between mt-3">
                                                                <button class="btn btn-secondary" data-wizard-prev="" type="button">← Back</button>
                                                                <button class="btn btn-primary" data-wizard-next="" type="button">Next: Backup &amp; Restore →</button>
                                                            </div>
                                                        </div>
                                                        <!-- /.tab-pane (Integrations) -->
                                                        <!-- STEP 11: BACKUP & RESTORE -->
                                                        <div class="tab-pane fade" id="shopStepBackup">
                                                            <div class="mb-3">
                                                                <button class="btn btn-outline-primary w-100">Create Manual Backup</button>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label class="form-label">Restore from File</label>
                                                                <input class="form-control" type="file" />
                                                            </div>
                                                            <div class="form-check form-switch mb-3">
                                                                <input class="form-check-input" type="checkbox" />
                                                                <label class="form-check-label">Enable Auto Backups (Weekly)</label>
                                                            </div>
                                                            <div class="d-flex justify-content-between mt-3">
                                                                <button class="btn btn-secondary" data-wizard-prev="" type="button">← Back</button>
                                                                <button class="btn btn-primary" data-wizard-next="" type="button">Next: Advanced →</button>
                                                            </div>
                                                        </div>
                                                        <!-- /.tab-pane (Backup & Restore) -->
                                                        <!-- STEP 12: ADVANCED -->
                                                        <div class="tab-pane fade" id="shopStepAdvanced">
                                                            <div class="form-check form-switch mb-3">
                                                                <input class="form-check-input" type="checkbox" />
                                                                <label class="form-check-label">Enable Maintenance Mode</label>
                                                            </div>
                                                            <div class="form-check form-switch mb-3">
                                                                <input class="form-check-input" type="checkbox" />
                                                                <label class="form-check-label">Debug Mode</label>
                                                            </div>
                                                            <div class="mb-3">
                                                                <label class="form-label">Custom Script (Footer)</label>
                                                                <textarea class="form-control" placeholder="Paste custom JavaScript here" rows="3"></textarea>
                                                            </div>
                                                            <div class="d-flex justify-content-between mt-3">
                                                                <button class="btn btn-secondary" data-wizard-prev="" type="button">← Back</button>
                                                                <button class="btn btn-success" type="submit">Save All Settings</button>
                                                            </div>
                                                        </div>
                                                        <!-- /.tab-pane (Advanced) -->
                                                    </div>
                                                    <!-- /.tab-content -->
                                                </div>
                                                <!-- /.col-md-8 -->
                                            </div>
                                            <!-- /.row -->
                                        </div>
                                        <!-- /.ins-wizard -->
                                    </form>
                                    <!-- /form -->
                                </div>
                                <!-- /.card-body -->
                            </div>
                            <!-- /.card -->
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Wizard Form Demo js -->
        <script src="/js/pages/form-wizard.js"></script>
    </body>
</html>
