<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Expenses')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Finance', 'title' => 'Expenses')) ?>

                    <div class="row row-cols-xxl-4 row-cols-md-2 row-cols-1">
                        <!-- Total Expenses Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                            <span class="avatar-title bg-primary-subtle text-primary rounded-circle fs-24">
                                                <i class="ti ti-wallet"></i>
                                            </span>
                                        </div>
                                        <div class="text-end">
                                            <h3 class="mb-2 fw-normal">
                                                $
                                                <span data-target="15240">0</span>
                                            </h3>
                                            <p class="mb-0 text-muted"><span>Total Expenses</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <!-- Approved Expenses Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                            <span class="avatar-title bg-success-subtle text-success rounded-circle fs-24">
                                                <i class="ti ti-circle-check"></i>
                                            </span>
                                        </div>
                                        <div class="text-end">
                                            <h3 class="mb-2 fw-normal">
                                                $
                                                <span data-target="10780">0</span>
                                            </h3>
                                            <p class="mb-0 text-muted"><span>Approved Expenses</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <!-- Pending Approval Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                            <span class="avatar-title bg-warning-subtle text-warning rounded-circle fs-24">
                                                <i class="ti ti-hourglass"></i>
                                            </span>
                                        </div>
                                        <div class="text-end">
                                            <h3 class="mb-2 fw-normal">
                                                $
                                                <span data-target="2940">0</span>
                                            </h3>
                                            <p class="mb-0 text-muted"><span>Pending Approval</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <!-- Reimbursed Expenses Widget -->
                        <div class="col">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                            <span class="avatar-title bg-info-subtle text-info rounded-circle fs-24">
                                                <i class="ti ti-refresh"></i>
                                            </span>
                                        </div>
                                        <div class="text-end">
                                            <h3 class="mb-2 fw-normal">
                                                $
                                                <span data-target="1520">0</span>
                                            </h3>
                                            <p class="mb-0 text-muted"><span>Reimbursed</span></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="8">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <!-- Search -->
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search expenses..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Add New Expense -->
                                        <button class="btn btn-primary" data-bs-target="#addExpenseModal" data-bs-toggle="modal">
                                            <i class="ti ti-plus me-1"></i>
                                            Add Expense
                                        </button>
                                        <!-- Delete Selected -->
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Category Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="expense-category">
                                                <option value="">Category</option>
                                                <option value="Office Supplies">Office Supplies</option>
                                                <option value="Travel">Travel</option>
                                                <option value="Meals">Meals</option>
                                                <option value="Entertainment">Entertainment</option>
                                                <option value="Equipment">Equipment</option>
                                                <option value="Utilities">Utilities</option>
                                                <option value="Maintenance">Maintenance</option>
                                            </select>
                                            <i class="ti ti-category app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="status">
                                                <option value="">Status</option>
                                                <option value="Approved">Approved</option>
                                                <option value="Pending">Pending</option>
                                                <option value="Rejected">Rejected</option>
                                                <option value="Reimbursed">Reimbursed</option>
                                            </select>
                                            <i class="ti ti-circle-check app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option selected="" value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-custom table-centered table-select table-hover w-100 mb-0">
                                            <thead class="bg-light align-middle bg-opacity-25 thead-sm text-nowrap">
                                                <tr class="text-uppercase fs-xxs">
                                                    <th class="ps-3" style="width: 1%">
                                                        <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" type="checkbox" />
                                                    </th>
                                                    <th data-table-sort="">ID</th>
                                                    <th>Expense Title</th>
                                                    <th data-column="expense-category" data-table-sort="">Category</th>
                                                    <th>Payment Method</th>
                                                    <th data-table-sort="">Amount</th>
                                                    <th data-column="status" data-table-sort="">Status</th>
                                                    <th data-table-sort="">Date</th>
                                                    <th data-table-sort="">Added By</th>
                                                    <th class="text-center" style="width: 1%">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody class="text-nowrap">
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#EXP-1023</a></td>
                                                    <td>Office Stationery</td>
                                                    <td data-column="category">Office Supplies</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="MasterCard" class="me-2" height="26" src="/images/cards/mastercard.svg" />
                                                            <span>**** 4421</span>
                                                        </div>
                                                    </td>
                                                    <td>$248.50</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Approved</span></td>
                                                    <td>
                                                        02 Oct, 2025
                                                        <small class="text-muted">09:45 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="John Miller" class="avatar-xs rounded-circle" src="/images/users/user-5.jpg" />
                                                            <span>John Miller</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                                <i class="ti ti-eye fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!">
                                                                <i class="ti ti-edit fs-lg"></i>
                                                            </a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                                <i class="ti ti-trash fs-lg"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#EXP-1024</a></td>
                                                    <td>Flight to New York</td>
                                                    <td data-column="category">Travel</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Visa" class="me-2" height="26" src="/images/cards/visa.svg" />
                                                            <span>**** 6783</span>
                                                        </div>
                                                    </td>
                                                    <td>$820.00</td>
                                                    <td><span class="badge bg-warning-subtle text-warning badge-label">Pending</span></td>
                                                    <td>
                                                        04 Oct, 2025
                                                        <small class="text-muted">02:10 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Sarah Lee" class="avatar-xs rounded-circle" src="/images/users/user-7.jpg" />
                                                            <span>Sarah Lee</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#EXP-1025</a></td>
                                                    <td>Team Dinner</td>
                                                    <td data-column="category">Meals</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="PayPal" class="me-2" height="26" src="/images/cards/paypal.svg" />
                                                            <span>PayPal</span>
                                                        </div>
                                                    </td>
                                                    <td>$185.75</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Approved</span></td>
                                                    <td>
                                                        03 Oct, 2025
                                                        <small class="text-muted">08:00 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="David Wilson" class="avatar-xs rounded-circle" src="/images/users/user-6.jpg" />
                                                            <span>David Wilson</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#EXP-1026</a></td>
                                                    <td>Printer Repair &amp; Service</td>
                                                    <td data-column="category">Maintenance</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Amex" class="me-2" height="26" src="/images/cards/american-express.svg" />
                                                            <span>**** 9124</span>
                                                        </div>
                                                    </td>
                                                    <td>$96.20</td>
                                                    <td><span class="badge bg-danger-subtle text-danger badge-label">Rejected</span></td>
                                                    <td>
                                                        01 Oct, 2025
                                                        <small class="text-muted">03:40 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Olivia Brown" class="avatar-xs rounded-circle" src="/images/users/user-9.jpg" />
                                                            <span>Olivia Brown</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#EXP-1027</a></td>
                                                    <td>Software Subscription</td>
                                                    <td data-column="category">Utilities</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="MasterCard" class="me-2" height="26" src="/images/cards/mastercard.svg" />
                                                            <span>**** 2217</span>
                                                        </div>
                                                    </td>
                                                    <td>$59.99</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Reimbursed</span></td>
                                                    <td>
                                                        30 Sep, 2025
                                                        <small class="text-muted">11:20 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Ethan Brooks" class="avatar-xs rounded-circle" src="/images/users/user-10.jpg" />
                                                            <span>Ethan Brooks</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#EXP-1028</a></td>
                                                    <td>Office Coffee Machine</td>
                                                    <td data-column="category">Equipment</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Visa" class="me-2" height="26" src="/images/cards/visa.svg" />
                                                            <span>**** 3328</span>
                                                        </div>
                                                    </td>
                                                    <td>$342.60</td>
                                                    <td><span class="badge bg-warning-subtle text-warning badge-label">Pending</span></td>
                                                    <td>
                                                        28 Sep, 2025
                                                        <small class="text-muted">09:05 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Liam Davis" class="avatar-xs rounded-circle" src="/images/users/user-1.jpg" />
                                                            <span>Liam Davis</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#EXP-1029</a></td>
                                                    <td>Office Internet Bill</td>
                                                    <td data-column="category">Utilities</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Visa" class="me-2" height="26" src="/images/cards/visa.svg" />
                                                            <span>**** 5454</span>
                                                        </div>
                                                    </td>
                                                    <td>$129.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Approved</span></td>
                                                    <td>
                                                        27 Sep, 2025
                                                        <small class="text-muted">01:25 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Emily Clark" class="avatar-xs rounded-circle" src="/images/users/user-3.jpg" />
                                                            <span>Emily Clark</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#EXP-1030</a></td>
                                                    <td>Client Entertainment</td>
                                                    <td data-column="category">Entertainment</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="MasterCard" class="me-2" height="26" src="/images/cards/mastercard.svg" />
                                                            <span>**** 9128</span>
                                                        </div>
                                                    </td>
                                                    <td>$298.40</td>
                                                    <td><span class="badge bg-warning-subtle text-warning badge-label">Pending</span></td>
                                                    <td>
                                                        25 Sep, 2025
                                                        <small class="text-muted">07:55 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Daniel Ray" class="avatar-xs rounded-circle" src="/images/users/user-2.jpg" />
                                                            <span>Daniel Ray</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#EXP-1031</a></td>
                                                    <td>Conference Registration</td>
                                                    <td data-column="category">Training &amp; Events</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Amex" class="me-2" height="26" src="/images/cards/american-express.svg" />
                                                            <span>**** 7742</span>
                                                        </div>
                                                    </td>
                                                    <td>$560.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Approved</span></td>
                                                    <td>
                                                        24 Sep, 2025
                                                        <small class="text-muted">09:20 AM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Emma Johnson" class="avatar-xs rounded-circle" src="/images/users/user-4.jpg" />
                                                            <span>Emma Johnson</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#EXP-1032</a></td>
                                                    <td>Office Furniture Purchase</td>
                                                    <td data-column="category">Equipment</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="Visa" class="me-2" height="26" src="/images/cards/visa.svg" />
                                                            <span>**** 2398</span>
                                                        </div>
                                                    </td>
                                                    <td>$1,125.00</td>
                                                    <td><span class="badge bg-success-subtle text-success badge-label">Reimbursed</span></td>
                                                    <td>
                                                        22 Sep, 2025
                                                        <small class="text-muted">04:50 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Lucas Martin" class="avatar-xs rounded-circle" src="/images/users/user-8.jpg" />
                                                            <span>Lucas Martin</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="ps-3">
                                                        <input class="form-check-input form-check-input-light fs-14 product-item-check mt-0" type="checkbox" />
                                                    </td>
                                                    <td><a class="fw-semibold link-reset" href="#!">#EXP-1033</a></td>
                                                    <td>Taxi Fare - Client Visit</td>
                                                    <td data-column="category">Travel</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <img alt="PayPal" class="me-2" height="26" src="/images/cards/paypal.svg" />
                                                            <span>PayPal</span>
                                                        </div>
                                                    </td>
                                                    <td>$42.50</td>
                                                    <td><span class="badge bg-danger-subtle text-danger badge-label">Rejected</span></td>
                                                    <td>
                                                        20 Sep, 2025
                                                        <small class="text-muted">05:35 PM</small>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex gap-2 align-items-center">
                                                            <img alt="Sophia Turner" class="avatar-xs rounded-circle" src="/images/users/user-7.jpg" />
                                                            <span>Sophia Turner</span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <div class="d-flex justify-content-center gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#!"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <!-- end table responsive-->
                                </div>
                                <!-- end card-body-->
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="Expenses"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                    <!-- Add New Expense Modal -->
                    <div aria-hidden="true" aria-labelledby="addExpenseModalLabel" class="modal fade" id="addExpenseModal" tabindex="-1">
                        <div class="modal-dialog modal-dialog-centered modal-lg">
                            <div class="modal-content border-0 shadow-sm">
                                <div class="modal-header bg-light border-bottom">
                                    <h5 class="modal-title fw-semibold" id="addExpenseModalLabel">Add New Expense</h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <form id="addExpenseForm">
                                    <div class="modal-body">
                                        <div class="row g-3">
                                            <!-- Expense Title -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="expenseTitle">
                                                    Expense Title
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" id="expenseTitle" placeholder="Enter expense title" required="" type="text" />
                                            </div>
                                            <!-- Amount -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="expenseAmount">
                                                    Amount ($)
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <input class="form-control" id="expenseAmount" placeholder="Enter amount" required="" step="0.01" type="number" />
                                            </div>
                                            <!-- Category -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="expenseCategory">
                                                    Category
                                                    <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-select" id="expenseCategory" required="">
                                                    <option value="">Select category</option>
                                                    <option value="Office Supplies">Office Supplies</option>
                                                    <option value="Travel">Travel</option>
                                                    <option value="Meals">Meals</option>
                                                    <option value="Entertainment">Entertainment</option>
                                                    <option value="Equipment">Equipment</option>
                                                    <option value="Utilities">Utilities</option>
                                                    <option value="Maintenance">Maintenance</option>
                                                    <option value="Training &amp; Events">Training &amp; Events</option>
                                                </select>
                                            </div>
                                            <!-- Payment Method -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="expensePayment">Payment Method</label>
                                                <select class="form-select" id="expensePayment">
                                                    <option value="">Select payment method</option>
                                                    <option value="Credit Card">Credit Card</option>
                                                    <option value="Debit Card">Debit Card</option>
                                                    <option value="Cash">Cash</option>
                                                    <option value="PayPal">PayPal</option>
                                                    <option value="Bank Transfer">Bank Transfer</option>
                                                </select>
                                            </div>
                                            <!-- Status -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="expenseStatus">Status</label>
                                                <select class="form-select" id="expenseStatus">
                                                    <option value="">Select status</option>
                                                    <option value="Pending">Pending</option>
                                                    <option value="Approved">Approved</option>
                                                    <option value="Rejected">Rejected</option>
                                                    <option value="Reimbursed">Reimbursed</option>
                                                </select>
                                            </div>
                                            <!-- Date -->
                                            <div class="col-md-6">
                                                <label class="form-label" for="expenseDate">Date &amp; Time</label>
                                                <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="expenseDate" type="text" />
                                            </div>
                                            <!-- Description -->
                                            <div class="col-12">
                                                <label class="form-label" for="expenseDesc">Description</label>
                                                <textarea class="form-control" id="expenseDesc" placeholder="Optional notes or description" rows="3"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer border-top">
                                        <button class="btn btn-light" data-bs-dismiss="modal" type="button">Cancel</button>
                                        <button class="btn btn-primary" type="submit">
                                            <i class="ti ti-device-floppy me-1"></i>
                                            Save Expense
                                        </button>
                                    </div>
                                </form>
                            </div>
                            <!-- end modal content-->
                        </div>
                        <!-- end modal dialog-->
                    </div>
                    <!-- end modal-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
