<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Attendance')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'HRM', 'title' => 'Attendance')) ?>

                    <div class="row row-cols-xxl-5 row-cols-md-3 row-cols-1 g-2">
                        <!-- Total Working Days -->
                        <div class="col">
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="d-flex gap-3">
                                        <div class="avatar-lg rounded-circle text-bg-light d-flex align-items-center justify-content-center">
                                            <i class="ti ti-calendar-clock fs-xxl"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="mb-2 d-flex justify-content-between align-items-center">
                                                <h5 class="fs-xl mb-0">22</h5>
                                                <span>
                                                    +5%
                                                    <i class="ti ti-arrow-up text-success"></i>
                                                </span>
                                            </div>
                                            <p class="text-muted mb-0">Total working days</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Days Present -->
                        <div class="col">
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="d-flex gap-3">
                                        <div class="avatar-lg rounded-circle text-bg-light d-flex align-items-center justify-content-center">
                                            <i class="ti ti-user-check fs-xxl"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="mb-2 d-flex justify-content-between align-items-center">
                                                <h5 class="fs-xl mb-0">18</h5>
                                                <span>
                                                    +2.4%
                                                    <i class="ti ti-arrow-up text-success"></i>
                                                </span>
                                            </div>
                                            <p class="text-muted mb-0">Days present</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Days On Leave -->
                        <div class="col">
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="d-flex gap-3">
                                        <div class="avatar-lg rounded-circle text-bg-light d-flex align-items-center justify-content-center">
                                            <i class="ti ti-plane fs-xxl"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="mb-2 d-flex justify-content-between align-items-center">
                                                <h5 class="fs-xl mb-0">2</h5>
                                                <span>
                                                    -1.0%
                                                    <i class="ti ti-arrow-down text-danger"></i>
                                                </span>
                                            </div>
                                            <p class="text-muted mb-0">Days on leave</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Days Absent -->
                        <div class="col">
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="d-flex gap-3">
                                        <div class="avatar-lg rounded-circle text-bg-light d-flex align-items-center justify-content-center">
                                            <i class="ti ti-user-circle fs-xxl"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="mb-2 d-flex justify-content-between align-items-center">
                                                <h5 class="fs-xl mb-0">1</h5>
                                                <span>0%</span>
                                            </div>
                                            <p class="text-muted mb-0">Days absent</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Average Hours Per Day -->
                        <div class="col">
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="d-flex gap-3">
                                        <div class="avatar-lg rounded-circle text-bg-light d-flex align-items-center justify-content-center">
                                            <i class="ti ti-clock fs-xxl"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="mb-2 d-flex justify-content-between align-items-center">
                                                <h5 class="fs-xl mb-0">
                                                    9.2
                                                    <small class="fs-6">hrs/day</small>
                                                </h5>
                                                <span>+0.8%</span>
                                            </div>
                                            <p class="text-muted mb-0">Average working hours</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end row-->
                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="10">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <!-- Search -->
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search records..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Add New Attendance -->
                                        <button class="btn btn-primary" data-bs-target="#addAttendanceModal" data-bs-toggle="modal">
                                            <i class="ti ti-plus me-1"></i>
                                            Add Record
                                        </button>
                                        <!-- Delete Selected -->
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="status">
                                                <option value="">Status</option>
                                                <option value="Present">Present</option>
                                                <option value="Late">Late</option>
                                                <option value="Half Day">Half Day</option>
                                                <option value="On Leave">On Leave</option>
                                                <option value="Absent">Absent</option>
                                            </select>
                                            <i class="ti ti-user-check app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Shift Type Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="shift">
                                                <option value="">Shift Type</option>
                                                <option value="Day Shift">Day Shift</option>
                                                <option value="Night Shift">Night Shift</option>
                                                <option value="Mid Shift">Mid Shift</option>
                                            </select>
                                            <i class="ti ti-clock app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option selected="" value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-custom table-centered table-hover w-100 mb-0">
                                            <thead class="bg-light align-middle bg-opacity-25 thead-sm text-nowrap">
                                                <tr class="text-uppercase fs-xxs">
                                                    <th class="ps-3" data-table-sort="">Date</th>
                                                    <th data-column="status" data-table-sort="">Status</th>
                                                    <th data-column="shift" data-table-sort="">Shift Type</th>
                                                    <th data-table-sort="">Clock In</th>
                                                    <th data-table-sort="">Clock Out</th>
                                                    <th data-table-sort="">Production</th>
                                                    <th data-table-sort="">Break</th>
                                                    <th data-table-sort="">Overtime</th>
                                                    <th>Progress</th>
                                                    <th data-table-sort="">Total Hours</th>
                                                    <th data-table-sort="">Leave Type</th>
                                                    <th data-table-sort="">Approval</th>
                                                    <th data-table-sort="">Approval By</th>
                                                </tr>
                                            </thead>
                                            <tbody class="text-nowrap">
                                                <!-- 27 Oct -->
                                                <tr>
                                                    <td class="ps-3">27 Oct 2025</td>
                                                    <td><span class="badge bg-success-subtle text-success">Present</span></td>
                                                    <td>Day Shift</td>
                                                    <td>09:03 AM</td>
                                                    <td>06:50 PM</td>
                                                    <td>8h 25m</td>
                                                    <td>0h 50m</td>
                                                    <td>0h 15m</td>
                                                    <td>
                                                        <div class="progress progress-sm">
                                                            <div class="progress-bar bg-success" style="width: 90%"></div>
                                                        </div>
                                                    </td>
                                                    <td>9h 30m</td>
                                                    <td>--</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>Maria Smith</td>
                                                </tr>
                                                <!-- 26 Oct -->
                                                <tr>
                                                    <td class="ps-3">26 Oct 2025</td>
                                                    <td><span class="badge bg-success-subtle text-success">Present</span></td>
                                                    <td>Day Shift</td>
                                                    <td>09:10 AM</td>
                                                    <td>07:05 PM</td>
                                                    <td>8h 30m</td>
                                                    <td>1h 00m</td>
                                                    <td>0h 25m</td>
                                                    <td>
                                                        <div class="progress progress-sm">
                                                            <div class="progress-bar bg-success" style="width: 88%"></div>
                                                        </div>
                                                    </td>
                                                    <td>9h 55m</td>
                                                    <td>--</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>Maria Smith</td>
                                                </tr>
                                                <!-- 25 Oct -->
                                                <tr>
                                                    <td class="ps-3">25 Oct 2025</td>
                                                    <td><span class="badge bg-warning-subtle text-warning">Late</span></td>
                                                    <td>Day Shift</td>
                                                    <td>09:45 AM</td>
                                                    <td>07:30 PM</td>
                                                    <td>8h 10m</td>
                                                    <td>0h 55m</td>
                                                    <td>0h 00m</td>
                                                    <td>
                                                        <div class="progress progress-sm">
                                                            <div class="progress-bar bg-warning" style="width: 75%"></div>
                                                        </div>
                                                    </td>
                                                    <td>9h 05m</td>
                                                    <td>--</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>Maria Smith</td>
                                                </tr>
                                                <!-- 24 Oct -->
                                                <tr>
                                                    <td class="ps-3">24 Oct 2025</td>
                                                    <td><span class="badge bg-info-subtle text-info">On Leave</span></td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td>
                                                        <div class="progress progress-sm bg-light"></div>
                                                    </td>
                                                    <td>--</td>
                                                    <td>Sick Leave</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>Maria Smith</td>
                                                </tr>
                                                <!-- 23 Oct -->
                                                <tr>
                                                    <td class="ps-3">23 Oct 2025</td>
                                                    <td><span class="badge bg-success-subtle text-success">Present</span></td>
                                                    <td>Night Shift</td>
                                                    <td>07:20 PM</td>
                                                    <td>04:10 AM</td>
                                                    <td>8h 35m</td>
                                                    <td>0h 40m</td>
                                                    <td>0h 25m</td>
                                                    <td>
                                                        <div class="progress progress-sm">
                                                            <div class="progress-bar bg-success" style="width: 92%"></div>
                                                        </div>
                                                    </td>
                                                    <td>9h 40m</td>
                                                    <td>--</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>Maria Smith</td>
                                                </tr>
                                                <!-- 22 Oct -->
                                                <tr>
                                                    <td class="ps-3">22 Oct 2025</td>
                                                    <td><span class="badge bg-warning-subtle text-warning">Half Day</span></td>
                                                    <td>Day Shift</td>
                                                    <td>09:40 AM</td>
                                                    <td>01:15 PM</td>
                                                    <td>3h 30m</td>
                                                    <td>0h 15m</td>
                                                    <td>--</td>
                                                    <td>
                                                        <div class="progress progress-sm">
                                                            <div class="progress-bar bg-warning" style="width: 40%"></div>
                                                        </div>
                                                    </td>
                                                    <td>3h 45m</td>
                                                    <td>--</td>
                                                    <td><span class="badge bg-warning-subtle text-warning">Pending</span></td>
                                                    <td>Maria Smith</td>
                                                </tr>
                                                <!-- 21 Oct -->
                                                <tr>
                                                    <td class="ps-3">21 Oct 2025</td>
                                                    <td><span class="badge bg-danger-subtle text-danger">Absent</span></td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td>
                                                        <div class="progress progress-sm bg-light"></div>
                                                    </td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td><span class="badge bg-danger-subtle text-danger">Rejected</span></td>
                                                    <td>Maria Smith</td>
                                                </tr>
                                                <!-- 20 Oct -->
                                                <tr>
                                                    <td class="ps-3">20 Oct 2025</td>
                                                    <td><span class="badge bg-success-subtle text-success">Present</span></td>
                                                    <td>Day Shift</td>
                                                    <td>09:00 AM</td>
                                                    <td>06:40 PM</td>
                                                    <td>8h 15m</td>
                                                    <td>1h 00m</td>
                                                    <td>0h 20m</td>
                                                    <td>
                                                        <div class="progress progress-sm">
                                                            <div class="progress-bar bg-success" style="width: 88%"></div>
                                                        </div>
                                                    </td>
                                                    <td>9h 35m</td>
                                                    <td>--</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>Maria Smith</td>
                                                </tr>
                                                <!-- 19 Oct -->
                                                <tr>
                                                    <td class="ps-3">19 Oct 2025</td>
                                                    <td><span class="badge bg-success-subtle text-success">Present</span></td>
                                                    <td>Day Shift</td>
                                                    <td>09:12 AM</td>
                                                    <td>06:55 PM</td>
                                                    <td>8h 40m</td>
                                                    <td>0h 55m</td>
                                                    <td>0h 10m</td>
                                                    <td>
                                                        <div class="progress progress-sm">
                                                            <div class="progress-bar bg-success" style="width: 90%"></div>
                                                        </div>
                                                    </td>
                                                    <td>9h 45m</td>
                                                    <td>--</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>Maria Smith</td>
                                                </tr>
                                                <!-- 18 Oct -->
                                                <tr>
                                                    <td class="ps-3">18 Oct 2025</td>
                                                    <td><span class="badge bg-success-subtle text-success">Present</span></td>
                                                    <td>Day Shift</td>
                                                    <td>09:08 AM</td>
                                                    <td>06:48 PM</td>
                                                    <td>8h 20m</td>
                                                    <td>0h 50m</td>
                                                    <td>0h 15m</td>
                                                    <td>
                                                        <div class="progress progress-sm">
                                                            <div class="progress-bar bg-success" style="width: 88%"></div>
                                                        </div>
                                                    </td>
                                                    <td>9h 25m</td>
                                                    <td>--</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>Maria Smith</td>
                                                </tr>
                                                <!-- 17 Oct -->
                                                <tr>
                                                    <td class="ps-3">17 Oct 2025</td>
                                                    <td><span class="badge bg-info-subtle text-info">On Leave</span></td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td>--</td>
                                                    <td>
                                                        <div class="progress progress-sm bg-light"></div>
                                                    </td>
                                                    <td>--</td>
                                                    <td>Casual Leave</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>Maria Smith</td>
                                                </tr>
                                                <!-- 16 Oct -->
                                                <tr>
                                                    <td class="ps-3">16 Oct 2025</td>
                                                    <td><span class="badge bg-success-subtle text-success">Present</span></td>
                                                    <td>Night Shift</td>
                                                    <td>07:10 PM</td>
                                                    <td>03:50 AM</td>
                                                    <td>8h 00m</td>
                                                    <td>0h 45m</td>
                                                    <td>0h 25m</td>
                                                    <td>
                                                        <div class="progress progress-sm">
                                                            <div class="progress-bar bg-success" style="width: 86%"></div>
                                                        </div>
                                                    </td>
                                                    <td>9h 10m</td>
                                                    <td>--</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>Maria Smith</td>
                                                </tr>
                                                <!-- 15 Oct -->
                                                <tr>
                                                    <td class="ps-3">15 Oct 2025</td>
                                                    <td><span class="badge bg-warning-subtle text-warning">Late</span></td>
                                                    <td>Day Shift</td>
                                                    <td>09:55 AM</td>
                                                    <td>07:20 PM</td>
                                                    <td>7h 55m</td>
                                                    <td>1h 05m</td>
                                                    <td>0h 15m</td>
                                                    <td>
                                                        <div class="progress progress-sm">
                                                            <div class="progress-bar bg-warning" style="width: 70%"></div>
                                                        </div>
                                                    </td>
                                                    <td>9h 15m</td>
                                                    <td>--</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>Maria Smith</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <!-- end table-respo.-->
                                </div>
                                <!-- end card-body-->
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="records"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                    <!-- Add Attendance Modal -->
                    <div aria-hidden="true" aria-labelledby="addAttendanceLabel" class="modal fade" id="addAttendanceModal" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="addAttendanceLabel">Add New Attendance Record</h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <form id="addAttendanceForm">
                                    <div class="modal-body">
                                        <div class="row g-3">
                                            <div class="col-md-4">
                                                <label class="form-label" for="attendance-date">Date</label>
                                                <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="attendance-date" required="" type="date" />
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label" for="shift-type">Shift Type</label>
                                                <select class="form-select" id="shift-type" required="">
                                                    <option value="">Select Shift</option>
                                                    <option>Day Shift</option>
                                                    <option>Night Shift</option>
                                                    <option>Mid Shift</option>
                                                </select>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label" for="atte-status">Status</label>
                                                <select class="form-select" id="atte-status" required="">
                                                    <option value="">Select Status</option>
                                                    <option>Present</option>
                                                    <option>Late</option>
                                                    <option>Half Day</option>
                                                    <option>On Leave</option>
                                                    <option>Absent</option>
                                                </select>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label" for="clock-in">Clock In</label>
                                                <input class="form-control" data-provider="timepickr" data-time-basic="true" id="clock-in" type="time" />
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label" for="clock-out">Clock Out</label>
                                                <input class="form-control" data-provider="timepickr" data-time-basic="true" id="clock-out" type="time" />
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label" for="leave-type">Leave Type</label>
                                                <select class="form-select" id="leave-type">
                                                    <option value="">None</option>
                                                    <option>Sick Leave</option>
                                                    <option>Casual Leave</option>
                                                    <option>Paid Leave</option>
                                                </select>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label" for="approval">Approval Status</label>
                                                <select class="form-select" id="approval">
                                                    <option>Approved</option>
                                                    <option>Pending</option>
                                                    <option>Rejected</option>
                                                </select>
                                            </div>
                                            <div class="col-md-4">
                                                <label class="form-label" for="approval-by">Approved By</label>
                                                <input class="form-control" id="approval-by" placeholder="e.g. Maria Smith" type="text" />
                                            </div>
                                            <div class="col-md-12">
                                                <label class="form-label" for="remarks">Remarks</label>
                                                <textarea class="form-control" id="remarks" placeholder="Optional remarks" rows="3"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn btn-light" data-bs-dismiss="modal" type="button">Cancel</button>
                                        <button class="btn btn-primary" type="submit">
                                            <i class="ti ti-device-floppy me-1"></i>
                                            Save Record
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
