<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Salary Slip')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'HRM', 'title' => 'Salary Slip')) ?>

                    <div class="container-xxl">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-header justify-content-between">
                                        <h5 class="mb-0 fw-semibold">
                                            <i class="ti ti-file-text me-1"></i>
                                            Create Salary Slip
                                        </h5>
                                        <button class="btn btn-light btn-sm">
                                            <i class="ti ti-printer me-1"></i>
                                            Print Preview
                                        </button>
                                    </div>
                                    <div class="card-body">
                                        <form id="salarySlipForm">
                                            <div class="row g-3">
                                                <!-- Employee Name -->
                                                <div class="col-md-6">
                                                    <label class="form-label" for="employeeName">
                                                        Employee Name
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <select class="form-select" id="employeeName" required="">
                                                        <option value="">Select Employee</option>
                                                        <option>Samantha Green</option>
                                                        <option>David Lee</option>
                                                        <option>Maria Smith</option>
                                                        <option>Olivia Brown</option>
                                                        <option>James Walker</option>
                                                    </select>
                                                </div>
                                                <!-- Employee ID -->
                                                <div class="col-md-6">
                                                    <label class="form-label" for="employeeId">
                                                        Employee ID
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <input class="form-control" id="employeeId" placeholder="e.g., EMP-1015" required="" type="text" />
                                                </div>
                                                <!-- Department -->
                                                <div class="col-md-6">
                                                    <label class="form-label" for="department">
                                                        Department
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <select class="form-select" id="department" required="">
                                                        <option value="">Select Department</option>
                                                        <option>Human Resources</option>
                                                        <option>Finance</option>
                                                        <option>IT</option>
                                                        <option>Marketing</option>
                                                        <option>Operations</option>
                                                    </select>
                                                </div>
                                                <!-- Designation -->
                                                <div class="col-md-6">
                                                    <label class="form-label" for="designation">
                                                        Designation
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <input class="form-control" id="designation" placeholder="e.g., Senior Developer" required="" type="text" />
                                                </div>
                                                <!-- Pay Period -->
                                                <div class="col-md-6">
                                                    <label class="form-label" for="payPeriod">
                                                        Pay Period
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <select class="form-select" id="payPeriod" required="">
                                                        <option value="">Select Month</option>
                                                        <option>October 2025</option>
                                                        <option>September 2025</option>
                                                        <option>August 2025</option>
                                                        <option>July 2025</option>
                                                    </select>
                                                </div>
                                                <!-- Pay Date -->
                                                <div class="col-md-6">
                                                    <label class="form-label" for="payDate">
                                                        Pay Date
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="payDate" required="" type="date" />
                                                </div>
                                                <!-- Salary Details Section -->
                                                <h5 class="fw-semibold text-muted text-uppercase mt-3">Earnings</h5>
                                                <!-- Basic Salary -->
                                                <div class="col-md-6">
                                                    <label class="form-label" for="basicSalary">
                                                        Basic Salary ($)
                                                        <span class="text-danger">*</span>
                                                    </label>
                                                    <input class="form-control" id="basicSalary" min="0" placeholder="e.g., 5000" required="" type="number" />
                                                </div>
                                                <!-- House Allowance -->
                                                <div class="col-md-6">
                                                    <label class="form-label" for="houseAllowance">House Allowance ($)</label>
                                                    <input class="form-control" id="houseAllowance" min="0" placeholder="e.g., 800" type="number" />
                                                </div>
                                                <!-- Medical Allowance -->
                                                <div class="col-md-6">
                                                    <label class="form-label" for="medicalAllowance">Medical Allowance ($)</label>
                                                    <input class="form-control" id="medicalAllowance" min="0" placeholder="e.g., 400" type="number" />
                                                </div>
                                                <!-- Transport Allowance -->
                                                <div class="col-md-6">
                                                    <label class="form-label" for="transportAllowance">Transport Allowance ($)</label>
                                                    <input class="form-control" id="transportAllowance" min="0" placeholder="e.g., 300" type="number" />
                                                </div>
                                                <h5 class="fw-semibold text-muted text-uppercase mt-3">Deductions</h5>
                                                <!-- Tax -->
                                                <div class="col-md-6">
                                                    <label class="form-label" for="tax">Tax ($)</label>
                                                    <input class="form-control" id="tax" min="0" placeholder="e.g., 200" type="number" />
                                                </div>
                                                <!-- Provident Fund -->
                                                <div class="col-md-6">
                                                    <label class="form-label" for="providentFund">Provident Fund ($)</label>
                                                    <input class="form-control" id="providentFund" min="0" placeholder="e.g., 150" type="number" />
                                                </div>
                                                <!-- Loan Deduction -->
                                                <div class="col-md-6">
                                                    <label class="form-label" for="loanDeduction">Loan Deduction ($)</label>
                                                    <input class="form-control" id="loanDeduction" min="0" placeholder="e.g., 100" type="number" />
                                                </div>
                                                <hr class="mt-4 mb-0" />
                                                <!-- Total Earnings & Net Pay -->
                                                <div class="col-md-6">
                                                    <label class="form-label" for="totalEarnings">Total Earnings ($)</label>
                                                    <input class="form-control" id="totalEarnings" placeholder="Auto-calculated" readonly="" type="number" />
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="form-label" for="netPay">Net Pay ($)</label>
                                                    <input class="form-control" id="netPay" placeholder="Auto-calculated" readonly="" type="number" />
                                                </div>
                                                <!-- Remarks -->
                                                <div class="col-md-12">
                                                    <label class="form-label" for="remarks">Remarks</label>
                                                    <textarea class="form-control" id="remarks" placeholder="Optional notes or remarks" rows="2"></textarea>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="card-footer border-top text-end">
                                        <button class="btn btn-light" type="reset">Reset</button>
                                        <button class="btn btn-primary" type="submit">
                                            <i class="ti ti-device-floppy me-1"></i>
                                            Generate Slip
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
