<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Leaves')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'HRM', 'title' => 'Leaves')) ?>

                    <div class="row row-cols-xxl-5 row-cols-md-3 row-cols-1 g-2">
                        <!-- Total Leave Requests -->
                        <div class="col">
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="d-flex gap-3">
                                        <div class="avatar-lg rounded-circle text-bg-light d-flex align-items-center justify-content-center">
                                            <i class="ti ti-calendar fs-xxl"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="mb-2 d-flex justify-content-between align-items-center">
                                                <h5 class="fs-xl mb-0">128</h5>
                                                <span>
                                                    +4.8%
                                                    <i class="ti ti-arrow-up text-success"></i>
                                                </span>
                                            </div>
                                            <p class="text-muted mb-0">Total leave requests</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Approved Leaves -->
                        <div class="col">
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="d-flex gap-3">
                                        <div class="avatar-lg rounded-circle text-bg-light d-flex align-items-center justify-content-center">
                                            <i class="ti ti-checks fs-xxl"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="mb-2 d-flex justify-content-between align-items-center">
                                                <h5 class="fs-xl mb-0">92</h5>
                                                <span>
                                                    +2.3%
                                                    <i class="ti ti-arrow-up text-success"></i>
                                                </span>
                                            </div>
                                            <p class="text-muted mb-0">Approved leaves</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Pending Leaves -->
                        <div class="col">
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="d-flex gap-3">
                                        <div class="avatar-lg rounded-circle text-bg-light d-flex align-items-center justify-content-center">
                                            <i class="ti ti-hourglass fs-xxl"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="mb-2 d-flex justify-content-between align-items-center">
                                                <h5 class="fs-xl mb-0">21</h5>
                                                <span>
                                                    +1.2%
                                                    <i class="ti ti-arrow-up text-success"></i>
                                                </span>
                                            </div>
                                            <p class="text-muted mb-0">Pending approvals</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Rejected Leaves -->
                        <div class="col">
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="d-flex gap-3">
                                        <div class="avatar-lg rounded-circle text-bg-light d-flex align-items-center justify-content-center">
                                            <i class="ti ti-x fs-xxl"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="mb-2 d-flex justify-content-between align-items-center">
                                                <h5 class="fs-xl mb-0">15</h5>
                                                <span>
                                                    -0.5%
                                                    <i class="ti ti-arrow-down text-danger"></i>
                                                </span>
                                            </div>
                                            <p class="text-muted mb-0">Rejected leaves</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Avg. Leave Duration -->
                        <div class="col-lg col-md-auto">
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="d-flex gap-3">
                                        <div class="avatar-lg rounded-circle text-bg-light d-flex align-items-center justify-content-center">
                                            <i class="ti ti-clock fs-xxl"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <div class="mb-2 d-flex justify-content-between align-items-center">
                                                <h5 class="fs-xl mb-0">
                                                    2.3
                                                    <small class="fs-6">days/leave</small>
                                                </h5>
                                                <span>+0.7%</span>
                                            </div>
                                            <p class="text-muted mb-0">Average leave duration</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end row-->
                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="10">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <!-- Search -->
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search leave records..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Add New Leave -->
                                        <button class="btn btn-primary" data-bs-target="#addLeaveModal" data-bs-toggle="modal">
                                            <i class="ti ti-plus me-1"></i>
                                            Add Leave
                                        </button>
                                        <!-- Delete Selected -->
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Leave Type Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="leave_type">
                                                <option value="">Leave Type</option>
                                                <option value="Sick Leave">Sick Leave</option>
                                                <option value="Casual Leave">Casual Leave</option>
                                                <option value="Paid Leave">Paid Leave</option>
                                                <option value="Maternity Leave">Maternity Leave</option>
                                                <option value="Unpaid Leave">Unpaid Leave</option>
                                            </select>
                                            <i class="ti ti-file-text app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="status">
                                                <option value="">Status</option>
                                                <option value="Pending">Pending</option>
                                                <option value="Approved">Approved</option>
                                                <option value="Rejected">Rejected</option>
                                            </select>
                                            <i class="ti ti-box app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Department Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="department">
                                                <option value="">Department</option>
                                                <option value="HR">HR</option>
                                                <option value="Finance">Finance</option>
                                                <option value="IT">IT</option>
                                                <option value="Design">Design</option>
                                                <option value="Operations">Operations</option>
                                                <option value="Marketing">Marketing</option>
                                                <option value="Support">Support</option>
                                            </select>
                                            <i class="ti ti-users app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option selected="" value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table class="table table-custom table-centered table-hover w-100 mb-0">
                                            <thead class="bg-light align-middle bg-opacity-25 thead-sm text-nowrap">
                                                <tr class="text-uppercase fs-xxs">
                                                    <th scope="col" style="width: 1%">
                                                        <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" id="checkAll" type="checkbox" value="option" />
                                                    </th>
                                                    <th data-table-sort="">Employee ID</th>
                                                    <th data-table-sort="">Employee</th>
                                                    <th data-column="department" data-table-sort="">Department</th>
                                                    <th data-table-sort="">Date From</th>
                                                    <th data-table-sort="">Date To</th>
                                                    <th data-column="leave_type" data-table-sort="">Leave Type</th>
                                                    <th>Reason</th>
                                                    <th data-column="status" data-table-sort="">Status</th>
                                                    <th data-table-sort="">Applied On</th>
                                                    <th data-table-sort="">Approved By</th>
                                                    <th class="text-center" style="width: 1%">Actions</th>
                                                </tr>
                                            </thead>
                                            <tbody class="text-nowrap">
                                                <!-- Record 1 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>EMP-1024</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar-sm rounded-circle bg-light d-flex align-items-center justify-content-center me-2">
                                                                <i class="ti ti-user fs-lg text-muted"></i>
                                                            </div>
                                                            <span>Alex Johnson</span>
                                                        </div>
                                                    </td>
                                                    <td>Design</td>
                                                    <td>24 Oct 2025</td>
                                                    <td>25 Oct 2025</td>
                                                    <td>Sick Leave</td>
                                                    <td>Flu and recovery</td>
                                                    <td><span class="badge bg-warning-subtle text-warning">Pending</span></td>
                                                    <td>22 Oct 2025</td>
                                                    <td>--</td>
                                                    <td>
                                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                                            <a class="btn btn-success btn-icon btn-sm rounded-circle" href="#"><i class="ti ti-check fs-lg"></i></a>
                                                            <a class="btn btn-danger btn-icon btn-sm rounded-circle" href="#"><i class="ti ti-x fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 2 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>EMP-1078</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar-sm rounded-circle bg-light d-flex align-items-center justify-content-center me-2">
                                                                <i class="ti ti-user fs-lg text-muted"></i>
                                                            </div>
                                                            <span>Maria Smith</span>
                                                        </div>
                                                    </td>
                                                    <td>HR</td>
                                                    <td>10 Oct 2025</td>
                                                    <td>12 Oct 2025</td>
                                                    <td>Casual Leave</td>
                                                    <td>Family event</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>08 Oct 2025</td>
                                                    <td>John Adams</td>
                                                    <td>
                                                        <div class="d-flex align-items-center justify-content-end gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 3 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>EMP-1091</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar-sm rounded-circle bg-light d-flex align-items-center justify-content-center me-2">
                                                                <i class="ti ti-user fs-lg text-muted"></i>
                                                            </div>
                                                            <span>David Lee</span>
                                                        </div>
                                                    </td>
                                                    <td>IT</td>
                                                    <td>18 Sep 2025</td>
                                                    <td>19 Sep 2025</td>
                                                    <td>Paid Leave</td>
                                                    <td>Short vacation</td>
                                                    <td><span class="badge bg-danger-subtle text-danger">Rejected</span></td>
                                                    <td>15 Sep 2025</td>
                                                    <td>Maria Smith</td>
                                                    <td>
                                                        <div class="d-flex align-items-center justify-content-end gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 4 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>EMP-1115</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar-sm rounded-circle bg-light d-flex align-items-center justify-content-center me-2">
                                                                <i class="ti ti-user fs-lg text-muted"></i>
                                                            </div>
                                                            <span>Emma Davis</span>
                                                        </div>
                                                    </td>
                                                    <td>Finance</td>
                                                    <td>02 Oct 2025</td>
                                                    <td>03 Oct 2025</td>
                                                    <td>Casual Leave</td>
                                                    <td>Personal errand</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>29 Sep 2025</td>
                                                    <td>John Adams</td>
                                                    <td>
                                                        <div class="d-flex align-items-center justify-content-end gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 5 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>EMP-1156</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar-sm rounded-circle bg-light d-flex align-items-center justify-content-center me-2">
                                                                <i class="ti ti-user fs-lg text-muted"></i>
                                                            </div>
                                                            <span>Noah Wilson</span>
                                                        </div>
                                                    </td>
                                                    <td>Marketing</td>
                                                    <td>07 Oct 2025</td>
                                                    <td>09 Oct 2025</td>
                                                    <td>Sick Leave</td>
                                                    <td>Fever</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>05 Oct 2025</td>
                                                    <td>Maria Smith</td>
                                                    <td>
                                                        <div class="d-flex align-items-center justify-content-end gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 6 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>EMP-1182</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar-sm rounded-circle bg-light d-flex align-items-center justify-content-center me-2">
                                                                <i class="ti ti-user fs-lg text-muted"></i>
                                                            </div>
                                                            <span>Olivia Brown</span>
                                                        </div>
                                                    </td>
                                                    <td>Operations</td>
                                                    <td>20 Sep 2025</td>
                                                    <td>22 Sep 2025</td>
                                                    <td>Maternity Leave</td>
                                                    <td>Pre-delivery care</td>
                                                    <td><span class="badge bg-warning-subtle text-warning">Pending</span></td>
                                                    <td>18 Sep 2025</td>
                                                    <td>--</td>
                                                    <td>
                                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                                            <a class="btn btn-success btn-icon btn-sm rounded-circle" href="#"><i class="ti ti-check fs-lg"></i></a>
                                                            <a class="btn btn-danger btn-icon btn-sm rounded-circle" href="#"><i class="ti ti-x fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 7 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>EMP-1199</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar-sm rounded-circle bg-light d-flex align-items-center justify-content-center me-2">
                                                                <i class="ti ti-user fs-lg text-muted"></i>
                                                            </div>
                                                            <span>Daniel Clark</span>
                                                        </div>
                                                    </td>
                                                    <td>Support</td>
                                                    <td>05 Sep 2025</td>
                                                    <td>06 Sep 2025</td>
                                                    <td>Casual Leave</td>
                                                    <td>Family function</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>03 Sep 2025</td>
                                                    <td>John Adams</td>
                                                    <td>
                                                        <div class="d-flex align-items-center justify-content-end gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 8 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>EMP-1210</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar-sm rounded-circle bg-light d-flex align-items-center justify-content-center me-2">
                                                                <i class="ti ti-user fs-lg text-muted"></i>
                                                            </div>
                                                            <span>Sarah Miller</span>
                                                        </div>
                                                    </td>
                                                    <td>Admin</td>
                                                    <td>25 Aug 2025</td>
                                                    <td>26 Aug 2025</td>
                                                    <td>Casual Leave</td>
                                                    <td>Out of town</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>22 Aug 2025</td>
                                                    <td>Maria Smith</td>
                                                    <td>
                                                        <div class="d-flex align-items-center justify-content-end gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 9 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>EMP-1225</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar-sm rounded-circle bg-light d-flex align-items-center justify-content-center me-2">
                                                                <i class="ti ti-user fs-lg text-muted"></i>
                                                            </div>
                                                            <span>Lucas Green</span>
                                                        </div>
                                                    </td>
                                                    <td>Sales</td>
                                                    <td>15 Aug 2025</td>
                                                    <td>16 Aug 2025</td>
                                                    <td>Paid Leave</td>
                                                    <td>Wedding attendance</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>12 Aug 2025</td>
                                                    <td>John Adams</td>
                                                    <td>
                                                        <div class="d-flex align-items-center justify-content-end gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <!-- Record 10 -->
                                                <tr>
                                                    <td><input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" /></td>
                                                    <td>EMP-1242</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="avatar-sm rounded-circle bg-light d-flex align-items-center justify-content-center me-2">
                                                                <i class="ti ti-user fs-lg text-muted"></i>
                                                            </div>
                                                            <span>Henry Walker</span>
                                                        </div>
                                                    </td>
                                                    <td>Logistics</td>
                                                    <td>10 Jul 2025</td>
                                                    <td>12 Jul 2025</td>
                                                    <td>Casual Leave</td>
                                                    <td>Travel with family</td>
                                                    <td><span class="badge bg-success-subtle text-success">Approved</span></td>
                                                    <td>08 Jul 2025</td>
                                                    <td>Maria Smith</td>
                                                    <td>
                                                        <div class="d-flex align-items-center justify-content-end gap-1">
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-eye fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                            <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <!-- end table-respo.-->
                                </div>
                                <!-- end card-body-->
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="records"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                    <!-- Add Leave Modal -->
                    <div aria-hidden="true" aria-labelledby="addLeaveModalLabel" class="modal fade" id="addLeaveModal" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-dialog-centered">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="addLeaveModalLabel">Add Leave Record</h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <form id="addLeaveForm">
                                    <div class="modal-body">
                                        <div class="row g-3">
                                            <!-- Employee ID -->
                                            <div class="col-md-4">
                                                <label class="form-label" for="employeeId">Employee ID</label>
                                                <input class="form-control" id="employeeId" placeholder="e.g., EMP-1056" required="" type="text" />
                                            </div>
                                            <!-- Employee Name -->
                                            <div class="col-md-4">
                                                <label class="form-label" for="employeeName">Employee Name</label>
                                                <input class="form-control" id="employeeName" placeholder="Enter name" required="" type="text" />
                                            </div>
                                            <!-- Department -->
                                            <div class="col-md-4">
                                                <label class="form-label" for="department">Department</label>
                                                <select class="form-select" id="department" required="">
                                                    <option value="">Select Department</option>
                                                    <option>HR</option>
                                                    <option>Finance</option>
                                                    <option>IT</option>
                                                    <option>Design</option>
                                                    <option>Marketing</option>
                                                    <option>Support</option>
                                                    <option>Operations</option>
                                                </select>
                                            </div>
                                            <!-- Date From -->
                                            <div class="col-md-4">
                                                <label class="form-label" for="dateFrom">Date From</label>
                                                <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="dateFrom" required="" type="date" />
                                            </div>
                                            <!-- Date To -->
                                            <div class="col-md-4">
                                                <label class="form-label" for="dateTo">Date To</label>
                                                <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="dateTo" required="" type="date" />
                                            </div>
                                            <!-- Leave Type -->
                                            <div class="col-md-4">
                                                <label class="form-label" for="leaveType">Leave Type</label>
                                                <select class="form-select" id="leaveType" required="">
                                                    <option value="">Select Leave Type</option>
                                                    <option>Sick Leave</option>
                                                    <option>Casual Leave</option>
                                                    <option>Paid Leave</option>
                                                    <option>Maternity Leave</option>
                                                    <option>Unpaid Leave</option>
                                                </select>
                                            </div>
                                            <!-- Reason -->
                                            <div class="col-md-12">
                                                <label class="form-label" for="reason">Reason</label>
                                                <textarea class="form-control" id="reason" placeholder="Enter reason" required="" rows="3"></textarea>
                                            </div>
                                            <!-- Status -->
                                            <div class="col-md-4">
                                                <label class="form-label" for="leave-status">Status</label>
                                                <select class="form-select" id="leave-status" required="">
                                                    <option value="">Select Status</option>
                                                    <option>Pending</option>
                                                    <option>Approved</option>
                                                    <option>Rejected</option>
                                                </select>
                                            </div>
                                            <!-- Approved By -->
                                            <div class="col-md-4">
                                                <label class="form-label" for="approvedBy">Approved By</label>
                                                <input class="form-control" id="approvedBy" placeholder="Approver name" type="text" />
                                            </div>
                                            <!-- Applied On -->
                                            <div class="col-md-4">
                                                <label class="form-label" for="appliedOn">Applied On</label>
                                                <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="appliedOn" type="date" />
                                            </div>
                                            <!-- Remarks -->
                                            <div class="col-md-12">
                                                <label class="form-label" for="remarks">Remarks</label>
                                                <textarea class="form-control" id="remarks" placeholder="Optional remarks..." rows="3"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn btn-light" data-bs-dismiss="modal" type="button">Cancel</button>
                                        <button class="btn btn-primary" type="submit">
                                            <i class="ti ti-device-floppy me-1"></i>
                                            Save Record
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
