<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Add Staff')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'HRM', 'title' => 'Add Staff')) ?>

                    <!-- Add New Staff Form -->
                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header card-tabs d-flex align-items-center">
                                    <div class="flex-grow-1">
                                        <h4 class="card-title">Fill Details</h4>
                                    </div>
                                    <!-- Nav Tabs -->
                                    <ul class="nav nav-tabs fw-semibold card-header-tabs nav-bordered" id="staffTabs" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" data-bs-target="#personal" data-bs-toggle="tab" id="personal-tab" type="button">Personal Info</button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" data-bs-target="#job" data-bs-toggle="tab" id="job-tab" type="button">Job Details</button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" data-bs-target="#bank" data-bs-toggle="tab" id="bank-tab" type="button">Bank &amp; Salary</button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" data-bs-target="#emergency" data-bs-toggle="tab" id="emergency-tab" type="button">Emergency Contact</button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" data-bs-target="#access" data-bs-toggle="tab" id="access-tab" type="button">System Access</button>
                                        </li>
                                    </ul>
                                </div>
                                <div class="card-body">
                                    <form id="addStaffForm">
                                        <div class="tab-content" id="staffTabsContent">
                                            <!-- Personal Info -->
                                            <div class="tab-pane fade show active" id="personal">
                                                <div class="row g-3">
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="firstName">First Name</label>
                                                        <input class="form-control" id="firstName" required="" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="lastName">Last Name</label>
                                                        <input class="form-control" id="lastName" required="" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="email">Email</label>
                                                        <input class="form-control" id="email" required="" type="email" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="phone">Phone</label>
                                                        <input class="form-control" id="phone" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="gender">Gender</label>
                                                        <select class="form-select" id="gender">
                                                            <option>Male</option>
                                                            <option>Female</option>
                                                            <option>Other</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="dob">Date of Birth</label>
                                                        <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="dob" type="date" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="maritalStatus">Marital Status</label>
                                                        <select class="form-select" id="maritalStatus">
                                                            <option>Single</option>
                                                            <option>Married</option>
                                                            <option>Divorced</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="nationality">Nationality</label>
                                                        <input class="form-control" id="nationality" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="bloodGroup">Blood Group</label>
                                                        <select class="form-select" id="bloodGroup">
                                                            <option>O+</option>
                                                            <option>O-</option>
                                                            <option>A+</option>
                                                            <option>A-</option>
                                                            <option>B+</option>
                                                            <option>B-</option>
                                                            <option>AB+</option>
                                                            <option>AB-</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <label class="form-label" for="address">Address</label>
                                                        <textarea class="form-control" id="address" rows="2"></textarea>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="city">City</label>
                                                        <input class="form-control" id="city" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="state">State</label>
                                                        <input class="form-control" id="state" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="country">Country</label>
                                                        <input class="form-control" id="country" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="postalCode">Postal Code</label>
                                                        <input class="form-control" id="postalCode" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="idType">ID Type</label>
                                                        <select class="form-select" id="idType">
                                                            <option>Passport</option>
                                                            <option>National ID</option>
                                                            <option>Driving License</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="idNumber">ID Number</label>
                                                        <input class="form-control" id="idNumber" type="text" />
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Job Details -->
                                            <div class="tab-pane fade" id="job">
                                                <div class="row g-3">
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="employeeId">Employee ID</label>
                                                        <input class="form-control" id="employeeId" placeholder="EMP-XXXX" type="text" value="EMP-8941" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="department">Department</label>
                                                        <select class="form-select" id="department">
                                                            <option>IT</option>
                                                            <option>HR</option>
                                                            <option>Finance</option>
                                                            <option>Design</option>
                                                            <option>Sales</option>
                                                            <option>Operations</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="designation">Designation</label>
                                                        <input class="form-control" id="designation" placeholder="e.g., Software Engineer" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="team">Team</label>
                                                        <input class="form-control" id="team" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="joiningDate">Joining Date</label>
                                                        <input class="form-control" data-date-format="d M, Y" data-provider="flatpickr" id="joiningDate" type="date" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="shift">Shift</label>
                                                        <select class="form-select" id="shift">
                                                            <option>Morning</option>
                                                            <option>Mid Shift</option>
                                                            <option>Night Shift</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="employmentType">Employment Type</label>
                                                        <select class="form-select" id="employmentType">
                                                            <option>Full-Time</option>
                                                            <option>Part-Time</option>
                                                            <option>Contract</option>
                                                            <option>Intern</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="workMode">Work Mode</label>
                                                        <select class="form-select" id="workMode">
                                                            <option>Onsite</option>
                                                            <option>Hybrid</option>
                                                            <option>Remote</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="manager">Manager / Reporting To</label>
                                                        <input class="form-control" id="manager" type="text" />
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Bank & Salary -->
                                            <div class="tab-pane fade" id="bank">
                                                <div class="row g-3">
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="bankName">Bank Name</label>
                                                        <input class="form-control" id="bankName" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="accountNumber">Account Number</label>
                                                        <input class="form-control" id="accountNumber" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="ifscCode">IFSC / SWIFT Code</label>
                                                        <input class="form-control" id="ifscCode" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="branch">Branch</label>
                                                        <input class="form-control" id="branch" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="taxId">PAN / Tax ID</label>
                                                        <input class="form-control" id="taxId" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="salary">Salary (Monthly)</label>
                                                        <input class="form-control" id="salary" placeholder="USD $" type="number" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="paymentMode">Payment Mode</label>
                                                        <select class="form-select" id="paymentMode">
                                                            <option>Bank Transfer</option>
                                                            <option>Cheque</option>
                                                            <option>Cash</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="pfNumber">PF Number</label>
                                                        <input class="form-control" id="pfNumber" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="esiNumber">ESI Number</label>
                                                        <input class="form-control" id="esiNumber" type="text" />
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- Emergency Contact -->
                                            <div class="tab-pane fade" id="emergency">
                                                <div class="row g-3">
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="emergencyName">Name</label>
                                                        <input class="form-control" id="emergencyName" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="emergencyRelation">Relation</label>
                                                        <input class="form-control" id="emergencyRelation" placeholder="e.g., Mother" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="emergencyPhone">Phone Number</label>
                                                        <input class="form-control" id="emergencyPhone" type="text" />
                                                    </div>
                                                    <div class="col-md-12">
                                                        <label class="form-label" for="emergencyAddress">Address</label>
                                                        <textarea class="form-control" id="emergencyAddress" rows="2"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- System Access -->
                                            <div class="tab-pane fade" id="access">
                                                <div class="row g-3">
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="username">Username</label>
                                                        <input class="form-control" id="username" type="text" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="password">Password</label>
                                                        <input class="form-control" id="password" type="password" />
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="role">Role</label>
                                                        <select class="form-select" id="role">
                                                            <option>Admin</option>
                                                            <option>Manager</option>
                                                            <option>Staff</option>
                                                            <option>HR</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="form-label" for="ac-status">Status</label>
                                                        <select class="form-select" id="ac-status">
                                                            <option>Active</option>
                                                            <option>Inactive</option>
                                                            <option>Suspended</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-check">
                                                            <input class="form-check-input" id="sendCredentials" type="checkbox" />
                                                            <label class="form-check-label" for="sendCredentials">Send login credentials to staff via email</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Buttons -->
                                        <div class="d-flex justify-content-end gap-2 mt-4">
                                            <button class="btn btn-light" type="reset">Reset</button>
                                            <button class="btn btn-success" type="submit">Save Staff</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->
                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
