<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Staff Profile')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'HRM', 'title' => 'Staff Profile')) ?>

                    <div class="container-xxl">
                        <div class="row">
                            <div class="col-xl-4">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex align-items-center mb-4">
                                            <div class="me-3 position-relative">
                                                <img alt="avatar" class="rounded-circle" height="72" src="/images/users/user-1.jpg" width="72" />
                                            </div>
                                            <div>
                                                <h5 class="mb-0 d-flex align-items-center">
                                                    <a class="link-reset" href="#!">David Dev</a>
                                                </h5>
                                                <p class="text-muted mb-2">Senior Developer</p>
                                                <span class="badge text-bg-light badge-label">Team Lead</span>
                                            </div>
                                            <div class="ms-auto">
                                                <div class="dropdown">
                                                    <a class="btn btn-icon btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                        <i class="ti ti-dots-vertical fs-xl"></i>
                                                    </a>
                                                    <ul class="dropdown-menu dropdown-menu-end">
                                                        <li>
                                                            <a class="dropdown-item" href="#">Edit Profile</a>
                                                        </li>
                                                        <li>
                                                            <a class="dropdown-item text-danger" href="#">Report</a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-center gap-2 mb-2">
                                            <div class="avatar-sm bg-light d-flex align-items-center justify-content-center rounded">
                                                <i class="ti ti-school fs-xl text-secondary"></i>
                                            </div>
                                            <p class="mb-0 fs-sm">
                                                Studied at
                                                <span class="text-dark fw-semibold">University of British Columbia</span>
                                            </p>
                                        </div>
                                        <div class="d-flex align-items-center gap-2 mb-2">
                                            <div class="avatar-sm bg-light d-flex align-items-center justify-content-center rounded">
                                                <i class="ti ti-map-pin fs-xl text-secondary"></i>
                                            </div>
                                            <p class="mb-0 fs-sm">
                                                Lives in
                                                <span class="text-dark fw-semibold">Vancouver, Canada</span>
                                            </p>
                                        </div>
                                        <div class="d-flex align-items-center gap-2 mb-2">
                                            <div class="avatar-sm bg-light d-flex align-items-center justify-content-center rounded">
                                                <i class="ti ti-users fs-xl text-secondary"></i>
                                            </div>
                                            <p class="mb-0 fs-sm">
                                                Works in
                                                <span class="text-dark fw-semibold">Finance &amp; Accounting Department</span>
                                            </p>
                                        </div>
                                        <div class="d-flex align-items-center gap-2 mb-2">
                                            <div class="avatar-sm bg-light d-flex align-items-center justify-content-center rounded">
                                                <i class="ti ti-mail fs-xl text-secondary"></i>
                                            </div>
                                            <p class="mb-0 fs-sm">
                                                Email
                                                <a class="text-primary fw-semibold" href="/mailto:yogesh@company.com">emp2045@company.com</a>
                                            </p>
                                        </div>
                                        <div class="d-flex align-items-center gap-2 mb-2">
                                            <div class="avatar-sm bg-light d-flex align-items-center justify-content-center rounded">
                                                <i class="ti ti-link fs-xl text-secondary"></i>
                                            </div>
                                            <p class="mb-0 fs-sm">
                                                Employee ID
                                                <span class="text-dark fw-semibold">EMP-2045</span>
                                            </p>
                                        </div>
                                        <div class="d-flex align-items-center gap-2">
                                            <div class="avatar-sm bg-light d-flex align-items-center justify-content-center rounded">
                                                <i class="ti ti-world fs-xl text-secondary"></i>
                                            </div>
                                            <p class="mb-0 fs-sm">
                                                Languages
                                                <span class="text-dark fw-semibold">English, French</span>
                                            </p>
                                        </div>
                                        <!-- -->
                                    </div>
                                    <!-- end card-body-->
                                </div>
                                <!-- end card-->
                            </div>
                            <!-- end col -->
                            <div class="col-xl-8">
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title">About Employee</h4>
                                    </div>
                                    <div class="card-body">
                                        <p class="m-0">
                                            <strong>Alex Johnson</strong>
                                            is a passionate and results-driven
                                            <span class="text-primary fw-semibold">Project Manager</span>
                                            with over 6 years of experience in managing cross-functional teams and delivering projects on time and within budget. Alex specializes in planning, process optimization, and team leadership across multiple domains.
                                        </p>
                                        <p class="mt-3 mb-0">
                                            Known for strong communication and organizational skills, Alex has successfully led various digital transformation initiatives and implemented efficient workflows that improved team productivity. In free time, Alex enjoys learning new
                                            technologies and mentoring young professionals.
                                        </p>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title">Basic Information</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row g-3">
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Phone</p>
                                                <p class="mb-0">+1 312 555 9482</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Email</p>
                                                <p class="mb-0">alex.johnson@example.com</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Gender</p>
                                                <p class="mb-0">Male</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Birthday</p>
                                                <p class="mb-0">15th March 1988</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Address</p>
                                                <p class="mb-0">742 Evergreen Terrace, Chicago</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Nationality</p>
                                                <p class="mb-0">American</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Blood Group</p>
                                                <p class="mb-0">A+ve</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Shift</p>
                                                <p class="mb-0">Day Shift</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card-->
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title">Emergency Contact Details</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row g-3">
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Contact Name</p>
                                                <p class="mb-0">Sarah Johnson</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Relationship</p>
                                                <p class="mb-0">Spouse</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Phone</p>
                                                <p class="mb-0">+1 312 555 7854</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Alternate Phone</p>
                                                <p class="mb-0">+1 312 555 9685</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Email</p>
                                                <p class="mb-0">sarah.johnson@example.com</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Address</p>
                                                <p class="mb-0">742 Evergreen Terrace, Chicago</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-header">
                                        <h4 class="card-title">Financial Details</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row g-3">
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Bank Name</p>
                                                <p class="mb-0">Bank of America</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Account Number</p>
                                                <p class="mb-0">**** **** **** 9845</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">IFSC / SWIFT Code</p>
                                                <p class="mb-0">BOFAUS3NXXX</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Branch</p>
                                                <p class="mb-0">Downtown Chicago Branch</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">PAN / Tax ID</p>
                                                <p class="mb-0">TXN-9823645</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Salary (Monthly)</p>
                                                <p class="mb-0">USD $6,500</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">Payment Mode</p>
                                                <p class="mb-0">Bank Transfer</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">PF Number</p>
                                                <p class="mb-0">PF-20458-CH</p>
                                            </div>
                                            <div class="col-md-4">
                                                <p class="mb-1 text-muted fw-medium">ESI Number</p>
                                                <p class="mb-0">ESI-985721</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end col-->
                        </div>
                        <!-- end row-->
                    </div>
                    <!-- end container -->
                </div>
                <!-- container-fluid -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
