<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Issue List')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Apps', 'title' => 'Issue List')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="8">
                                <div class="card-header border-light justify-content-between">
                                    <div class="app-search">
                                        <input class="form-control" data-table-search="" placeholder="Search issues..." type="search" />
                                        <i class="ti ti-search app-search-icon text-muted"></i>
                                    </div>
                                    <button class="btn btn-success" type="submit">Add New Issues</button>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <div class="table-responsive">
                                            <table class="table table-custom table-centered table-hover w-100 mb-0">
                                                <tbody>
                                                    <tr>
                                                        <!-- Status -->
                                                        <td>
                                                            <span class="badge text-bg-warning fs-xxs badge-label">In Progress</span>
                                                        </td>
                                                        <!-- Issue ID and Title -->
                                                        <td>
                                                            <a class="link-reset text-uppercase fw-semibold" data-bs-target="#issueDetailsModal" data-bs-toggle="modal" href="#!">ISSUE-104</a>
                                                            <p class="mb-0 text-muted">User profile update not saving on mobile devices</p>
                                                        </td>
                                                        <!-- Assigned To -->
                                                        <td>
                                                            <div class="d-flex justify-content-start align-items-center gap-2">
                                                                <div class="avatar avatar-xs">
                                                                    <img alt="avatar-3" class="img-fluid rounded-circle" src="/images/users/user-3.jpg" />
                                                                </div>
                                                                <div>
                                                                    <h5 class="text-nowrap mb-0 lh-base">Jason Lee</h5>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <!-- Created / Due Dates -->
                                                        <td>
                                                            <p class="mb-0">
                                                                <i class="ti ti-calendar"></i>
                                                                <span class="fw-semibold">Created:</span>
                                                                10.02.2025
                                                            </p>
                                                            <p class="mb-0">
                                                                <i class="ti ti-clock"></i>
                                                                <span class="fw-semibold">Due:</span>
                                                                15.02.2025
                                                            </p>
                                                        </td>
                                                        <!-- Tags -->
                                                        <td>
                                                            <a class="badge badge-label badge-default" href="#!">Mobile</a>
                                                            <a class="badge badge-label badge-default" href="#!">UI</a>
                                                            <a class="badge badge-label badge-default" href="#!">Urgent</a>
                                                        </td>
                                                        <!-- Progress -->
                                                        <td>
                                                            <div class="progress progress-sm" style="height: 6px">
                                                                <div class="progress-bar bg-warning" role="progressbar" style="width: 60%"></div>
                                                            </div>
                                                            <small class="text-muted">60% Complete</small>
                                                        </td>
                                                        <!-- Comments -->
                                                        <td>
                                                            <i class="ti ti-message-circle text-muted me-1"></i>
                                                            12 comments
                                                        </td>
                                                        <!-- Attachments -->
                                                        <td>
                                                            <i class="ti ti-paperclip text-muted me-1"></i>
                                                            3 files
                                                        </td>
                                                        <!-- Actions -->
                                                        <td>
                                                            <div class="d-flex align-items-center justify-content-center gap-1">
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-eye fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-edit fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                                    <i class="ti ti-trash fs-lg"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <span class="badge text-bg-danger fs-xxs badge-label">Open</span>
                                                        </td>
                                                        <td>
                                                            <a class="link-reset text-uppercase fw-semibold" data-bs-target="#issueDetailsModal" data-bs-toggle="modal" href="#!">ISSUE-105</a>
                                                            <p class="mb-0 text-muted">Payment gateway fails to respond on checkout</p>
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center gap-2">
                                                                <div class="avatar avatar-xs">
                                                                    <img alt="avatar-4" class="img-fluid rounded-circle" src="/images/users/user-4.jpg" />
                                                                </div>
                                                                <div>
                                                                    <h5 class="mb-0 lh-base">Sophia Mendes</h5>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <p class="mb-0">
                                                                <i class="ti ti-calendar"></i>
                                                                <span class="fw-semibold">Created:</span>
                                                                08.02.2025
                                                            </p>
                                                            <p class="mb-0">
                                                                <i class="ti ti-clock"></i>
                                                                <span class="fw-semibold">Due:</span>
                                                                14.02.2025
                                                            </p>
                                                        </td>
                                                        <td>
                                                            <a class="badge badge-label badge-default" href="#!">Payments</a>
                                                            <a class="badge badge-label badge-default" href="#!">Critical</a>
                                                        </td>
                                                        <td>
                                                            <div class="progress progress-sm" style="height: 6px">
                                                                <div class="progress-bar bg-danger" role="progressbar" style="width: 25%"></div>
                                                            </div>
                                                            <small class="text-muted">25% Complete</small>
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-message-circle text-muted me-1"></i>
                                                            8 comments
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-paperclip text-muted me-1"></i>
                                                            2 files
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center justify-content-center gap-1">
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-eye fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-edit fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                                    <i class="ti ti-trash fs-lg"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <span class="badge text-bg-success fs-xxs badge-label">Resolved</span>
                                                        </td>
                                                        <td>
                                                            <a class="link-reset text-uppercase fw-semibold" data-bs-target="#issueDetailsModal" data-bs-toggle="modal" href="#!">ISSUE-106</a>
                                                            <p class="mb-0 text-muted">Dark mode breaks UI on dashboard view</p>
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center gap-2">
                                                                <div class="avatar avatar-xs">
                                                                    <img alt="avatar-2" class="img-fluid rounded-circle" src="/images/users/user-2.jpg" />
                                                                </div>
                                                                <div>
                                                                    <h5 class="mb-0 lh-base">Mason Clark</h5>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <p class="mb-0">
                                                                <i class="ti ti-calendar"></i>
                                                                <span class="fw-semibold">Created:</span>
                                                                03.02.2025
                                                            </p>
                                                            <p class="mb-0">
                                                                <i class="ti ti-clock"></i>
                                                                <span class="fw-semibold">Resolved:</span>
                                                                07.02.2025
                                                            </p>
                                                        </td>
                                                        <td>
                                                            <a class="badge badge-label badge-default" href="#!">UI</a>
                                                            <a class="badge badge-label badge-default" href="#!">Enhancement</a>
                                                        </td>
                                                        <td>
                                                            <div class="progress progress-sm" style="height: 6px">
                                                                <div class="progress-bar bg-success" role="progressbar" style="width: 100%"></div>
                                                            </div>
                                                            <small class="text-muted">100% Complete</small>
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-message-circle text-muted me-1"></i>
                                                            15 comments
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-paperclip text-muted me-1"></i>
                                                            1 file
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center justify-content-center gap-1">
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-eye fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-edit fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                                    <i class="ti ti-trash fs-lg"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <span class="badge text-bg-info fs-xxs badge-label">Review</span>
                                                        </td>
                                                        <td>
                                                            <a class="link-reset text-uppercase fw-semibold" data-bs-target="#issueDetailsModal" data-bs-toggle="modal" href="#!">ISSUE-107</a>
                                                            <p class="mb-0 text-muted">Push notifications are delayed by 5-10 minutes</p>
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center gap-2">
                                                                <div class="avatar avatar-xs">
                                                                    <img alt="avatar-5" class="img-fluid rounded-circle" src="/images/users/user-5.jpg" />
                                                                </div>
                                                                <div>
                                                                    <h5 class="mb-0 lh-base">Olivia Stone</h5>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <p class="mb-0">
                                                                <i class="ti ti-calendar"></i>
                                                                <span class="fw-semibold">Created:</span>
                                                                11.02.2025
                                                            </p>
                                                            <p class="mb-0">
                                                                <i class="ti ti-clock"></i>
                                                                <span class="fw-semibold">Due:</span>
                                                                17.02.2025
                                                            </p>
                                                        </td>
                                                        <td>
                                                            <a class="badge badge-label badge-default" href="#!">Notification</a>
                                                            <a class="badge badge-label badge-default" href="#!">Backend</a>
                                                        </td>
                                                        <td>
                                                            <div class="progress progress-sm" style="height: 6px">
                                                                <div class="progress-bar bg-info" role="progressbar" style="width: 40%"></div>
                                                            </div>
                                                            <small class="text-muted">40% Complete</small>
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-message-circle text-muted me-1"></i>
                                                            5 comments
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-paperclip text-muted me-1"></i>
                                                            0 files
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center justify-content-center gap-1">
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-eye fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-edit fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                                    <i class="ti ti-trash fs-lg"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <span class="badge text-bg-secondary fs-xxs badge-label">Pending</span>
                                                        </td>
                                                        <td>
                                                            <a class="link-reset text-uppercase fw-semibold" data-bs-target="#issueDetailsModal" data-bs-toggle="modal" href="#!">ISSUE-108</a>
                                                            <p class="mb-0 text-muted">Contact page returns 404 after deployment</p>
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center gap-2">
                                                                <div class="avatar avatar-xs">
                                                                    <img alt="avatar-1" class="img-fluid rounded-circle" src="/images/users/user-1.jpg" />
                                                                </div>
                                                                <div>
                                                                    <h5 class="mb-0 lh-base">Daniel Reed</h5>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <p class="mb-0">
                                                                <i class="ti ti-calendar"></i>
                                                                <span class="fw-semibold">Created:</span>
                                                                09.02.2025
                                                            </p>
                                                            <p class="mb-0">
                                                                <i class="ti ti-clock"></i>
                                                                <span class="fw-semibold">Due:</span>
                                                                13.02.2025
                                                            </p>
                                                        </td>
                                                        <td>
                                                            <a class="badge badge-label badge-default" href="#!">Deployment</a>
                                                            <a class="badge badge-label badge-default" href="#!">Routing</a>
                                                        </td>
                                                        <td>
                                                            <div class="progress progress-sm" style="height: 6px">
                                                                <div class="progress-bar bg-secondary" role="progressbar" style="width: 10%"></div>
                                                            </div>
                                                            <small class="text-muted">10% Complete</small>
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-message-circle text-muted me-1"></i>
                                                            2 comments
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-paperclip text-muted me-1"></i>
                                                            1 file
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center justify-content-center gap-1">
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-eye fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-edit fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                                    <i class="ti ti-trash fs-lg"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <span class="badge text-bg-warning fs-xxs badge-label">In Review</span>
                                                        </td>
                                                        <td>
                                                            <a class="link-reset text-uppercase fw-semibold" data-bs-target="#issueDetailsModal" data-bs-toggle="modal" href="#!">ISSUE-109</a>
                                                            <p class="mb-0 text-muted">Export to PDF does not include chart section</p>
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center gap-2">
                                                                <div class="avatar avatar-xs">
                                                                    <img alt="avatar-6" class="img-fluid rounded-circle" src="/images/users/user-6.jpg" />
                                                                </div>
                                                                <div>
                                                                    <h5 class="mb-0 lh-base">Nathan White</h5>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <p class="mb-0">
                                                                <i class="ti ti-calendar"></i>
                                                                <span class="fw-semibold">Created:</span>
                                                                12.02.2025
                                                            </p>
                                                            <p class="mb-0">
                                                                <i class="ti ti-clock"></i>
                                                                <span class="fw-semibold">Due:</span>
                                                                18.02.2025
                                                            </p>
                                                        </td>
                                                        <td>
                                                            <a class="badge badge-label badge-default" href="#!">Export</a>
                                                            <a class="badge badge-label badge-default" href="#!">Charts</a>
                                                        </td>
                                                        <td>
                                                            <div class="progress progress-sm" style="height: 6px">
                                                                <div class="progress-bar bg-warning" role="progressbar" style="width: 50%"></div>
                                                            </div>
                                                            <small class="text-muted">50% Complete</small>
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-message-circle text-muted me-1"></i>
                                                            6 comments
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-paperclip text-muted me-1"></i>
                                                            2 files
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center justify-content-center gap-1">
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-eye fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-edit fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                                    <i class="ti ti-trash fs-lg"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <span class="badge text-bg-danger fs-xxs badge-label">Open</span>
                                                        </td>
                                                        <td>
                                                            <a class="link-reset text-uppercase fw-semibold" data-bs-target="#issueDetailsModal" data-bs-toggle="modal" href="#!">ISSUE-110</a>
                                                            <p class="mb-0 text-muted">Search bar does not return any results for valid keywords</p>
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center gap-2">
                                                                <div class="avatar avatar-xs">
                                                                    <img alt="avatar-9" class="img-fluid rounded-circle" src="/images/users/user-9.jpg" />
                                                                </div>
                                                                <div>
                                                                    <h5 class="mb-0 lh-base">Emma Watson</h5>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <p class="mb-0">
                                                                <i class="ti ti-calendar"></i>
                                                                <span class="fw-semibold">Created:</span>
                                                                13.02.2025
                                                            </p>
                                                            <p class="mb-0">
                                                                <i class="ti ti-clock"></i>
                                                                <span class="fw-semibold">Due:</span>
                                                                16.02.2025
                                                            </p>
                                                        </td>
                                                        <td>
                                                            <a class="badge badge-label badge-default" href="#!">Search</a>
                                                            <a class="badge badge-label badge-default" href="#!">Bug</a>
                                                        </td>
                                                        <td>
                                                            <div class="progress progress-sm" style="height: 6px">
                                                                <div class="progress-bar bg-danger" role="progressbar" style="width: 20%"></div>
                                                            </div>
                                                            <small class="text-muted">20% Complete</small>
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-message-circle text-muted me-1"></i>
                                                            4 comments
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-paperclip text-muted me-1"></i>
                                                            0 files
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center justify-content-center gap-1">
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-eye fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-edit fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                                    <i class="ti ti-trash fs-lg"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <span class="badge text-bg-warning fs-xxs badge-label">In Progress</span>
                                                        </td>
                                                        <td>
                                                            <a class="link-reset text-uppercase fw-semibold" data-bs-target="#issueDetailsModal" data-bs-toggle="modal" href="#!">ISSUE-111</a>
                                                            <p class="mb-0 text-muted">Email verification link expires instantly after signup</p>
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center gap-2">
                                                                <div class="avatar avatar-xs">
                                                                    <img alt="avatar-10" class="img-fluid rounded-circle" src="/images/users/user-10.jpg" />
                                                                </div>
                                                                <div>
                                                                    <h5 class="mb-0 lh-base">Ava Johnson</h5>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <p class="mb-0">
                                                                <i class="ti ti-calendar"></i>
                                                                <span class="fw-semibold">Created:</span>
                                                                10.02.2025
                                                            </p>
                                                            <p class="mb-0">
                                                                <i class="ti ti-clock"></i>
                                                                <span class="fw-semibold">Due:</span>
                                                                20.02.2025
                                                            </p>
                                                        </td>
                                                        <td>
                                                            <a class="badge badge-label badge-default" href="#!">Authentication</a>
                                                            <a class="badge badge-label badge-default" href="#!">High Priority</a>
                                                        </td>
                                                        <td>
                                                            <div class="progress progress-sm" style="height: 6px">
                                                                <div class="progress-bar bg-warning" role="progressbar" style="width: 45%"></div>
                                                            </div>
                                                            <small class="text-muted">45% Complete</small>
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-message-circle text-muted me-1"></i>
                                                            6 comments
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-paperclip text-muted me-1"></i>
                                                            1 file
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center justify-content-center gap-1">
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-eye fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-edit fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                                    <i class="ti ti-trash fs-lg"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <span class="badge text-bg-info fs-xxs badge-label">Review</span>
                                                        </td>
                                                        <td>
                                                            <a class="link-reset text-uppercase fw-semibold" data-bs-target="#issueDetailsModal" data-bs-toggle="modal" href="#!">ISSUE-112</a>
                                                            <p class="mb-0 text-muted">Footer links appear broken on Safari browser</p>
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center gap-2">
                                                                <div class="avatar avatar-xs">
                                                                    <img alt="avatar-8" class="img-fluid rounded-circle" src="/images/users/user-8.jpg" />
                                                                </div>
                                                                <div>
                                                                    <h5 class="mb-0 lh-base">Liam Gray</h5>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <p class="mb-0">
                                                                <i class="ti ti-calendar"></i>
                                                                <span class="fw-semibold">Created:</span>
                                                                12.02.2025
                                                            </p>
                                                            <p class="mb-0">
                                                                <i class="ti ti-clock"></i>
                                                                <span class="fw-semibold">Due:</span>
                                                                19.02.2025
                                                            </p>
                                                        </td>
                                                        <td>
                                                            <a class="badge badge-label badge-default" href="#!">UI</a>
                                                            <a class="badge badge-label badge-default" href="#!">Safari</a>
                                                            <a class="badge badge-label badge-default" href="#!">Low</a>
                                                        </td>
                                                        <td>
                                                            <div class="progress progress-sm" style="height: 6px">
                                                                <div class="progress-bar bg-info" role="progressbar" style="width: 30%"></div>
                                                            </div>
                                                            <small class="text-muted">30% Complete</small>
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-message-circle text-muted me-1"></i>
                                                            3 comments
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-paperclip text-muted me-1"></i>
                                                            0 files
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center justify-content-center gap-1">
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-eye fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-edit fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                                    <i class="ti ti-trash fs-lg"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>
                                                            <span class="badge text-bg-secondary fs-xxs badge-label">Pending</span>
                                                        </td>
                                                        <td>
                                                            <a class="link-reset text-uppercase fw-semibold" data-bs-target="#issueDetailsModal" data-bs-toggle="modal" href="#!">ISSUE-113</a>
                                                            <p class="mb-0 text-muted">Reports are showing times in UTC instead of local timezone</p>
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center gap-2">
                                                                <div class="avatar avatar-xs">
                                                                    <img alt="avatar-11" class="img-fluid rounded-circle" src="/images/users/user-1.jpg" />
                                                                </div>
                                                                <div>
                                                                    <h5 class="mb-0 lh-base">Noah Mitchell</h5>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <p class="mb-0">
                                                                <i class="ti ti-calendar"></i>
                                                                <span class="fw-semibold">Created:</span>
                                                                14.02.2025
                                                            </p>
                                                            <p class="mb-0">
                                                                <i class="ti ti-clock"></i>
                                                                <span class="fw-semibold">Due:</span>
                                                                22.02.2025
                                                            </p>
                                                        </td>
                                                        <td>
                                                            <a class="badge badge-label badge-default" href="#!">Reports</a>
                                                            <a class="badge badge-label badge-default" href="#!">Timezone</a>
                                                        </td>
                                                        <td>
                                                            <div class="progress progress-sm" style="height: 6px">
                                                                <div class="progress-bar bg-secondary" role="progressbar" style="width: 15%"></div>
                                                            </div>
                                                            <small class="text-muted">15% Complete</small>
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-message-circle text-muted me-1"></i>
                                                            1 comment
                                                        </td>
                                                        <td>
                                                            <i class="ti ti-paperclip text-muted me-1"></i>
                                                            1 file
                                                        </td>
                                                        <td>
                                                            <div class="d-flex align-items-center justify-content-center gap-1">
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-eye fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" href="javascript:void(0);">
                                                                    <i class="ti ti-edit fs-lg"></i>
                                                                </a>
                                                                <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                                    <i class="ti ti-trash fs-lg"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                                <!-- end table-body -->
                                            </table>
                                            <!-- end table -->
                                        </div>
                                        <div class="d-flex justify-content-between align-items-center mt-3">
                                            <div data-table-pagination-info="issues"></div>
                                            <div data-table-pagination=""></div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                    <!-- Issue Details Modal -->
                    <div aria-hidden="true" aria-labelledby="issueDetailsModalLabel" class="modal fade" id="issueDetailsModal" tabindex="-1">
                        <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-scrollable">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title fw-bold" id="issueDetailsModalLabel">Issue Details</h5>
                                    <button aria-label="Close" class="btn-close" data-bs-dismiss="modal" type="button"></button>
                                </div>
                                <div class="modal-body">
                                    <!-- Status + Title -->
                                    <div class="d-flex align-items-center gap-2 mb-3">
                                        <span class="badge bg-warning-subtle text-warning px-2 py-1 rounded-pill fs-xs">In Progress</span>
                                        <h5 class="mb-0 fw-semibold">ISSUE-104 — User profile update not saving on mobile devices</h5>
                                    </div>
                                    <!-- Assigned User -->
                                    <div class="d-flex align-items-center mb-3">
                                        <img alt="User" class="rounded-circle me-2" height="40" src="/images/users/user-1.jpg" width="40" />
                                        <div>
                                            <h5 class="mb-0">Jason Lee</h5>
                                            <small class="text-muted">Assigned User</small>
                                        </div>
                                    </div>
                                    <!-- Dates -->
                                    <div class="row mb-3">
                                        <div class="col-md-4">
                                            <strong>Created:</strong>
                                            10 Feb 2025
                                        </div>
                                        <div class="col-md-4">
                                            <strong>Due:</strong>
                                            15 Feb 2025
                                        </div>
                                        <div class="col-md-4">
                                            <!-- Tags -->
                                            <div class="mb-1">
                                                <span class="badge badge-label text-bg-light fs-xxs">Mobile</span>
                                                <span class="badge badge-label text-bg-light fs-xxs">UI</span>
                                                <span class="badge bg-light text-danger fs-xxs">Urgent</span>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Description -->
                                    <p class="text-muted">User profile update is not saving correctly on mobile devices. This issue occurs on iOS Safari and Android Chrome. Needs urgent fix before next release.</p>
                                    <!-- Progress -->
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between">
                                            <small class="mb-2 text-uppercase">Progress</small>
                                            <small class="fw-bold text-warning">60% Complete</small>
                                        </div>
                                        <div class="progress" style="height: 6px">
                                            <div class="progress-bar bg-warning" style="width: 60%"></div>
                                        </div>
                                    </div>
                                    <!-- Comments & Files -->
                                    <div class="row text-center mb-3">
                                        <div class="col-md-6">
                                            <i class="ti ti-message me-1"></i>
                                            <strong>12 Comments</strong>
                                        </div>
                                        <div class="col-md-6">
                                            <i class="ti ti-paperclip me-1"></i>
                                            <strong>3 Files Attached</strong>
                                        </div>
                                    </div>
                                    <!-- File List Example -->
                                    <ul class="list-group mb-3">
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            <span>profile-update-bug.txt</span>
                                            <a class="btn btn-sm btn-outline-primary" href="#">Download</a>
                                        </li>
                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                            <span>screenshot-mobile.png</span>
                                            <a class="btn btn-sm btn-outline-primary" href="#">Download</a>
                                        </li>
                                    </ul>
                                </div>
                                <div class="modal-footer">
                                    <button class="btn btn-light" data-bs-dismiss="modal" type="button">Close</button>
                                    <button class="btn btn-primary" type="button">Edit Issue</button>
                                    <button class="btn btn-danger" type="button">Delete Issue</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
