<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Manage Apps')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Apps', 'title' => 'Manage Apps')) ?>

                    <div class="row">
                        <div class="col-12">
                            <h5 class="mb-1 fs-lg">Authorized Apps</h5>
                            <p class="text-muted">
                                You’re currently using
                                <strong>3 of 3</strong>
                                free integrations. Upgrade to
                                <a class="text-decoration-underline" href="#">PRO</a>
                                to unlock more integrations and supercharge your workflow.
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <!-- Google Analytics Card -->
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <!-- Logo + Title -->
                                        <div class="d-flex align-items-center gap-3">
                                            <img alt="Google Analytics Logo" class="rounded" height="48" src="/images/logos/google.svg" width="48" />
                                            <div>
                                                <h5 class="card-title mb-1">Google Analytics</h5>
                                                <p class="text-muted mb-0">Google Analytics is a free web analytics service offered by Google that tracks and reports website traffic.</p>
                                            </div>
                                        </div>
                                        <!-- Toggle Switch -->
                                        <div class="form-check form-switch">
                                            <input checked="" class="form-check-input" id="gaToggle" type="checkbox" />
                                        </div>
                                    </div>
                                    <!-- Info Badges -->
                                    <div class="mb-3 d-flex flex-wrap gap-2">
                                        <span class="badge bg-light text-primary px-2 py-1 rounded-pill">Free Plan</span>
                                        <span class="badge bg-success-subtle text-success px-2 py-1 rounded-pill">Connected</span>
                                        <span class="badge bg-info-subtle text-info px-2 py-1 rounded-pill">Sync: Every 15 mins</span>
                                    </div>
                                    <!-- Connection Details -->
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <p class="fs-xxs text-uppercase fw-bold mb-0 text-muted">Connected Account</p>
                                            <span>analytics@domain.com</span>
                                        </div>
                                        <div class="col-md-6">
                                            <p class="fs-xxs text-uppercase fw-bold mb-0 text-muted">Last Sync</p>
                                            <span>12:56 pm, 12 May</span>
                                        </div>
                                    </div>
                                    <!-- Progress or Stats Example -->
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between">
                                            <span class="mb-2 fw-bold fs-xs">Usage</span>
                                            <small class="fw-bold text-success">80% of quota</small>
                                        </div>
                                        <div class="progress" style="height: 6px">
                                            <div class="progress-bar bg-success" style="width: 80%"></div>
                                        </div>
                                    </div>
                                    <!-- Action Buttons -->
                                    <div class="d-flex gap-2">
                                        <button class="btn btn-outline-danger w-50">Remove</button>
                                        <button class="btn btn-outline-primary w-50" data-bs-toggle="tooltip" title="View integration details">Details</button>
                                    </div>
                                </div>
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                        <!-- Asana Card -->
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <!-- Logo + Title -->
                                        <div class="d-flex align-items-center gap-3">
                                            <img alt="Asana Logo" class="rounded" height="48" src="/images/logos/asana.svg" width="48" />
                                            <div>
                                                <h5 class="card-title mb-1">Asana</h5>
                                                <p class="text-muted mb-0">Asana is a work management platform that helps teams organize, track, and manage their work more effectively.</p>
                                            </div>
                                        </div>
                                        <!-- Toggle Switch -->
                                        <div class="form-check form-switch">
                                            <input checked="" class="form-check-input" id="asanaToggle" type="checkbox" />
                                        </div>
                                    </div>
                                    <!-- Info Badges -->
                                    <div class="mb-3 d-flex flex-wrap gap-2">
                                        <span class="badge bg-light text-primary px-2 py-1 rounded-pill">Premium Plan</span>
                                        <span class="badge bg-success-subtle text-success px-2 py-1 rounded-pill">Connected</span>
                                        <span class="badge bg-info-subtle text-info px-2 py-1 rounded-pill">Sync: Every 10 mins</span>
                                    </div>
                                    <!-- Connection Details -->
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <p class="fs-xxs text-uppercase fw-bold mb-0 text-muted">Connected Account</p>
                                            <span>project@asana.com</span>
                                        </div>
                                        <div class="col-md-6">
                                            <p class="fs-xxs text-uppercase fw-bold mb-0 text-muted">Last Sync</p>
                                            <span>09:30 am, 18 May</span>
                                        </div>
                                    </div>
                                    <!-- Progress or Stats Example -->
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between">
                                            <span class="mb-2 fw-bold fs-xs">Usage</span>
                                            <small class="fw-bold text-success">65% of quota</small>
                                        </div>
                                        <div class="progress" style="height: 6px">
                                            <div class="progress-bar bg-success" style="width: 65%"></div>
                                        </div>
                                    </div>
                                    <!-- Action Buttons -->
                                    <div class="d-flex gap-2">
                                        <button class="btn btn-outline-danger w-50">Remove</button>
                                        <button class="btn btn-outline-primary w-50" data-bs-toggle="tooltip" title="View integration details">Details</button>
                                    </div>
                                </div>
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                        <!-- Dropbox Card -->
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <!-- Logo + Title -->
                                        <div class="d-flex align-items-center gap-3">
                                            <img alt="Dropbox Logo" class="rounded" height="48" src="/images/logos/dropbox.svg" width="48" />
                                            <div>
                                                <h5 class="card-title mb-1">Dropbox</h5>
                                                <p class="text-muted mb-0">Dropbox is a cloud storage platform for securely storing, sharing, and accessing files from anywhere.</p>
                                            </div>
                                        </div>
                                        <!-- Toggle Switch -->
                                        <div class="form-check form-switch">
                                            <input checked="" class="form-check-input" id="dropboxToggle" type="checkbox" />
                                        </div>
                                    </div>
                                    <!-- Info Badges -->
                                    <div class="mb-3 d-flex flex-wrap gap-2">
                                        <span class="badge bg-light text-primary px-2 py-1 rounded-pill">Business Plan</span>
                                        <span class="badge bg-success-subtle text-success px-2 py-1 rounded-pill">Connected</span>
                                        <span class="badge bg-info-subtle text-info px-2 py-1 rounded-pill">Sync: Every 30 mins</span>
                                    </div>
                                    <!-- Connection Details -->
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <p class="fs-xxs text-uppercase fw-bold mb-0 text-muted">Connected Account</p>
                                            <span>files@dropbox.com</span>
                                        </div>
                                        <div class="col-md-6">
                                            <p class="fs-xxs text-uppercase fw-bold mb-0 text-muted">Last Sync</p>
                                            <span>03:45 pm, 19 May</span>
                                        </div>
                                    </div>
                                    <!-- Progress or Stats Example -->
                                    <div class="mb-3">
                                        <div class="d-flex justify-content-between">
                                            <span class="mb-2 fw-bold fs-xs">Usage</span>
                                            <small class="fw-bold text-success">92% of quota</small>
                                        </div>
                                        <div class="progress" style="height: 6px">
                                            <div class="progress-bar bg-success" style="width: 92%"></div>
                                        </div>
                                    </div>
                                    <!-- Action Buttons -->
                                    <div class="d-flex gap-2">
                                        <button class="btn btn-outline-danger w-50">Remove</button>
                                        <button class="btn btn-outline-primary w-50" data-bs-toggle="tooltip" title="View integration details">Details</button>
                                    </div>
                                </div>
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                    <div class="row my-2">
                        <div class="col-12 text-center">
                            <h5 class="mb-1 fs-lg">Explore More Integrations</h5>
                            <p class="text-muted mb-3">Discover over 200 integrations to enhance your workflow</p>
                        </div>
                    </div>
                    <div class="row">
                        <!-- Amazon Card -->
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <span class="avatar-xl d-block mb-1">
                                            <span class="avatar-title bg-light bg-opacity-75 rounded">
                                                <img alt="Amazon Logo" height="30" src="/images/logos/amazon.svg" />
                                            </span>
                                        </span>
                                        <span class="badge badge-label text-bg-light">Free</span>
                                    </div>
                                    <h5 class="card-title mb-1">Amazon</h5>
                                    <p class="card-text text-muted">Amazon Web Services offers scalable cloud computing and hosting solutions for businesses of all sizes...</p>
                                    <div class="mb-3 d-flex align-items-center gap-1">
                                        <i class="ti ti-world"></i>
                                        <a class="link-reset" href="#!">www.amazon.com</a>
                                    </div>
                                    <div class="d-flex gap-2">
                                        <button class="btn btn-success w-50">Connect</button>
                                        <button class="btn btn-outline-secondary w-50" data-bs-toggle="tooltip" title="View more information">
                                            Learn More
                                            <i class="ti ti-arrow-right ms-1"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col-->
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <span class="avatar-xl d-block mb-1">
                                            <span class="avatar-title bg-light bg-opacity-75 rounded">
                                                <img alt="Figma Logo" height="30" src="/images/logos/figma.svg" />
                                            </span>
                                        </span>
                                        <span class="badge badge-label text-bg-warning">
                                            <i class="ti ti-medal"></i>
                                            Premium
                                        </span>
                                    </div>
                                    <h5 class="card-title mb-1">Figma</h5>
                                    <p class="card-text text-muted">Figma is a collaborative interface design tool that helps teams design and prototype together in real time...</p>
                                    <div class="mb-3 d-flex align-items-center gap-1">
                                        <i class="ti ti-world"></i>
                                        <a class="link-reset" href="#!">www.figma.com</a>
                                    </div>
                                    <div class="d-flex gap-2">
                                        <button class="btn btn-success w-50">Connect</button>
                                        <button class="btn btn-outline-secondary w-50" data-bs-toggle="tooltip" title="View more information">
                                            Learn More
                                            <i class="ti ti-arrow-right ms-1"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <span class="avatar-xl d-block mb-1">
                                            <span class="avatar-title bg-light bg-opacity-75 rounded">
                                                <img alt="Microsoft Logo" height="30" src="/images/logos/microsoft.svg" />
                                            </span>
                                        </span>
                                        <span class="badge badge-label text-bg-warning">
                                            <i class="ti ti-medal"></i>
                                            Premium
                                        </span>
                                    </div>
                                    <h5 class="card-title mb-1">Microsoft</h5>
                                    <p class="card-text text-muted">Microsoft provides productivity software and cloud services including Office 365, Azure, and more...</p>
                                    <div class="mb-3 d-flex align-items-center gap-1">
                                        <i class="ti ti-world"></i>
                                        <a class="link-reset" href="#!">www.microsoft.com</a>
                                    </div>
                                    <div class="d-flex gap-2">
                                        <button class="btn btn-success w-50">Connect</button>
                                        <button class="btn btn-outline-secondary w-50" data-bs-toggle="tooltip" title="View more information">
                                            Learn More
                                            <i class="ti ti-arrow-right ms-1"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <span class="avatar-xl d-block mb-1">
                                            <span class="avatar-title bg-light bg-opacity-75 rounded">
                                                <img alt="OpenAI Logo" height="30" src="/images/logos/openai.svg" />
                                            </span>
                                        </span>
                                        <span class="badge badge-label text-bg-light">Free</span>
                                    </div>
                                    <h5 class="card-title mb-1">OpenAI</h5>
                                    <p class="card-text text-muted">OpenAI provides cutting-edge artificial intelligence APIs and tools to integrate AI into your apps...</p>
                                    <div class="mb-3 d-flex align-items-center gap-1">
                                        <i class="ti ti-world"></i>
                                        <a class="link-reset" href="#!">www.openai.com</a>
                                    </div>
                                    <div class="d-flex gap-2">
                                        <button class="btn btn-success w-50">Connect</button>
                                        <button class="btn btn-outline-secondary w-50" data-bs-toggle="tooltip" title="View more information">
                                            Learn More
                                            <i class="ti ti-arrow-right ms-1"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <span class="avatar-xl d-block mb-1">
                                            <span class="avatar-title bg-light bg-opacity-75 rounded">
                                                <img alt="Slack Logo" height="30" src="/images/logos/slack.svg" />
                                            </span>
                                        </span>
                                        <span class="badge badge-label text-bg-warning">
                                            <i class="ti ti-medal"></i>
                                            Premium
                                        </span>
                                    </div>
                                    <h5 class="card-title mb-1">Slack</h5>
                                    <p class="card-text text-muted">Slack is a messaging app for teams that connects people, information, and tools together in one place...</p>
                                    <div class="mb-3 d-flex align-items-center gap-1">
                                        <i class="ti ti-world"></i>
                                        <a class="link-reset" href="#!">www.slack.com</a>
                                    </div>
                                    <div class="d-flex gap-2">
                                        <button class="btn btn-success w-50">Connect</button>
                                        <button class="btn btn-outline-secondary w-50" data-bs-toggle="tooltip" title="View more information">
                                            Learn More
                                            <i class="ti ti-arrow-right ms-1"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <span class="avatar-xl d-block mb-1">
                                            <span class="avatar-title bg-light bg-opacity-75 rounded">
                                                <img alt="Spotify Logo" height="30" src="/images/logos/spotify.svg" />
                                            </span>
                                        </span>
                                        <span class="badge badge-label text-bg-light">Free</span>
                                    </div>
                                    <h5 class="card-title mb-1">Spotify</h5>
                                    <p class="card-text text-muted">Spotify is a digital music service that gives you access to millions of songs and podcasts...</p>
                                    <div class="mb-3 d-flex align-items-center gap-1">
                                        <i class="ti ti-world"></i>
                                        <a class="link-reset" href="#!">www.spotify.com</a>
                                    </div>
                                    <div class="d-flex gap-2">
                                        <button class="btn btn-success w-50">Connect</button>
                                        <button class="btn btn-outline-secondary w-50" data-bs-toggle="tooltip" title="View more information">
                                            Learn More
                                            <i class="ti ti-arrow-right ms-1"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <span class="avatar-xl d-block mb-1">
                                            <span class="avatar-title bg-light bg-opacity-75 rounded">
                                                <img alt="Meta Logo" height="24" src="/images/logos/meta.svg" />
                                            </span>
                                        </span>
                                        <span class="badge badge-label text-bg-warning">
                                            <i class="ti ti-medal"></i>
                                            Premium
                                        </span>
                                    </div>
                                    <h5 class="card-title mb-1">Meta</h5>
                                    <p class="card-text text-muted">Meta connects billions of people through its apps and services including Facebook, Instagram, and WhatsApp...</p>
                                    <div class="mb-3 d-flex align-items-center gap-1">
                                        <i class="ti ti-world"></i>
                                        <a class="link-reset" href="#!">www.meta.com</a>
                                    </div>
                                    <div class="d-flex gap-2">
                                        <button class="btn btn-success w-50">Connect</button>
                                        <button class="btn btn-outline-secondary w-50" data-bs-toggle="tooltip" title="View more information">
                                            Learn More
                                            <i class="ti ti-arrow-right ms-1"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <span class="avatar-xl d-block mb-1">
                                            <span class="avatar-title bg-light bg-opacity-75 rounded">
                                                <img alt="Apple Logo" height="30" src="/images/logos/apple.svg" />
                                            </span>
                                        </span>
                                        <span class="badge badge-label text-bg-light">Free</span>
                                    </div>
                                    <h5 class="card-title mb-1">Apple</h5>
                                    <p class="card-text text-muted">Apple designs and develops consumer electronics, software, and online services including iPhone...</p>
                                    <div class="mb-3 d-flex align-items-center gap-1">
                                        <i class="ti ti-world"></i>
                                        <a class="link-reset" href="#!">www.apple.com</a>
                                    </div>
                                    <div class="d-flex gap-2">
                                        <button class="btn btn-success w-50">Connect</button>
                                        <button class="btn btn-outline-secondary w-50" data-bs-toggle="tooltip" title="View more information">
                                            Learn More
                                            <i class="ti ti-arrow-right ms-1"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <span class="avatar-xl d-block mb-1">
                                            <span class="avatar-title bg-light bg-opacity-75 rounded">
                                                <img alt="Airbnb Logo" height="30" src="/images/logos/airbnb.svg" />
                                            </span>
                                        </span>
                                        <span class="badge badge-label text-bg-warning">
                                            <i class="ti ti-medal"></i>
                                            Premium
                                        </span>
                                    </div>
                                    <h5 class="card-title mb-1">Airbnb</h5>
                                    <p class="card-text text-muted">Airbnb is an online marketplace for lodging, primarily homestays for vacation rentals, and tourism activities...</p>
                                    <div class="mb-3 d-flex align-items-center gap-1">
                                        <i class="ti ti-world"></i>
                                        <a class="link-reset" href="#!">www.airbnb.com</a>
                                    </div>
                                    <div class="d-flex gap-2">
                                        <button class="btn btn-success w-50">Connect</button>
                                        <button class="btn btn-outline-secondary w-50" data-bs-toggle="tooltip" title="View more information">
                                            Learn More
                                            <i class="ti ti-arrow-right ms-1"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 mb-3">
                            <nav>
                                <ul class="pagination pagination-boxed pagination-rounded justify-content-center">
                                    <li class="page-item">
                                        <a aria-label="Previous" class="page-link" href="javascript: void(0);">
                                            <i class="ti ti-chevron-left align-middle fs-lg"></i>
                                        </a>
                                    </li>
                                    <li class="page-item">
                                        <a class="page-link" href="javascript: void(0);">1</a>
                                    </li>
                                    <li class="page-item active">
                                        <a class="page-link" href="javascript: void(0);">2</a>
                                    </li>
                                    <li class="page-item">
                                        <a class="page-link" href="javascript: void(0);">3</a>
                                    </li>
                                    <li class="page-item">
                                        <a class="page-link" href="javascript: void(0);">4</a>
                                    </li>
                                    <li class="page-item">
                                        <a class="page-link" href="javascript: void(0);">5</a>
                                    </li>
                                    <li class="page-item">
                                        <a aria-label="Next" class="page-link" href="javascript: void(0);">
                                            <i class="ti ti-chevron-right align-middle fs-lg"></i>
                                        </a>
                                    </li>
                                </ul>
                            </nav>
                        </div>
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
