<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Tasks')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Apps', 'title' => 'Tasks')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card" data-table="" data-table-rows-per-page="8">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <!-- Search -->
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search task..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Delete Selected -->
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                        <span class="me-2 fw-semibold">Filter By:</span>
                                        <!-- Task Status Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="status">
                                                <option value="All">Task Status</option>
                                                <option value="New">New</option>
                                                <option value="In Progress">In Progress</option>
                                                <option value="Completed">Completed</option>
                                                <option value="In Review">In Review</option>
                                                <option value="Cancelled">Cancelled</option>
                                            </select>
                                            <i class="ti ti-list-check app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Priority Filter -->
                                        <div class="app-search">
                                            <select class="form-select form-control my-1 my-md-0" data-table-filter="priority">
                                                <option value="All">Priority</option>
                                                <option value="High">High</option>
                                                <option value="Medium">Medium</option>
                                                <option value="Low">Low</option>
                                            </select>
                                            <i class="ti ti-alert-triangle app-search-icon text-muted"></i>
                                        </div>
                                        <!-- Records Per Page -->
                                        <div>
                                            <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                                <option value="5">5</option>
                                                <option selected="" value="10">10</option>
                                                <option value="15">15</option>
                                                <option value="20">20</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="d-flex gap-1">
                                        <a class="btn btn-primary ms-1" href="/apps-task-create">
                                            <i class="ti ti-plus fs-sm me-2"></i>
                                            Add Task
                                        </a>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-custom table-centered table-select table-hover w-100 mb-0">
                                        <thead class="bg-light align-middle bg-opacity-25 thead-sm">
                                            <tr class="text-uppercase fs-xxs">
                                                <th class="ps-3" style="width: 1%">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" data-table-select-all="" type="checkbox" />
                                                </th>
                                                <th data-table-sort="">Task Title</th>
                                                <th data-table-sort="">Assigned To</th>
                                                <th data-table-sort="">Due Date</th>
                                                <th data-table-sort="">Progress</th>
                                                <th data-column="status" data-table-sort="">Status</th>
                                                <th data-column="priority" data-table-sort="">Priority</th>
                                                <th data-table-sort="">Comments</th>
                                                <th class="text-center" style="width: 1%">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <!-- Task 1 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0">
                                                        <a class="link-reset" href="/apps-task-details">Complete Presentation Slides for Meeting</a>
                                                    </h5>
                                                    <p class="text-muted fs-xs mb-0">
                                                        Created: 9 May, 2025
                                                        <small class="text-muted">10:10 AM</small>
                                                    </p>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="Cruise ⚒️" class="img-fluid rounded-circle" src="/images/users/user-2.jpg" />
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-0 fs-base fw-semibold">Cruise ⚒️</h6>
                                                            <p class="text-muted fs-xs mb-0">+2 members</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <i class="ti ti-calendar text-muted me-1"></i>
                                                    Today
                                                </td>
                                                <td>
                                                    <i class="ti ti-list-details text-muted me-1"></i>
                                                    0/7
                                                </td>
                                                <td>
                                                    <span class="badge badge-outline-warning fs-xxs">New</span>
                                                </td>
                                                <td>
                                                    <span class="badge badge-soft-danger fs-xxs">High</span>
                                                </td>
                                                <td>
                                                    <i class="ti ti-messages text-muted fs-sm me-1"></i>
                                                    1
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="/apps-task-details">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Task 2 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0">
                                                        <a class="link-reset" href="/apps-task-details">Finalize Product Roadmap for Launch</a>
                                                    </h5>
                                                    <p class="text-muted fs-xs mb-0">
                                                        Created: 8 Oct, 2025
                                                        <small class="text-muted">2:30 PM</small>
                                                    </p>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="Maria 💻" class="img-fluid rounded-circle" src="/images/users/user-5.jpg" />
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-0 fs-base fw-semibold">Maria 💻</h6>
                                                            <p class="text-muted fs-xs mb-0">+2 members</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <i class="ti ti-calendar text-muted me-1"></i>
                                                    29 Oct, 2025
                                                </td>
                                                <td>
                                                    <i class="ti ti-list-details text-muted me-1"></i>
                                                    5/10
                                                </td>
                                                <td><span class="badge badge-outline-success fs-xxs">In Progress</span></td>
                                                <td><span class="badge badge-soft-warning fs-xxs">Medium</span></td>
                                                <td>
                                                    <i class="ti ti-messages text-muted me-1"></i>
                                                    14
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="/apps-task-details">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Task 3 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0">
                                                        <a class="link-reset" href="/apps-task-details">Design Marketing Campaign Assets</a>
                                                    </h5>
                                                    <p class="text-muted fs-xs mb-0">
                                                        Created: 6 Oct, 2025
                                                        <small class="text-muted">5:45 PM</small>
                                                    </p>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="Kevin" class="img-fluid rounded-circle" src="/images/users/user-3.jpg" />
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-0 fs-base fw-semibold">Kevin</h6>
                                                            <p class="text-muted fs-xs mb-0">+1 member</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <i class="ti ti-calendar text-muted me-1"></i>
                                                    29 Oct, 2025
                                                </td>
                                                <td>
                                                    <i class="ti ti-list-details text-muted me-1"></i>
                                                    6/8
                                                </td>
                                                <td><span class="badge badge-outline-success fs-xxs">In Progress</span></td>
                                                <td><span class="badge badge-soft-danger fs-xxs">High</span></td>
                                                <td>
                                                    <i class="ti ti-messages text-muted me-1"></i>
                                                    9
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="/apps-task-details">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Task 4 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0">
                                                        <a class="link-reset" href="/apps-task-details">Prepare Monthly Financial Report</a>
                                                    </h5>
                                                    <p class="text-muted fs-xs mb-0">
                                                        Created: 4 Oct, 2025
                                                        <small class="text-muted">11:00 AM</small>
                                                    </p>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="Thomas 🏠" class="img-fluid rounded-circle" src="/images/users/user-4.jpg" />
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-0 fs-base fw-semibold">Thomas 🏠</h6>
                                                            <p class="text-muted fs-xs mb-0">+1 member</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <i class="ti ti-calendar text-danger me-1"></i>
                                                    20 Sep, 2025
                                                </td>
                                                <td>
                                                    <i class="ti ti-list-details text-muted me-1"></i>
                                                    2/5
                                                </td>
                                                <td><span class="badge badge-outline-success fs-xxs">In Progress</span></td>
                                                <td><span class="badge badge-soft-warning fs-xxs">Medium</span></td>
                                                <td>
                                                    <i class="ti ti-messages text-muted me-1"></i>
                                                    6
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="/apps-task-details">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Task 5 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0">
                                                        <a class="link-reset" href="/apps-task-details">Conduct Team Retrospective Meeting</a>
                                                    </h5>
                                                    <p class="text-muted fs-xs mb-0">
                                                        Created: 2 Oct, 2025
                                                        <small class="text-muted">4:00 PM</small>
                                                    </p>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="James" class="img-fluid rounded-circle" src="/images/users/user-6.jpg" />
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-0 fs-base fw-semibold">James</h6>
                                                            <p class="text-muted fs-xs mb-0">Solo</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <i class="ti ti-calendar text-muted me-1"></i>
                                                    Yesterday
                                                </td>
                                                <td>
                                                    <i class="ti ti-list-details text-muted me-1"></i>
                                                    4/4
                                                </td>
                                                <td><span class="badge badge-outline-success fs-xxs">Completed</span></td>
                                                <td><span class="badge badge-soft-success fs-xxs">Low</span></td>
                                                <td>
                                                    <i class="ti ti-messages text-muted me-1"></i>
                                                    2
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="/apps-task-details">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Task 6 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0">
                                                        <a class="link-reset" href="/apps-task-details">Review UI/UX Prototype for Dashboard</a>
                                                    </h5>
                                                    <p class="text-muted fs-xs mb-0">
                                                        Created: 1 Oct, 2025
                                                        <small class="text-muted">9:45 AM</small>
                                                    </p>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="Sophia 🚀" class="img-fluid rounded-circle" src="/images/users/user-7.jpg" />
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-0 fs-base fw-semibold">Sophia 🚀</h6>
                                                            <p class="text-muted fs-xs mb-0">+3 members</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <i class="ti ti-calendar text-muted me-1"></i>
                                                    22 Oct, 2025
                                                </td>
                                                <td>
                                                    <i class="ti ti-list-details text-muted me-1"></i>
                                                    1/6
                                                </td>
                                                <td><span class="badge badge-outline-warning fs-xxs">New</span></td>
                                                <td><span class="badge badge-soft-danger fs-xxs">High</span></td>
                                                <td>
                                                    <i class="ti ti-messages text-muted me-1"></i>
                                                    11
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="/apps-task-details">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Task 7 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0">
                                                        <a class="link-reset" href="/apps-task-details">Update Documentation and API References</a>
                                                    </h5>
                                                    <p class="text-muted fs-xs mb-0">
                                                        Created: 28 Sep, 2025
                                                        <small class="text-muted">1:20 PM</small>
                                                    </p>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="Liam" class="img-fluid rounded-circle" src="/images/users/user-8.jpg" />
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-0 fs-base fw-semibold">Liam</h6>
                                                            <p class="text-muted fs-xs mb-0">+1 member</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <i class="ti ti-calendar text-danger me-1"></i>
                                                    19 Sep, 2025
                                                </td>
                                                <td>
                                                    <i class="ti ti-list-details text-muted me-1"></i>
                                                    7/8
                                                </td>
                                                <td><span class="badge badge-outline-danger fs-xxs">Cancelled</span></td>
                                                <td><span class="badge badge-soft-warning fs-xxs">Medium</span></td>
                                                <td>
                                                    <i class="ti ti-messages text-muted me-1"></i>
                                                    5
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="/apps-task-details">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#">
                                                            <i class="ti ti-edit fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                            <i class="ti ti-trash fs-lg"></i>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Task 8 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0">
                                                        <a class="link-reset" href="/apps-task-details">Implement User Authentication Module</a>
                                                    </h5>
                                                    <p class="text-muted fs-xs mb-0">
                                                        Created: 10 Oct, 2025
                                                        <small class="text-muted">9:00 AM</small>
                                                    </p>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="Olivia" class="img-fluid rounded-circle" src="/images/users/user-9.jpg" />
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-0 fs-base fw-semibold">Olivia</h6>
                                                            <p class="text-muted fs-xs mb-0">+2 members</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <i class="ti ti-calendar text-muted me-1"></i>
                                                    Tomorrow
                                                </td>
                                                <td>
                                                    <i class="ti ti-list-details text-muted me-1"></i>
                                                    3/10
                                                </td>
                                                <td><span class="badge badge-outline-warning fs-xxs">New</span></td>
                                                <td><span class="badge badge-soft-danger fs-xxs">High</span></td>
                                                <td>
                                                    <i class="ti ti-messages text-muted me-1"></i>
                                                    8
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="/apps-task-details">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Task 9 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0">
                                                        <a class="link-reset" href="/apps-task-details">Write Test Cases for API Endpoints</a>
                                                    </h5>
                                                    <p class="text-muted fs-xs mb-0">
                                                        Created: 9 Oct, 2025
                                                        <small class="text-muted">10:45 AM</small>
                                                    </p>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="Ethan" class="img-fluid rounded-circle" src="/images/users/user-10.jpg" />
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-0 fs-base fw-semibold">Ethan</h6>
                                                            <p class="text-muted fs-xs mb-0">Solo</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <i class="ti ti-calendar text-muted me-1"></i>
                                                    12 Nov, 2025
                                                </td>
                                                <td>
                                                    <i class="ti ti-list-details text-muted me-1"></i>
                                                    1/8
                                                </td>
                                                <td><span class="badge badge-outline-warning fs-xxs">In Review</span></td>
                                                <td><span class="badge badge-soft-warning fs-xxs">Medium</span></td>
                                                <td>
                                                    <i class="ti ti-messages text-muted me-1"></i>
                                                    3
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="/apps-task-details">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Task 10 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0">
                                                        <a class="link-reset" href="/apps-task-details">Migrate Legacy Data to New Database</a>
                                                    </h5>
                                                    <p class="text-muted fs-xs mb-0">
                                                        Created: 5 Oct, 2025
                                                        <small class="text-muted">8:00 PM</small>
                                                    </p>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="Charlotte" class="img-fluid rounded-circle" src="/images/users/user-4.jpg" />
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-0 fs-base fw-semibold">Charlotte</h6>
                                                            <p class="text-muted fs-xs mb-0">+1 member</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <i class="ti ti-calendar text-muted me-1"></i>
                                                    Next Week
                                                </td>
                                                <td>
                                                    <i class="ti ti-list-details text-muted me-1"></i>
                                                    2/12
                                                </td>
                                                <td><span class="badge badge-outline-success fs-xxs">In Progress</span></td>
                                                <td><span class="badge badge-soft-warning fs-xxs">Medium</span></td>
                                                <td>
                                                    <i class="ti ti-messages text-muted me-1"></i>
                                                    10
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="/apps-task-details">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Task 11 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0">
                                                        <a class="link-reset" href="/apps-task-details">QA Review and Regression Testing</a>
                                                    </h5>
                                                    <p class="text-muted fs-xs mb-0">
                                                        Created: 3 Oct, 2025
                                                        <small class="text-muted">3:10 PM</small>
                                                    </p>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="Grace" class="img-fluid rounded-circle" src="/images/users/user-2.jpg" />
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-0 fs-base fw-semibold">Grace</h6>
                                                            <p class="text-muted fs-xs mb-0">QA Team</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <i class="ti ti-calendar text-danger me-1"></i>
                                                    12 Sep, 2025
                                                </td>
                                                <td>
                                                    <i class="ti ti-list-details text-muted me-1"></i>
                                                    9/10
                                                </td>
                                                <td><span class="badge badge-outline-danger fs-xxs">Cancelled</span></td>
                                                <td><span class="badge badge-soft-danger fs-xxs">High</span></td>
                                                <td>
                                                    <i class="ti ti-messages text-muted me-1"></i>
                                                    17
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="/apps-task-details">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                            <!-- Task 12 -->
                                            <tr>
                                                <td class="ps-3">
                                                    <input class="form-check-input form-check-input-light fs-14 mt-0" type="checkbox" />
                                                </td>
                                                <td>
                                                    <h5 class="fs-base mb-0">
                                                        <a class="link-reset" href="/apps-task-details">Optimize Application Performance Metrics</a>
                                                    </h5>
                                                    <p class="text-muted fs-xs mb-0">
                                                        Created: 1 Oct, 2025
                                                        <small class="text-muted">12:05 PM</small>
                                                    </p>
                                                </td>
                                                <td>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <div class="avatar avatar-sm">
                                                            <img alt="Noah" class="img-fluid rounded-circle" src="/images/users/user-6.jpg" />
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-0 fs-base fw-semibold">Noah</h6>
                                                            <p class="text-muted fs-xs mb-0">DevOps</p>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td>
                                                    <i class="ti ti-calendar text-muted me-1"></i>
                                                    18 Oct, 2025
                                                </td>
                                                <td>
                                                    <i class="ti ti-list-details text-muted me-1"></i>
                                                    2/7
                                                </td>
                                                <td><span class="badge badge-outline-success fs-xxs">In Progress</span></td>
                                                <td><span class="badge badge-soft-warning fs-xxs">Medium</span></td>
                                                <td>
                                                    <i class="ti ti-messages text-muted me-1"></i>
                                                    6
                                                </td>
                                                <td>
                                                    <div class="d-flex justify-content-center gap-1">
                                                        <a class="btn btn-default btn-icon btn-sm" href="/apps-task-details">
                                                            <i class="ti ti-eye fs-lg"></i>
                                                        </a>
                                                        <a class="btn btn-default btn-icon btn-sm" href="#"><i class="ti ti-edit fs-lg"></i></a>
                                                        <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#"><i class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="tasks"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
