<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'User Permissions')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Users', 'title' => 'Permissions')) ?>

                    <div class="row">
                        <div class="col-xxl-12">
                            <div class="card" data-table="" data-table-rows-per-page="8">
                                <div class="card-header border-light justify-content-between">
                                    <div class="d-flex gap-2">
                                        <div class="app-search">
                                            <input class="form-control" data-table-search="" placeholder="Search permissions..." type="search" />
                                            <i class="ti ti-search app-search-icon text-muted"></i>
                                        </div>
                                        <button class="btn btn-danger d-none" data-table-delete-selected="">Delete</button>
                                    </div>
                                    <!-- Records Per Page -->
                                    <div>
                                        <select class="form-select form-control my-1 my-md-0" data-table-set-rows-per-page="">
                                            <option value="5">5</option>
                                            <option value="10">10</option>
                                            <option value="15">15</option>
                                            <option value="20">20</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="table table-custom table-centered table-select table-hover w-100 mb-0">
                                        <thead class="bg-light align-middle bg-opacity-25 thead-sm">
                                            <tr class="text-uppercase fs-xxs">
                                                <th data-table-sort="">Name</th>
                                                <th>Assign To</th>
                                                <th data-table-sort="">Created Date</th>
                                                <th data-table-sort="">Users</th>
                                                <th class="text-center">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td>User Management</td>
                                                <td>
                                                    <span class="badge bg-primary-subtle text-primary badge-label fs-xxs fw-semibold">Administrator</span>
                                                </td>
                                                <td>
                                                    24 Jun 2025,
                                                    <span class="text-muted">6:43 am</span>
                                                </td>
                                                <td>12</td>
                                                <td class="text-center">
                                                    <a class="btn btn-default btn-icon btn-sm" href="#">
                                                        <i class="ti ti-eye fs-lg"></i>
                                                    </a>
                                                    <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                        <i class="ti ti-trash fs-lg"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Content Management</td>
                                                <td>
                                                    <span class="badge bg-primary-subtle text-primary badge-label fs-xxs fw-semibold">Administrator</span>
                                                    <span class="badge bg-danger-subtle text-danger badge-label fs-xxs fw-semibold">Developer</span>
                                                    <span class="badge bg-info-subtle text-info badge-label fs-xxs fw-semibold">Analyst</span>
                                                    <span class="badge bg-secondary-subtle text-secondary badge-label fs-xxs fw-semibold">Support</span>
                                                    <span class="badge bg-warning-subtle text-warning badge-label fs-xxs fw-semibold">Trial</span>
                                                </td>
                                                <td>
                                                    21 Feb 2025,
                                                    <span class="text-muted">11:05 am</span>
                                                </td>
                                                <td>5</td>
                                                <td class="text-center">
                                                    <a class="btn btn-default btn-icon btn-sm" href="#">
                                                        <i class="ti ti-eye fs-lg"></i>
                                                    </a>
                                                    <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                        <i class="ti ti-trash fs-lg"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Financial Management</td>
                                                <td>
                                                    <span class="badge bg-primary-subtle text-primary badge-label fs-xxs fw-semibold">Administrator</span>
                                                    <span class="badge bg-info-subtle text-info badge-label fs-xxs fw-semibold">Analyst</span>
                                                </td>
                                                <td>
                                                    24 Jun 2025,
                                                    <span class="text-muted">5:30 pm</span>
                                                </td>
                                                <td>8</td>
                                                <td class="text-center">
                                                    <a class="btn btn-default btn-icon btn-sm" href="#">
                                                        <i class="ti ti-eye fs-lg"></i>
                                                    </a>
                                                    <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                        <i class="ti ti-trash fs-lg"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Reporting</td>
                                                <td>
                                                    <span class="badge bg-primary-subtle text-primary badge-label fs-xxs fw-semibold">Administrator</span>
                                                    <span class="badge bg-info-subtle text-info badge-label fs-xxs fw-semibold">Analyst</span>
                                                </td>
                                                <td>
                                                    21 Feb 2025,
                                                    <span class="text-muted">5:20 pm</span>
                                                </td>
                                                <td>6</td>
                                                <td class="text-center">
                                                    <a class="btn btn-default btn-icon btn-sm" href="#">
                                                        <i class="ti ti-eye fs-lg"></i>
                                                    </a>
                                                    <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                        <i class="ti ti-trash fs-lg"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Payroll</td>
                                                <td>
                                                    <span class="badge bg-primary-subtle text-primary badge-label fs-xxs fw-semibold">Administrator</span>
                                                    <span class="badge bg-info-subtle text-info badge-label fs-xxs fw-semibold">Analyst</span>
                                                </td>
                                                <td>
                                                    20 Jun 2025,
                                                    <span class="text-muted">6:05 pm</span>
                                                </td>
                                                <td>4</td>
                                                <td class="text-center">
                                                    <a class="btn btn-default btn-icon btn-sm" href="#">
                                                        <i class="ti ti-eye fs-lg"></i>
                                                    </a>
                                                    <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                        <i class="ti ti-trash fs-lg"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Disputes Management</td>
                                                <td>
                                                    <span class="badge bg-primary-subtle text-primary badge-label fs-xxs fw-semibold">Administrator</span>
                                                    <span class="badge bg-danger-subtle text-danger badge-label fs-xxs fw-semibold">Developer</span>
                                                    <span class="badge bg-secondary-subtle text-secondary badge-label fs-xxs fw-semibold">Support</span>
                                                </td>
                                                <td>
                                                    24 Jun 2025,
                                                    <span class="text-muted">5:20 pm</span>
                                                </td>
                                                <td>7</td>
                                                <td class="text-center">
                                                    <a class="btn btn-default btn-icon btn-sm" href="#">
                                                        <i class="ti ti-eye fs-lg"></i>
                                                    </a>
                                                    <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                        <i class="ti ti-trash fs-lg"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Audit Logs</td>
                                                <td>
                                                    <span class="badge bg-primary-subtle text-primary badge-label fs-xxs fw-semibold">Administrator</span>
                                                </td>
                                                <td>
                                                    23 Jun 2025,
                                                    <span class="text-muted">4:00 pm</span>
                                                </td>
                                                <td>9</td>
                                                <td class="text-center">
                                                    <a class="btn btn-default btn-icon btn-sm" href="#">
                                                        <i class="ti ti-eye fs-lg"></i>
                                                    </a>
                                                    <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                        <i class="ti ti-trash fs-lg"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>API Access</td>
                                                <td>
                                                    <span class="badge bg-primary-subtle text-primary badge-label fs-xxs fw-semibold">Administrator</span>
                                                    <span class="badge bg-warning-subtle text-warning badge-label fs-xxs fw-semibold">Trial</span>
                                                    <span class="badge bg-info-subtle text-info badge-label fs-xxs fw-semibold">DevOps</span>
                                                </td>
                                                <td>
                                                    22 Jun 2025,
                                                    <span class="text-muted">2:35 pm</span>
                                                </td>
                                                <td>3</td>
                                                <td class="text-center">
                                                    <a class="btn btn-default btn-icon btn-sm" href="#">
                                                        <i class="ti ti-eye fs-lg"></i>
                                                    </a>
                                                    <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                        <i class="ti ti-trash fs-lg"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Notification Center</td>
                                                <td>
                                                    <span class="badge bg-primary-subtle text-primary badge-label fs-xxs fw-semibold">Administrator</span>
                                                    <span class="badge bg-info-subtle text-info badge-label fs-xxs fw-semibold">Support</span>
                                                </td>
                                                <td>
                                                    22 Jun 2025,
                                                    <span class="text-muted">8:45 am</span>
                                                </td>
                                                <td>2</td>
                                                <td class="text-center">
                                                    <a class="btn btn-default btn-icon btn-sm" href="#">
                                                        <i class="ti ti-eye fs-lg"></i>
                                                    </a>
                                                    <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                        <i class="ti ti-trash fs-lg"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>Access Logs</td>
                                                <td>
                                                    <span class="badge bg-primary-subtle text-primary badge-label fs-xxs fw-semibold">Administrator</span>
                                                    <span class="badge bg-secondary-subtle text-secondary badge-label fs-xxs fw-semibold">Support</span>
                                                </td>
                                                <td>
                                                    19 Jun 2025,
                                                    <span class="text-muted">6:10 pm</span>
                                                </td>
                                                <td>5</td>
                                                <td class="text-center">
                                                    <a class="btn btn-default btn-icon btn-sm" href="#">
                                                        <i class="ti ti-eye fs-lg"></i>
                                                    </a>
                                                    <a class="btn btn-default btn-icon btn-sm" data-table-delete-row="" href="#">
                                                        <i class="ti ti-trash fs-lg"></i>
                                                    </a>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="card-footer border-0">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div data-table-pagination-info="permissions"></div>
                                        <div data-table-pagination=""></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Custom table -->
        <script src="/js/pages/custom-table.js"></script>
    </body>
</html>
