<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Two Factor Authentication')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <div class="position-absolute top-0 end-0">
            <img alt="auth-card-bg" class="auth-card-bg-img" src="/images/auth-card-bg.svg" />
        </div>
        <div class="position-absolute bottom-0 start-0" style="transform: rotate(180deg)">
            <img alt="auth-card-bg" class="auth-card-bg-img" src="/images/auth-card-bg.svg" />
        </div>
        <div class="auth-box overflow-hidden align-items-center d-flex">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xxl-5 col-md-6 col-sm-8">
                        <div class="card p-4">
                            <div class="auth-brand text-center mb-3">
                                <a class="logo-dark" href="/">
                                    <img alt="dark logo" src="/images/logo-black.png" />
                                </a>
                                <a class="logo-light" href="/">
                                    <img alt="logo" src="/images/logo.png" />
                                </a>
                                <p class="text-muted w-lg-75 mt-3 mx-auto">We've emailed you a 6-digit verification code we sent to</p>
                            </div>
                            <div class="text-center mb-4">
                                <div class="fw-bold fs-3">******6789</div>
                            </div>
                            <form>
                                <label class="form-label">
                                    Enter your 6-digit code
                                    <span class="text-danger">*</span>
                                </label>
                                <div class="d-flex gap-2 mb-3 two-factor">
                                    <input class="form-control text-center" required="" type="text" />
                                    <input class="form-control text-center" required="" type="text" />
                                    <input class="form-control text-center" required="" type="text" />
                                    <input class="form-control text-center" required="" type="text" />
                                    <input class="form-control text-center" required="" type="text" />
                                    <input class="form-control text-center" required="" type="text" />
                                </div>
                                <div class="d-grid">
                                    <button class="btn btn-primary fw-semibold py-2" type="submit">Confirm</button>
                                </div>
                            </form>
                            <p class="mt-4 text-muted text-center mb-4">
                                Don’t have a code?
                                <a class="text-decoration-underline link-offset-2 fw-semibold" href="#">Resend</a>
                                or
                                <a class="text-decoration-underline link-offset-2 fw-semibold" href="#">Call Us</a>
                            </p>
                            <p class="text-muted text-center mb-0">
                                Return to
                                <a class="text-decoration-underline link-offset-3 fw-semibold" href="/auth-sign-in">Sign in</a>
                            </p>
                        </div>
                        <p class="text-center text-muted mt-4 mb-0">
                            ©
                            <script>
                                document.write(new Date().getFullYear())
                            </script>
                            Paces — by
                            <span class="fw-semibold">Coderthemes</span>
                        </p>
                    </div>
                </div>
            </div>
        </div>
        <!-- end auth-fluid-->

        <?= $this->include('partials/footer-scripts') ?>

        <!-- Two Factor Validator Js -->
        <script src="/js/pages/auth-two-factor.js"></script>
    </body>
</html>
