<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Area Charts')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Charts', 'title' => 'Area Charts')) ?>

                    <div class="row">
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Basic Area</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="basic-area-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Different Dataset</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="different-dataset-area-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Stacked</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="stacked-area-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Boundaries</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="boundaries-area-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Draw Time</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="draw-time-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- ChartJs Plugin Js -->
        <script src="/plugins/chartjs/chart.umd.js"></script>
        <!-- Area chart Demo js -->
        <script src="/js/pages/chartjs-area.js"></script>
    </body>
</html>
