<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Line Charts')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Charts', 'title' => 'Line Charts')) ?>

                    <div class="row">
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Basic Line</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="basic-line-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Interpolation</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="interpolation-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Multi-Axes</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="multi-axes-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Point Styling</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="point-styling-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Line Segment</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="line-segment-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Stepped</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="stepped-line-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- ChartJs Plugin Js -->
        <script src="/plugins/chartjs/chart.umd.js"></script>
        <!-- Area chart Demo js -->
        <script src="/js/pages/chartjs-line.js"></script>
    </body>
</html>
