<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Other Charts')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Charts', 'title' => 'Other Charts')) ?>

                    <div class="row">
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Bubble</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="bubble-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Combo Bar &amp; Line</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="combo-bar-line-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Stacked Bar &amp; Line</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="stacked-bar-line-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Doughnut</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="doughnut-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Multi Series Pie</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="multi-pie-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Pie</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="pie-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Polar Area</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="polar-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Radar</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="radar-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                        <div class="col-xl-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Scatter</h5>
                                </div>
                                <div class="card-body">
                                    <div dir="ltr">
                                        <div class="mt-3" style="height: 300px">
                                            <canvas id="scatter-chart"></canvas>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- ChartJs Plugin Js -->
        <script src="/plugins/chartjs/chart.umd.js"></script>
        <!-- Area chart Demo js -->
        <script src="/js/pages/chartjs-other.js"></script>
    </body>
</html>
