<?= $this->extend('app') ?>

<?= $this->section('styles') ?>


<?= $this->endSection() ?>

<?= $this->section('content') ?>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title mb-0">1.- Buscar venta</h4>
            </div>
            <div class="card-body">
                <form id="newPaymentForm">
                <div class="row g-3">
                    <!-- client Name -->
                    <div class="col-md-6">
                        <label class="form-label">Cliente <small>(Si no existe, registrar al cliente primero en la sección Clientes)</small></label>
                        <input class="form-control"
                               id="clientName"
                               placeholder="Mason Carter"
                               required=""
                               type="text" />
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Seleccionar venta</label>
                        <select class="form-select" id="saleSelector" name="sale" required="">
                        </select>
                    </div>
                </div>
            </div>
            <div class="card-header">
                <h4 class="card-title mb-0">2.- Registrar un pago</h4>
            </div>
            <div class="card-body">
                    <div class="row g-3">
                        <!-- Payment Date -->
                        <div class="col-md-4">
                            <label class="form-label">Fecha del pago</label>
                            <input class="form-control flatpickr-input"
                                   data-altformat="F j, Y"
                                   data-provider="flatpickr"
                                   id="paymentDate"
                                   name="payment_date"
                                   required=""
                                   type="datetime-local" />
                        </div>
                        <!-- Amount -->
                        <div class="col-md-4">
                            <label class="form-label">Monto <small>(No usar comas ni signos)</small></label>
                            <input class="form-control"
                                   id="amount"
                                   name="amount"
                                   placeholder="135000"
                                   required=""
                                   step="100.0"
                                   type="number" />
                        </div>
                        <!-- Payment Method -->
                        <div class="col-md-4">
                            <label class="form-label">Método de pago</label>
                            <select class="form-select" id="paymentMethod" name="payment_method" required="">
                                <option value="Cash" selected>Efectivo</option>
                                <option value="Transfer">Transferencia</option>
                                <option value="Deposit">Deposito</option>
                            </select>
                        </div>

                        <!-- Action Buttons -->
                        <div class="col-12 text-center">
                            <button class="btn btn-light me-2" data-bs-dismiss="modal" type="button">Cancelar</button>
                            <button class="btn btn-primary" type="submit">Guardar</button>
                        </div>
                    </div>
                    <!-- end row -->

                    <input type="hidden" id="clientID" name="client" value="">
                    <input type="hidden" name="created_by" value="<?=auth()->user()->id?>">
                </form>
            </div>
            <!-- end card-body-->
        </div>
        <!-- end card-->
    </div>
    <!-- end col-->
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
    <script src="/plugins/datatables/dataTables.min.js"></script>
    <script src="/plugins/datatables/dataTables.bootstrap5.min.js"></script>
    <script src="/plugins/datatables/dataTables.responsive.min.js"></script>
    <script src="/plugins/datatables/responsive.bootstrap5.min.js"></script>
    <script>
        console.log('Payments script loaded!');
        const clients = <?= json_encode($clients, JSON_UNESCAPED_UNICODE) ?>;

        $(function(){
            $('#clientName').autocomplete({
                minLength: 2,
                source: clients.map(c => ({
                    label: c.name + ' ' + c.last_name,
                    value: c.name + ' ' + c.last_name,
                    id: c.id,
                    email: c.email
                })),
                select: function (event, ui) {
                    $('#clientID').val(ui.item.id);
                    showToast('info', 'Buscando ventas del cliente');
                    getSalesUser(ui.item.id);
                }
            });


            // Payment form
            $("#newPaymentForm").on("submit",function(e){
                e.preventDefault();
                const amount = parseFloat($('#amount').val()) || 0;
                let paymentData = $(this).serializeArray();
                console.log(paymentData);
                $.ajax({
                    method: "POST",
                    url: "/payment",
                    dataType: "JSON",
                    data: paymentData,
                    success: function(response){
                        showToast('success', 'Pago registrado');
                        $('#newPaymentForm')[0].reset();
                        location.href = '/venta/'+response.sale;
                    },
                    error: function(error){
                        showToast('danger', 'Ups, algo falló. Intentalo de nuevo');
                    }
                }).done(function(){});
            });
        });

        function getSalesUser(id){
            console.log(id)
              $.ajax({
                method: 'GET',
                url: `/sale/user/${id}`,
                dataType: 'JSON'
                }).done(function(response){
                    $('#saleSelector').empty();
                    $('#saleSelector').append('<option value="">Seleccione una venta</option>');

                    response.forEach(function(sale) {
                        $('#saleSelector').append(
                            `<option value="${sale.id}">Venta #L${sale.lot}M${sale.block}</option>`
                        );
                    });
                })
        }



    </script>
<?= $this->endSection() ?>
