<?= $this->extend('app') ?>

<?= $this->section('styles') ?>


<?= $this->endSection() ?>

<?= $this->section('content') ?>

    <div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header justify-content-between">
                <h4 class="card-title">Relación de pagos</h4>
            </div>
            <div class="card-body">
                <table class="table table-striped dt-responsive align-middle mb-0" id="datatables-ajax">
                    <thead class="thead-sm text-uppercase fs-xxs">
                    <tr>
                        <th>Fecha</th>
                        <th># Venta</th>
                        <th>Monto</th>
                        <th>Método</th>
                        <th>Recibió</th>
                        <th>Acciones</th>
                    </tr>
                    </thead>
                </table>
            </div>
            <!-- end card-body-->
        </div>
        <!-- end card-->
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
    <script src="/plugins/datatables/dataTables.min.js"></script>
    <script src="/plugins/datatables/dataTables.bootstrap5.min.js"></script>
    <script src="/plugins/datatables/dataTables.responsive.min.js"></script>
    <script src="/plugins/datatables/responsive.bootstrap5.min.js"></script>
    <script>
        console.log('All payments script loaded!');
        var tableElement = document.getElementById("datatables-ajax"), dt_table;
        $(function(){

            //Payments table
            if (tableElement) {
                dt_table = new DataTable(tableElement, {
                    ajax: {
                        url: '/payment',
                        dataSrc: ""
                    },
                    processing: true,
                    order: [[0, "desc"]],
                    columns: [
                        { data: "payment_date" },
                        { data: "sale" },
                        { data: "amount" },
                        { data: "payment_method" },
                        { data: "created_by" },
                        { data: "id", render: function (data, type, full){
                                return `
                                        <a class="btn btn-light btn-icon btn-sm rounded-circle"
                                            href="/venta/${full.sale}">
                                            <i class="ti ti-receipt fs-lg"></i>
                                        </a>
                                    </div>
                                `;
                            }
                        }
                    ],
                    language: {
                        paginate: {
                            first: '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M11 7l-5 5l5 5" /><path d="M17 7l-5 5l5 5" /></svg>',
                            previous:
                                '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M15 6l-6 6l6 6" /></svg>',
                            next: '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 6l6 6l-6 6" /></svg>',
                            last: '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 7l5 5l-5 5" /><path d="M13 7l5 5l-5 5" /></svg>',
                        },
                        lengthMenu: "_MENU_ clientes por página",
                        info: 'Mostrando <span class="fw-semibold">_START_</span> a <span class="fw-semibold">_END_</span> de <span class="fw-semibold">_TOTAL_</span> clientes',
                    },
                })
            }
        });




    </script>
<?= $this->endSection() ?>
