<?= $this->extend('app') ?>

<?= $this->section('styles') ?>


<?= $this->endSection() ?>

<?= $this->section('content') ?>

        <div class="row">
            <div class="col-xxl-12">
                <div class="row">
                    <!-- Project Main Details -->
                    <div class="col-xl-9">
                            <div class="card">
                                <div class="card-header align-items-start p-4">
                                    <div>
                                        <h3 class="mb-1 d-flex align-items-center">Venta #L<?=$sale->lot?>M<?=$sale->block?></h3>
                                        <p class="text-muted mb-3">
                                            <i class="ti ti-calendar"></i>
                                            <?=$sale->order_date?> |
                                            <small class="text-muted">Vendido por: <?=$sale->created_by_name?></small>
                                        </p>
                                        <span class="badge badge-soft-info fs-xxs badge-label">
                                            <i class="ti ti-circle-filled fs-sm align-middle"></i>
                                            <?=$sale->order_status?>
                                        </span>
                                        <span class="badge badge-soft-info fs-xxs badge-label">
                                            <i class="ti ti-circle-filled fs-sm align-middle"></i>
                                            <?=$sale->sale_type?>
                                        </span>
                                    </div>
                                    <div class="ms-auto">
                                        <a class="btn btn-light" onclick="wip()" ">
                                            <i class="ti ti-pencil me-1"></i>
                                            Modificar
                                        </a>
                                    </div>
                                </div>
                                <div class="p-2">
                                    <h4 class="px-3 mb-0">Movimientos</h4>
                                    <div class="col-lg-12 ">
                                        <div class="card card-h-100">
                                            <div class="card-body">
                                                <div class="d-flex justify-content-between align-items-start flex-wrap">
                                                    <div>
                                                        <div class="d-flex align-items-center gap-2 mb-2 py-1">
                                                            <div class="avatar-md flex-shrink-0">
                                                                <span class="avatar-title text-bg-success rounded-circle">
                                                                    <i class="ti ti-moneybag fs-xxl"></i>
                                                                </span>
                                                            </div>
                                                            <h3 class="mb-0">
                                                                <?php
                                                                    $formatter = new NumberFormatter('es_MX', NumberFormatter::CURRENCY);
                                                                    $percentage = round(($totalPayments / $sale->amount) * 100, 2);
                                                                ?>
                                                                <span data-target=""><?=$formatter->formatCurrency($sale->amount, 'MXN');?></span>
                                                                MN
                                                            </h3>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="d-flex justify-content-between gap-1">
                                                    <div style="width: <?=$percentage?>%">
                                                        <p class="mb-1 mt-2 text-muted text-uppercase fs-13 fw-medium">Pagado</p>
                                                        <h3 class="fw-normal mb-2 fs-xl"><?=$percentage?>%</h3>
                                                        <div class="progress progress-lg rounded-0 rounded-start mb-1">
                                                            <div aria-valuenow="100" class="progress-bar bg-success" role="progressbar" style="width: 100%"></div>
                                                        </div>
                                                        <p class="text-muted mb-0"><?=$formatter->formatCurrency($totalPayments,'MXN');?></p>
                                                    </div>
                                                    <div style="width: <?=100 - $percentage?>%">
                                                        <p class="mb-1 mt-2 text-muted text-uppercase fs-13 fw-medium">Pendiente</p>
                                                        <h3 class="fw-normal mb-2 fs-xl"><?=100 - $percentage?>%</h3>
                                                        <div class="progress progress-lg rounded-0 rounded-end mb-1">
                                                            <div aria-valuenow="100" class="progress-bar bg-warning" role="progressbar" style="width: 100%"></div>
                                                        </div>
                                                        <p class="text-muted mb-0"><?=$formatter->formatCurrency($sale->amount - $totalPayments,'MXN');?></p>
                                                    </div>
                                                </div>
                                                <div class="table-responsive mb-n2 mt-3">
                                                    <table class="table table-sm table-nowrap table-borderless table-centered mb-0">
                                                        <thead class="bg-light bg-opacity-50 thead-sm">
                                                        <tr class="text-uppercase fs-xxs">
                                                            <th>Fecha</th>
                                                            <th>Monto</th>
                                                            <th>Método</th>
                                                            <th>Recibió</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php foreach($payments as $payment): ?>
                                                                <tr>
                                                                    <td><?=$payment->payment_date?></td>
                                                                    <td><?=$formatter->formatCurrency($payment->amount,'MXN');?></td>
                                                                    <td><?=$payment->payment_method?></td>
                                                                    <td><?=$payment->created_by_name?></td>
                                                                </tr>
                                                            <?php endforeach; ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                            <!-- end card-body-->
                                        </div>
                                        <!-- end card-->
                                    </div>
                                </div>
                                <!-- end card-body -->
                            </div>
                        <!-- end card -->
                    </div>
                    <!-- end col-xl-9 -->
                    <!-- Sidebar -->
                    <div class="col-xl-3">
                        <div class="card">
                            <div class="card-header justify-content-between border-dashed">
                                <h4 class="card-title">Detalles del cliente</h4>
                                <a class="btn btn-default btn-sm btn-icon rounded-circle" onclick="showToast('info', 'El lunes sin falta carnal')">
                                    <i class="ti ti-pencil fs-lg"></i>
                                </a>
                            </div>
                            <!-- end card-header-->
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-4">
                                    <div>
                                        <h5 class="mb-1 d-flex align-items-center">
                                            <a class="link-reset" href="javascript:void(0)"><?=$client->name?> <?=$client->last_name?></a>
                                        </h5>
                                        <?php
                                            $date = new DateTime($client->created_at);

                                            $formatter = new IntlDateFormatter(
                                                'es_ES',
                                                IntlDateFormatter::NONE,
                                                IntlDateFormatter::NONE,
                                                null,
                                                null,
                                                "MMMM 'del' yyyy"
                                            );
                                        ?>
                                        <p class="text-muted mb-0">Registrado en <?=ucfirst($formatter->format($date))?></p>
                                    </div>
                                </div>
                                <ul class="list-unstyled text-muted mb-0">
                                    <li class="mb-2">
                                        <div class="d-flex align-items-center gap-2">
                                            <div class="avatar-xs avatar-img-size fs-24">
                                                <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                    <i class="ti ti-mail"></i>
                                                </span>
                                            </div>
                                            <h5 class="fs-base mb-0 fw-medium">
                                                <a class="link-reset" href="mailto:<?=$client->email?>"><?=$client->email?></a>
                                            </h5>
                                        </div>
                                    </li>
                                    <li class="mb-2">
                                        <div class="d-flex align-items-center gap-2">
                                            <div class="avatar-xs avatar-img-size fs-24">
                                                <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                    <i class="ti ti-phone"></i>
                                                </span>
                                            </div>
                                            <h5 class="fs-base mb-0 fw-medium"><a class="link-reset" href="tel:<?=$client->phone?>"><?=$client->phone?></a></h5>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                            <!-- end card-body-->
                        </div>
                        <!-- end card-->
                    </div>
                    <!-- end col-xl-3 -->
                </div>
                <!-- end row -->
            </div>
            <!-- end col-xxl-10 -->
        </div>

<?= $this->include('modals/editClient')?>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
    <script>
        <?php
        $formatter = new NumberFormatter('es_MX', NumberFormatter::CURRENCY);
        ?>
        console.log('ClientDetail script loaded!');
        $(function(){
            setupEditClientInputs();

        });

        function setupEditClientInputs() {
            const inputs = document.querySelectorAll('.editClientInput');
            let clientID = $('#idClientEdit').val();
            inputs.forEach(input => {
                input.addEventListener('change', function() {
                    const inputName = this.name || this.id;
                    const inputValue = this.value;

                    const data = {
                        [inputName]: inputValue
                    };

                    editThing(clientID, data, '/client')
                });
            });
        }

    </script>
<?= $this->endSection() ?>
