<?= $this->extend('app') ?>

<?= $this->section('styles') ?>


<?= $this->endSection() ?>

<?= $this->section('content') ?>

    <div class="row row-cols-xxl-3 row-cols-md-3 row-cols-1 align-items-center g-1">
        <div class="col">
            <div class="card mb-1">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-2 mb-3">
                        <h3 class="mb-0">
                            <span><?=count($sales)?></span>
                        </h3>
                        <div class="avatar-md flex-shrink-0">
                            <span class="avatar-title text-bg-primary rounded-circle fs-22">
                                <i class="ti ti-list"></i>
                            </span>
                        </div>
                    </div>
                    <p class="mb-0 text-uppercase fs-xs fw-bold">
                        Ventas totales
                    </p>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card mb-1">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-2 mb-3">
                        <?php
                        $pendingCount = count(array_filter($sales, function ($order) {
                            return $order->order_status === 'Processing';
                        }));
                        ?>
                        <h3 class="mb-0"><?=$pendingCount?></h3>
                        <div class="avatar-md flex-shrink-0">
                            <span class="avatar-title text-bg-warning rounded-circle fs-22">
                                <i class="ti ti-hourglass"></i>
                            </span>
                        </div>
                    </div>
                    <p class="mb-0 text-uppercase fs-xs fw-bold">
                        Ventas en proceso
                    </p>
                </div>
            </div>
        </div>
        <div class="col">
            <div class="card mb-1">
                <div class="card-body">
                    <div class="d-flex align-items-center justify-content-between gap-2 mb-3">
                        <?php
                        $deliveredCount = count(array_filter($sales, function ($order) {
                            return $order->order_status === 'Delivered';
                        }));
                        ?>
                        <h3 class="mb-0"><?=$deliveredCount?></h3>
                        <div class="avatar-md flex-shrink-0">
                            <span class="avatar-title text-bg-success rounded-circle fs-22">
                                <i class="ti ti-check"></i>
                            </span>
                        </div>
                    </div>
                    <p class="mb-0 text-uppercase fs-xs fw-bold">
                        Ventas completadas
                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- end row -->


<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header justify-content-between">
                <h4 class="card-title">Relación de ventas</h4>
            </div>
            <div class="card-body">
                <table class="table table-striped dt-responsive align-middle mb-0" id="sales-table">
                    <thead class="thead-sm text-uppercase fs-xxs">
                    <tr>
                        <th># Venta</th>
                        <th>Fecha</th>
                        <th>Nombre(s)</th>
                        <th>Apellidos</th>
                        <th>Lote</th>
                        <th>Monto</th>
                        <th>Anticipo</th>
                        <th>Pendiente</th>
                        <th>Situación</th>
                        <th>Acciones</th>
                    </tr>
                    </thead>
                </table>
            </div>
            <!-- end card-body-->
        </div>
        <!-- end card-->
    </div>
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
    <script src="/plugins/datatables/dataTables.min.js"></script>
    <script src="/plugins/datatables/dataTables.bootstrap5.min.js"></script>
    <script src="/plugins/datatables/dataTables.responsive.min.js"></script>
    <script src="/plugins/datatables/responsive.bootstrap5.min.js"></script>
    <script>
        console.log('Sales script loaded!');
        var tableElement = document.getElementById("sales-table"), dt_table;
        <?php
            $formatter = new NumberFormatter('es_MX', NumberFormatter::CURRENCY);
        ?>
        $(function(){
            if (tableElement) {
                  $.ajax({
                        method: 'get',
                        url: '/sale',
                        dataType: 'JSON'
                        }).done(function(response){
                        console.log(response);
                    })
                dt_table = new DataTable(tableElement, {
                    ajax: {
                        url: '/sale',
                        dataSrc: ""
                    },
                    processing: true,
                    order: [[0, "desc"]],
                    columns: [
                        { data: "id" },
                        { data: "order_date" },
                        { data: "name" },
                        { data: "last_name" },
                        { data: "lot", render: function (data, type, full){
                            return `
                                L${full.lot}M${full.block}
                            `;
                        }},
                        { data: "amount", render: function (data, type, full){
                                let amount = formatter.format(data);
                                return amount;
                            }
                        },
                        { data: "front_payment", render: function (data, type, full){
                                let front_payment = formatter.format(data);
                                return front_payment;
                            } },
                        { data: "pending", render: function (data, type, full){
                                let pending = formatter.format(data);
                                return pending;
                            }},
                        { data: "order_status", render: function (data, type, full){
                                let badgeClass;
                                let badgeText;
                                if (data === 'Processing') {
                                    badgeClass = 'warning';
                                    badgeText = 'En proceso';
                                } else if (data === 'Delivered') {
                                    badgeClass = 'success';
                                    badgeText = 'Pagado';
                                }

                                return `
                                    <span class="badge badge-label badge-soft-${badgeClass}">
                                        ${badgeText}
                                    </span>`;
                            }
                        },
                        { data: "id", render: function (data, type, full){
                                return `
                                    <div class="d-flex justify-content-center gap-1">
                                        <a class="btn btn-light btn-icon btn-sm rounded-circle"
                                            href='/venta/${data}'>
                                            <i class="ti ti-eye fs-lg"></i>
                                        </a>
                                    </div>
                                `;
                            }
                        }
                    ],
                    language: {
                        paginate: {
                            first: '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M11 7l-5 5l5 5" /><path d="M17 7l-5 5l5 5" /></svg>',
                            previous:
                                '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M15 6l-6 6l6 6" /></svg>',
                            next: '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 6l6 6l-6 6" /></svg>',
                            last: '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M7 7l5 5l-5 5" /><path d="M13 7l5 5l-5 5" /></svg>',
                        },
                        lengthMenu: "_MENU_ ventas por página",
                        info: 'Mostrando <span class="fw-semibold">_START_</span> a <span class="fw-semibold">_END_</span> de <span class="fw-semibold">_TOTAL_</span> ventas',
                    },
                })
            }
        });



    </script>
<?= $this->endSection() ?>
