<?= $this->extend('app') ?>


<?= $this->section('styles') ?>


<?= $this->endSection() ?>

<?= $this->section('content') ?>

<!-- stats cards -->
<div class="row">
    <div class="col-xl-12">
        <div class="row h-100">
            <div class="col-lg-3 col-md-6">
                <div class="card card-h-100 overflow-hidden">
                    <div class="card-body pb-0">
                        <div class="d-flex align-items-center justify-content-between mb-2">
                            <div class="overflow-hidden flex-shrink-0">
                                <h3 class="fw-normal text-reset fs-20 lh-base">
                                    <span class="text-muted fs-base text-uppercase h5">Buen día,</span>
                                    <br />
                                    <b><?=auth()->user()->username?>!</b>
                                </h3>
                            </div>
                            <div class="flex-grow-1 text-end">
                                <img alt="Generic placeholder image" class="d-none d-xxl-inline-block" src="/images/svg/email-campaign.svg" width="110" />
                            </div>
                        </div>
                    </div>
                    <div class="card-body d-flex align-items-center p-2 bg-light bg-opacity-50">
                        <p class="d-flex align-items-center justify-content-between w-100 mb-0">
                                                <span class="me-2">
                                                    <i class="ti ti-calendar fs-15 align-middle"></i>
                                                    <span class="align-middle ms-1 fw-semibold">
                                                        <script>
                                                            document.write(new Date().toLocaleDateString("en-US", { day: "numeric", month: "short", year: "numeric" }))
                                                        </script>
                                                    </span>
                                                </span>
                            <span class="text-nowrap">
                                                    <i class="ti ti-clock fs-15 align-middle"></i>
                                                    <span class="align-middle ms-1 fw-semibold" id="clock-widget"></span>
                                                </span>
                        </p>
                    </div>
                    <!-- end card-body -->
                </div>
            </div>
            <!-- end col-->
            <div class="col-lg-3 col-md-6">
                <div class="card card-h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h5 class="text-muted fs-base text-uppercase" title="Number of Orders">Ventas</h5>
                                <h3 class="my-3 py-1 fw-semibold"><span data-target="9,999">0</span></h3>
                                <p class="mb-0 text-muted">
                                                        <span class="text-danger me-2">
                                                            <i class="ti ti-arrow-down"></i>
                                                            9.99%
                                                        </span>
                                    <span class="text-nowrap">vs el mes pasado</span>
                                </p>
                            </div>
                            <div class="avatar-md flex-shrink-0">
                                                    <span class="avatar-title bg-primary-subtle rounded-circle fs-22">
                                                        <i class="ti ti-shopping-cart text-primary"></i>
                                                    </span>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end card-->
            </div>
            <!-- end col-->
            <div class="col-lg-3 col-md-6">
                <div class="card card-h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h5 class="text-muted fs-base text-uppercase" title="Average Revenue">Ingresos</h5>
                                <h3 class="my-3 py-1 fw-semibold">
                                    $
                                    <span data-target="99,999">0</span>
                                    k
                                </h3>
                                <p class="mb-0 text-muted">
                                                        <span class="text-danger me-2">
                                                            <i class="ti ti-arrow-down"></i>
                                                            9.99%
                                                        </span>
                                    <span class="text-nowrap">vs el mes pasado</span>
                                </p>
                            </div>
                            <div class="avatar-md flex-shrink-0">
                                                    <span class="avatar-title bg-primary-subtle rounded-circle fs-22">
                                                        <i class="ti ti-pig-money text-primary"></i>
                                                    </span>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end card-->
            </div>
            <!-- end col-->
            <div class="col-lg-3 col-md-6">
                <div class="card card-h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between">
                            <div>
                                <h5 class="text-muted fs-base text-uppercase" title="Growth">Crecimiento</h5>
                                <h3 class="my-3 py-1 fw-semibold">
                                    +
                                    <span data-target="25.08">0</span>
                                    %
                                </h3>
                                <p class="mb-0 text-muted">
                                                        <span class="text-success me-2">
                                                            <i class="ti ti-arrow-up"></i>
                                                            9.99%
                                                        </span>
                                    <span class="text-nowrap">vs el mes pasado</span>
                                </p>
                            </div>
                            <div class="avatar-md flex-shrink-0">
                                                    <span class="avatar-title bg-primary-subtle rounded-circle fs-22">
                                                        <i class="ti ti-trending-up text-primary"></i>
                                                    </span>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end card-->
            </div>
            <!-- end col-->
        </div>
        <!-- end row -->
    </div>
</div>

<!-- payment form -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title mb-0">Registrar un venta</h4>
            </div>
            <div class="card-body">
                <form id="newSaleForm">
                    <div class="row g-3">
                        <!-- Order ID -->
                        <div class="col-md-6">
                            <label class="form-label">ID de la venta</label>
                            <input class="form-control"
                                   disabled=""
                                   id="orderId"
                                   placeholder="#<?=date('ymd-hms')?>"
                                   type="text" />
                        </div>
                        <!-- Order Date -->
                        <div class="col-md-6">
                            <label class="form-label">Fecha de la venta</label>
                            <input class="form-control flatpickr-input"
                                   data-altformat="F j, Y"
                                   data-provider="flatpickr"
                                   id="orderDate"
                                   name="order_date"
                                   required=""
                                   type="datetime-local" />
                        </div>
                        <!-- client Name -->
                        <div class="col-md-12">
                            <label class="form-label">Cliente <small>(Si no existe, registrar al cliente primero en la sección Clientes)</small></label>
                            <input class="form-control"
                                   id="clientName"
                                   placeholder="Mason Carter"
                                   required=""
                                   type="text" />
                        </div>
                        <!-- Block -->
                        <div class="col-md-6">
                            <label class="form-label">Manzana</label>
                            <input class="form-control"
                                   id="block"
                                   name="block"
                                   min="1"
                                   required=""
                                   type="number"
                                   value="1" />
                        </div>
                        <!-- Lot -->
                        <div class="col-md-6">
                            <label class="form-label">Lote</label>
                            <input class="form-control"
                                   id="lot"
                                   name="lot"
                                   min="1"
                                   required=""
                                   type="number"
                                   value="1" />
                        </div>
                        <!-- Amount -->
                        <div class="col-md-6">
                            <label class="form-label">Monto <small>(No usar comas ni signos)</small></label>
                            <input class="form-control"
                                   id="amount"
                                   name="amount"
                                   placeholder="135000"
                                   required=""
                                   step="100.0"
                                   type="number" />
                        </div>
                        <!-- FrontPayment -->
                        <div class="col-md-6">
                            <label class="form-label">Anticipo <small>(No usar comas ni signos)</small></label>
                            <input class="form-control"
                                   id="frontPayment"
                                   name="front_payment"
                                   placeholder="45000"
                                   required=""
                                   step="100.0"
                                   type="number" />
                        </div>
                        <!-- Payment Status -->
                        <div class="col-md-6">
                            <label class="form-label">Tipo de venta</label>
                            <select class="form-select" id="saleType" name="sale_type" required="">
                                <option value="Credit" selected>Crédito</option>
                                <option value="Cash">Contado</option>
                            </select>
                        </div>
                        <!-- Payment Method -->
                        <div class="col-md-6">
                            <label class="form-label">Método de pago</label>
                            <select class="form-select" id="paymentMethod" name="payment_method" required="">
                                <option value="Cash" selected>Efectivo</option>
                                <option value="Transfer">Transferencia</option>
                                <option value="Deposit">Deposito</option>
                            </select>
                        </div>
                        <!-- Order Status -->
                        <div class="col-md-6">
                            <label class="form-label">Estado de la venta</label>
                            <select class="form-select" id="orderStatus" name="order_status" required="">
                                <option value="Processing" selected>En proceso</option>
                                <option value="Delivered">Pagada</option>
                            </select>
                        </div>

                        <!-- Action Buttons -->
                        <div class="col-12 text-center">
                            <button class="btn btn-light me-2" data-bs-dismiss="modal" type="button">Cancelar</button>
                            <button class="btn btn-primary" type="submit">Guardar</button>
                        </div>
                    </div>
                    <!-- end row -->

                    <input type="hidden" id="clientID" name="client" value="">
                    <input type="hidden" name="created_by" value="<?=auth()->user()->id?>">
                    <input type="hidden" name="pending" id="pending">
                </form>
            </div>
            <!-- end card-body-->
        </div>
        <!-- end card-->
    </div>
    <!-- end col-->
</div>

<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
    <script>
        console.log('Start script loaded!');
        const clients = <?= json_encode($clients, JSON_UNESCAPED_UNICODE) ?>;

        // Client form
        $("#newSaleForm").on("submit",function(e){
            e.preventDefault();
            const amount = parseFloat($('#amount').val()) || 0;
            const frontPayment = parseFloat($('#frontPayment').val()) || 0;
            const pending = amount - frontPayment;
            $('#pending').val(pending >= 0 ? pending.toFixed(2) : 0);
            let saleData = $(this).serializeArray();
            console.log(saleData);
            $.ajax({
                method: "POST",
                url: "/sale",
                dataType: "JSON",
                data: saleData,
                success: function(){
                    showToast('success', 'Venta registrada');
                    $('#newSaleForm')[0].reset();
                },
                error: function(error){
                    showToast('danger', 'Ups, algo falló. Intentalo de nuevo');
                }
            }).done(function(){});
        });

        $('#clientName').autocomplete({
            minLength: 2,
            source: clients.map(c => ({
                label: c.name + ' ' + c.last_name,
                value: c.name + ' ' + c.last_name,
                id: c.id,
                email: c.email
            })),
            select: function (event, ui) {
                $('#clientID').val(ui.item.id);
            }
        });

    </script>
<?= $this->endSection() ?>
