<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Solar Duotone Icons')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Icons', 'title' => 'Solar Duotone')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header d-block">
                                    <h4 class="card-title mb-1 d-flex align-items-center gap-2">Overview</h4>
                                    <p class="mb-0 text-muted">Solar Duotone Solid is a bold, modern SVG icon set with a filled dual-tone style. Free for personal and commercial use.</p>
                                </div>
                                <div class="card-body">
                                    <h4 class="mt-0 fs-base mb-1">Usage</h4>
                                    <code>&lt;iconify-icon icon="solar:camera-bold-duotone"&gt;&lt;/iconify-icon&gt;</code>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <iconify-icon class="fs-3" icon="solar:camera-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-3" icon="solar:heart-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-3" icon="solar:star-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-3" icon="solar:check-circle-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-3" icon="solar:bell-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-3" icon="solar:cloud-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-3" icon="solar:user-bold-duotone"></iconify-icon>
                                    </div>
                                </div>
                                <div class="card-body border-top border-dashed">
                                    <h4 class="mt-0 fs-base mb-1">Colors</h4>
                                    <code>&lt;iconify-icon icon="solar:home-bold-duotone" class="text-xx"&gt;&lt;/iconify-icon&gt;</code>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <iconify-icon class="fs-3 text-primary" icon="solar:home-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-3 text-secondary" icon="solar:settings-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-3 text-success" icon="solar:calendar-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-3 text-info" icon="solar:chat-round-dots-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-3 text-warning" icon="solar:flag-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-3 text-danger" icon="solar:folder-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-3 text-light" icon="solar:adhesive-plaster-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-3 text-dark" icon="solar:key-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-3 text-purple" icon="solar:layers-bold-duotone"></iconify-icon>
                                    </div>
                                </div>
                                <div class="card-body border-top border-dashed">
                                    <h4 class="mt-0 fs-base mb-1">Sizes</h4>
                                    <code>&lt;iconify-icon icon="solar:watch-square-bold-duotone" class="fs-xx"&gt;&lt;/iconify-icon&gt;</code>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <iconify-icon class="fs-1" icon="solar:phone-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-2" icon="solar:tag-price-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-3" icon="solar:laptop-2-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-4" icon="solar:tablet-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-5" icon="solar:gamepad-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-6" icon="solar:alarm-bold-duotone"></iconify-icon>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 mt-3">
                                        <iconify-icon icon="solar:watch-square-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-sm" icon="solar:watch-square-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-lg" icon="solar:watch-square-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-xl" icon="solar:watch-square-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-xxl" icon="solar:watch-square-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-24" icon="solar:watch-square-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-32" icon="solar:watch-square-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-36" icon="solar:watch-square-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-42" icon="solar:watch-square-bold-duotone"></iconify-icon>
                                        <iconify-icon class="fs-60" icon="solar:watch-square-bold-duotone"></iconify-icon>
                                    </div>
                                </div>
                                <div class="card-body border-top border-dashed">
                                    <h4 class="mt-0 mb-3">Icons</h4>
                                    <div class="d-flex flex-wrap align-items-center text-center gap-2">
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:phone-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Phone</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:camera-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Camera</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:microphone-2-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Microphone</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:gamepad-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Gamepad</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:printer-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Printer</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:database-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Database</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:cloud-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Cloud</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:lock-keyhole-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Lock</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:key-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Key</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:shield-check-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Shield</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:letter-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Mail</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:chat-round-dots-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Chat</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:like-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Like</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:star-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Star</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:map-point-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Location</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:compass-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Compass</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:map-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Map</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:home-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Home</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:user-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">User</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:users-group-rounded-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Users</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:settings-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Settings</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:calendar-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Calendar</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:bell-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Notification</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:lock-keyhole-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Lock</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:key-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Key</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:shield-user-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Security</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:chart-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Chart</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:wallet-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Wallet</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:document-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Document</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:folder-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Folder</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:play-circle-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Play</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:pause-circle-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Pause</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:stop-circle-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Stop</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:upload-minimalistic-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Upload</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:bluetooth-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Bluetooth</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:battery-charge-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Battery</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:sun-2-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Light</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:moon-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Dark</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:bookmark-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Bookmark</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:chat-dots-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Message</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:settings-minimalistic-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Settings</span>
                                            </span>
                                        </div>
                                        <div class="avatar-xxl">
                                            <span class="avatar-title flex-column gap-1 border border-dashed rounded-3 overflow-hidden text-truncate text-center p-1">
                                                <iconify-icon class="fs-xxl" icon="solar:folder-open-bold-duotone"></iconify-icon>
                                                <span class="fw-semibold d-block w-100 text-truncate">Folder Open</span>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="text-center mt-3">
                                        <a class="btn btn-danger" href="https://icon-sets.iconify.design/solar/?suffixes=Bold+Duotone" target="_blank">View All Icons</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
