<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Contact Us')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Pages', 'title' => 'Contact Us')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row bg-light bg-opacity-50">
                                        <div class="col-12 py-2 text-center">
                                            <iframe src="https://www.google.com/maps/embed/v1/place?q=Eiffel+Tower&amp;key=AIzaSyBSFRN6WWGYwmFi498qXXsD2UwkbmD74v4" style="width: 100%; height: 360px; overflow: hidden; border: 0"></iframe>
                                        </div>
                                    </div>
                                    <section class="py-5">
                                        <div class="row">
                                            <div class="col-12 text-center">
                                                <span class="text-muted rounded-3 d-inline-block">📩 We’re here to help</span>
                                                <h3 class="mt-3 fw-bold mb-5">
                                                    Get in Touch with
                                                    <mark>Our Team</mark>
                                                </h3>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xxl-4">
                                                <div class="p-4">
                                                    <div class="d-flex gap-3 mb-5">
                                                        <div class="avatar-xl flex-shrink-0">
                                                            <span class="avatar-title bg-secondary-subtle text-secondary rounded-circle fs-22">
                                                                <i class="ti ti-phone-call"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <span class="text-muted">Contact Numbers</span>
                                                            <h5 class="my-2">+1 (800) 123-4567</h5>
                                                            <h5 class="mb-0">+1 (415) 987-6543</h5>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex gap-3 mb-5">
                                                        <div class="avatar-xl flex-shrink-0">
                                                            <span class="avatar-title bg-secondary-subtle text-secondary rounded-circle fs-22">
                                                                <i class="ti ti-mail"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <span class="text-muted">Email</span>
                                                            <h5 class="my-2">support@yourcompany.com</h5>
                                                            <h5 class="mb-0">info@yourcompany.com</h5>
                                                        </div>
                                                    </div>
                                                    <div class="d-flex gap-3">
                                                        <div class="avatar-xl flex-shrink-0">
                                                            <span class="avatar-title bg-secondary-subtle text-secondary rounded-circle fs-22">
                                                                <i class="ti ti-map-pin"></i>
                                                            </span>
                                                        </div>
                                                        <div>
                                                            <span class="text-muted">Address</span>
                                                            <h5 class="my-1 lh-lg">Premium HQ, 123 Market Street, 5th Floor, Financial District, San Francisco, CA 94103, United States</h5>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- end .p-4-->
                                            </div>
                                            <!-- end col-->
                                            <div class="col-xxl-8">
                                                <form class="p-4 border rounded-4 border-dashed">
                                                    <div class="row g-3">
                                                        <div class="col-md-6">
                                                            <label class="form-label" for="name">Full Name</label>
                                                            <input autocomplete="name" class="form-control py-2" id="name" placeholder="Enter your full name" type="text" />
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label class="form-label" for="email">Email Address</label>
                                                            <input autocomplete="email" class="form-control py-2" id="email" placeholder="Enter your email" type="email" />
                                                        </div>
                                                        <div class="col-md-12">
                                                            <label class="form-label" for="subject">Subject</label>
                                                            <input class="form-control py-2" id="subject" placeholder="What’s the reason for contact?" type="text" />
                                                        </div>
                                                        <div class="col-md-12">
                                                            <label class="form-label" for="message">Message</label>
                                                            <textarea class="form-control py-2" id="message" placeholder="Write your message here..." rows="5"></textarea>
                                                        </div>
                                                        <div class="col-md-12 text-end">
                                                            <button class="btn btn-primary rounded-pill" type="submit">Send Message</button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                            <!-- end col-->
                                        </div>
                                        <!-- end row-->
                                    </section>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
