<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Animation')) ?>

        <!-- Animate.css -->
        <link href="/plugins/animate/animate.min.css" rel="stylesheet" />

        <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('title' => 'Animation', 'subtitle' => 'Plugins')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Animate.css</h4>
                                </div>
                                <div class="card-body">
                                    <p class="text-muted">
                                        A cross-browser library of CSS animations. Animate.css is a bunch of cool, fun, and cross-browser animations for you to use in your projects. Great for emphasis, home pages, sliders, and general just-add-water-awesomeness.
                                    </p>
                                    <div class="row g-lg-4">
                                        <div class="col-sm-4">
                                            <div class="card card-top-sticky overflow-hidden">
                                                <div class="card-body">
                                                    <div class="animate__animated" id="animation_box">
                                                        <img alt="user" class="img-fluid rounded" src="/images/blog/blog-1.jpg" />
                                                    </div>
                                                    <p class="mt-3 text-muted text-center mb-0">Example box for animation effect.</p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-8">
                                            <div class="alert alert-info">Click any of the buttons below to see the animation effect applied to the box on the left.</div>
                                            <div class="accordion" id="animationAccordion">
                                                <!-- Attention Seekers -->
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header" id="headingAttention">
                                                        <button class="accordion-button" data-bs-target="#collapseAttention" data-bs-toggle="collapse" type="button">Attention Seekers</button>
                                                    </h2>
                                                    <div class="accordion-collapse collapse show" data-bs-parent="#animationAccordion" id="collapseAttention">
                                                        <div class="accordion-body d-flex flex-wrap gap-2">
                                                            <a class="btn btn-light animation_select" data-animation="bounce" href="#">bounce</a>
                                                            <a class="btn btn-light animation_select" data-animation="flash" href="#">flash</a>
                                                            <a class="btn btn-light animation_select" data-animation="pulse" href="#">pulse</a>
                                                            <a class="btn btn-light animation_select" data-animation="rubberBand" href="#">rubberBand</a>
                                                            <a class="btn btn-light animation_select" data-animation="shakeX" href="#">shakeX</a>
                                                            <a class="btn btn-light animation_select" data-animation="shakeY" href="#">shakeY</a>
                                                            <a class="btn btn-light animation_select" data-animation="headShake" href="#">headShake</a>
                                                            <a class="btn btn-light animation_select" data-animation="swing" href="#">swing</a>
                                                            <a class="btn btn-light animation_select" data-animation="tada" href="#">tada</a>
                                                            <a class="btn btn-light animation_select" data-animation="wobble" href="#">wobble</a>
                                                            <a class="btn btn-light animation_select" data-animation="jello" href="#">jello</a>
                                                            <a class="btn btn-light animation_select" data-animation="heartBeat" href="#">heartBeat</a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Bouncing Entrances -->
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header" id="headingBounceIn">
                                                        <button class="accordion-button collapsed" data-bs-target="#collapseBounceIn" data-bs-toggle="collapse" type="button">Bouncing Entrances</button>
                                                    </h2>
                                                    <div class="accordion-collapse collapse" data-bs-parent="#animationAccordion" id="collapseBounceIn">
                                                        <div class="accordion-body d-flex flex-wrap gap-2">
                                                            <a class="btn btn-light animation_select" data-animation="bounceIn" href="#">bounceIn</a>
                                                            <a class="btn btn-light animation_select" data-animation="bounceInDown" href="#">bounceInDown</a>
                                                            <a class="btn btn-light animation_select" data-animation="bounceInLeft" href="#">bounceInLeft</a>
                                                            <a class="btn btn-light animation_select" data-animation="bounceInRight" href="#">bounceInRight</a>
                                                            <a class="btn btn-light animation_select" data-animation="bounceInUp" href="#">bounceInUp</a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Fading Entrances -->
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header" id="headingFadeIn">
                                                        <button class="accordion-button collapsed" data-bs-target="#collapseFadeIn" data-bs-toggle="collapse" type="button">Fading Entrances</button>
                                                    </h2>
                                                    <div class="accordion-collapse collapse" data-bs-parent="#animationAccordion" id="collapseFadeIn">
                                                        <div class="accordion-body d-flex flex-wrap gap-2">
                                                            <a class="btn btn-light animation_select" data-animation="fadeIn" href="#">fadeIn</a>
                                                            <a class="btn btn-light animation_select" data-animation="fadeInDown" href="#">fadeInDown</a>
                                                            <a class="btn btn-light animation_select" data-animation="fadeInLeft" href="#">fadeInLeft</a>
                                                            <a class="btn btn-light animation_select" data-animation="fadeInRight" href="#">fadeInRight</a>
                                                            <a class="btn btn-light animation_select" data-animation="fadeInUp" href="#">fadeInUp</a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Fading Exits -->
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header" id="headingFadeOut">
                                                        <button class="accordion-button collapsed" data-bs-target="#collapseFadeOut" data-bs-toggle="collapse" type="button">Fading Exits</button>
                                                    </h2>
                                                    <div class="accordion-collapse collapse" data-bs-parent="#animationAccordion" id="collapseFadeOut">
                                                        <div class="accordion-body d-flex flex-wrap gap-2">
                                                            <a class="btn btn-light animation_select" data-animation="fadeOut" href="#">fadeOut</a>
                                                            <a class="btn btn-light animation_select" data-animation="fadeOutDown" href="#">fadeOutDown</a>
                                                            <a class="btn btn-light animation_select" data-animation="fadeOutLeft" href="#">fadeOutLeft</a>
                                                            <a class="btn btn-light animation_select" data-animation="fadeOutRight" href="#">fadeOutRight</a>
                                                            <a class="btn btn-light animation_select" data-animation="fadeOutUp" href="#">fadeOutUp</a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Flippers -->
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header" id="headingFlip">
                                                        <button class="accordion-button collapsed" data-bs-target="#collapseFlip" data-bs-toggle="collapse" type="button">Flippers</button>
                                                    </h2>
                                                    <div class="accordion-collapse collapse" data-bs-parent="#animationAccordion" id="collapseFlip">
                                                        <div class="accordion-body d-flex flex-wrap gap-2">
                                                            <a class="btn btn-light animation_select" data-animation="flip" href="#">flip</a>
                                                            <a class="btn btn-light animation_select" data-animation="flipInX" href="#">flipInX</a>
                                                            <a class="btn btn-light animation_select" data-animation="flipInY" href="#">flipInY</a>
                                                            <a class="btn btn-light animation_select" data-animation="flipOutX" href="#">flipOutX</a>
                                                            <a class="btn btn-light animation_select" data-animation="flipOutY" href="#">flipOutY</a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Light Speed -->
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header" id="headingLightSpeed">
                                                        <button class="accordion-button collapsed" data-bs-target="#collapseLightSpeed" data-bs-toggle="collapse" type="button">Light Speed</button>
                                                    </h2>
                                                    <div class="accordion-collapse collapse" data-bs-parent="#animationAccordion" id="collapseLightSpeed">
                                                        <div class="accordion-body d-flex flex-wrap gap-2">
                                                            <a class="btn btn-light animation_select" data-animation="lightSpeedInLeft" href="#">lightSpeedInLeft</a>
                                                            <a class="btn btn-light animation_select" data-animation="lightSpeedInRight" href="#">lightSpeedInRight</a>
                                                            <a class="btn btn-light animation_select" data-animation="lightSpeedOutLeft" href="#">lightSpeedOutLeft</a>
                                                            <a class="btn btn-light animation_select" data-animation="lightSpeedOutRight" href="#">lightSpeedOutRight</a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Rotate -->
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header" id="headingRotate">
                                                        <button class="accordion-button collapsed" data-bs-target="#collapseRotate" data-bs-toggle="collapse" type="button">Rotate</button>
                                                    </h2>
                                                    <div class="accordion-collapse collapse" data-bs-parent="#animationAccordion" id="collapseRotate">
                                                        <div class="accordion-body d-flex flex-wrap gap-2">
                                                            <a class="btn btn-light animation_select" data-animation="rotateIn" href="#">rotateIn</a>
                                                            <a class="btn btn-light animation_select" data-animation="rotateInDownLeft" href="#">rotateInDownLeft</a>
                                                            <a class="btn btn-light animation_select" data-animation="rotateInDownRight" href="#">rotateInDownRight</a>
                                                            <a class="btn btn-light animation_select" data-animation="rotateInUpLeft" href="#">rotateInUpLeft</a>
                                                            <a class="btn btn-light animation_select" data-animation="rotateInUpRight" href="#">rotateInUpRight</a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Zoom -->
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header" id="headingZoom">
                                                        <button class="accordion-button collapsed" data-bs-target="#collapseZoom" data-bs-toggle="collapse" type="button">Zoom</button>
                                                    </h2>
                                                    <div class="accordion-collapse collapse" data-bs-parent="#animationAccordion" id="collapseZoom">
                                                        <div class="accordion-body d-flex flex-wrap gap-2">
                                                            <a class="btn btn-light animation_select" data-animation="zoomIn" href="#">zoomIn</a>
                                                            <a class="btn btn-light animation_select" data-animation="zoomInDown" href="#">zoomInDown</a>
                                                            <a class="btn btn-light animation_select" data-animation="zoomInLeft" href="#">zoomInLeft</a>
                                                            <a class="btn btn-light animation_select" data-animation="zoomInRight" href="#">zoomInRight</a>
                                                            <a class="btn btn-light animation_select" data-animation="zoomInUp" href="#">zoomInUp</a>
                                                            <a class="btn btn-light animation_select" data-animation="zoomOut" href="#">zoomOut</a>
                                                            <a class="btn btn-light animation_select" data-animation="zoomOutDown" href="#">zoomOutDown</a>
                                                            <a class="btn btn-light animation_select" data-animation="zoomOutLeft" href="#">zoomOutLeft</a>
                                                            <a class="btn btn-light animation_select" data-animation="zoomOutRight" href="#">zoomOutRight</a>
                                                            <a class="btn btn-light animation_select" data-animation="zoomOutUp" href="#">zoomOutUp</a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Sliding -->
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header" id="headingSlide">
                                                        <button class="accordion-button collapsed" data-bs-target="#collapseSlide" data-bs-toggle="collapse" type="button">Sliding</button>
                                                    </h2>
                                                    <div class="accordion-collapse collapse" data-bs-parent="#animationAccordion" id="collapseSlide">
                                                        <div class="accordion-body d-flex flex-wrap gap-2">
                                                            <a class="btn btn-light animation_select" data-animation="slideInDown" href="#">slideInDown</a>
                                                            <a class="btn btn-light animation_select" data-animation="slideInLeft" href="#">slideInLeft</a>
                                                            <a class="btn btn-light animation_select" data-animation="slideInRight" href="#">slideInRight</a>
                                                            <a class="btn btn-light animation_select" data-animation="slideInUp" href="#">slideInUp</a>
                                                            <a class="btn btn-light animation_select" data-animation="slideOutDown" href="#">slideOutDown</a>
                                                            <a class="btn btn-light animation_select" data-animation="slideOutLeft" href="#">slideOutLeft</a>
                                                            <a class="btn btn-light animation_select" data-animation="slideOutRight" href="#">slideOutRight</a>
                                                            <a class="btn btn-light animation_select" data-animation="slideOutUp" href="#">slideOutUp</a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Special -->
                                                <div class="accordion-item">
                                                    <h2 class="accordion-header" id="headingSpecial">
                                                        <button class="accordion-button collapsed" data-bs-target="#collapseSpecial" data-bs-toggle="collapse" type="button">Special</button>
                                                    </h2>
                                                    <div class="accordion-collapse collapse" data-bs-parent="#animationAccordion" id="collapseSpecial">
                                                        <div class="accordion-body d-flex flex-wrap gap-2">
                                                            <a class="btn btn-light animation_select" data-animation="hinge" href="#">hinge</a>
                                                            <a class="btn btn-light animation_select" data-animation="jackInTheBox" href="#">jackInTheBox</a>
                                                            <a class="btn btn-light animation_select" data-animation="rollIn" href="#">rollIn</a>
                                                            <a class="btn btn-light animation_select" data-animation="rollOut" href="#">rollOut</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <script src="/js/pages/plugins-animation.js"></script>
    </body>
</html>
