<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Idle Timer')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('title' => 'Idle Timer', 'subtitle' => 'Plugins')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Idle Timer Plugin</h4>
                                </div>
                                <div class="card-body">
                                    <!-- Alert placeholder (initially hidden) -->
                                    <div class="alert alert-danger d-none idle-alert" role="alert">Your session has expired. Please move your mouse to resume your activity.</div>
                                    <p class="text-muted">The Idle Timer plugin allows you to monitor user activity on the page. Idle is defined as a lack of mouse movement, scrolling, or keyboard input.</p>
                                    <div class="text-center p-3 h-200">
                                        <i class="ti ti-fingerprint fs-36 mb-3 d-inline-block mx-auto"></i>
                                        <h3 class="fst-italic">Please stay idle for 5 seconds</h3>
                                    </div>
                                    <p class="mb-0">
                                        You can instantiate the timer either statically or on a specific element. Element-bound timers will only track activity within that element, whereas global timers will monitor activity on the entire page. To set up page-level activity, you
                                        can initialize the timer on
                                        <code>document</code>
                                        ,
                                        <code>document.documentElement</code>
                                        , or
                                        <code>document.body</code>
                                        . The initialization returns a jQuery object, allowing for method chaining.
                                    </p>
                                    <div class="toast-container position-fixed top-0 end-0 p-3">
                                        <!-- Success Toast -->
                                        <div aria-atomic="true" aria-live="assertive" class="toast shadow-lg text-bg-success border-success" id="backToast" role="alert">
                                            <div class="toast-header text-bg-success border-success">
                                                <strong class="me-auto">Welcome Back</strong>
                                                <small>Now</small>
                                                <button aria-label="Close" class="btn-close btn-close-white" data-bs-dismiss="toast" type="button"></button>
                                            </div>
                                            <div class="toast-body fst-italic">We missed you! Welcome back!</div>
                                        </div>
                                        <!-- Toast container -->
                                        <div aria-atomic="true" aria-live="assertive" class="toast shadow-lg text-bg-warning border-warning" id="liveToast" role="alert">
                                            <div class="toast-header text-bg-warning border-warning">
                                                <img alt="..." class="rounded me-2" height="20" src="/images/logo-sm.png" />
                                                <strong class="me-auto">Idle Alert</strong>
                                                <small>Just now</small>
                                                <button aria-label="Close" class="btn-close" data-bs-dismiss="toast" type="button"></button>
                                            </div>
                                            <div class="toast-body fst-italic">You've been inactive for too long. Please interact with the page to continue.</div>
                                        </div>
                                    </div>
                                    <!-- end toast-container-->
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                </div>
                <!-- end container-->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <script src="/js/pages/plugins-idle-timer.js"></script>
    </body>
</html>
