<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Masonry')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('title' => 'Masonry', 'subtitle' => 'Plugins')) ?>

                    <div class="row" data-masonry='{"percentPosition": true }'>
                        <div class="col-xl-3 col-md-6 mb-3">
                            <article class="card mb-0">
                                <!-- Card Body -->
                                <div class="card-body">
                                    <!-- Title -->
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="#!">Mastering Figma: 7 Pro Tips for Better UI Design</a>
                                    </h6>
                                    <p class="mb-3 text-muted">Unlock advanced techniques in Figma that can speed up your workflow and help you create pixel-perfect designs every time.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">Figma</a>
                                        <a class="badge badge-label badge-default" href="#!">UX</a>
                                        <a class="badge badge-label badge-default" href="#!">Tips</a>
                                    </div>
                                </div>
                                <!-- Card footer -->
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-6" class="img-fluid rounded-circle" src="/images/users/user-6.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">Emma Blake</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold" href="#!">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <div class="col-xl-3 col-md-6 mb-3">
                            <article class="card mb-0">
                                <!-- Card Body -->
                                <div class="card-body">
                                    <blockquote class="blockquote">
                                        <p>A well-known quote, contained in a blockquote element.</p>
                                    </blockquote>
                                    <figcaption class="blockquote-footer mb-0 text-muted">
                                        Someone famous in
                                        <cite title="Source Title">Source Title</cite>
                                    </figcaption>
                                </div>
                                <!-- Card footer -->
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-7" class="img-fluid rounded-circle" src="/images/users/user-7.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">Liam Carter</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold" href="#!">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <div class="col-xl-3 col-md-6 mb-3">
                            <article class="card mb-0">
                                <!-- Card Body -->
                                <div class="card-body">
                                    <!-- Title -->
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="#!">Understanding CSS Grid: A Complete Beginner’s Guide</a>
                                    </h6>
                                    <p class="mb-3 text-muted">Explore the fundamentals of CSS Grid layout and learn how to create modern.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">CSS</a>
                                        <a class="badge badge-label badge-default" href="#!">Frontend</a>
                                        <a class="badge badge-label badge-default" href="#!">Web Design</a>
                                    </div>
                                </div>
                                <!-- Card footer -->
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-8" class="img-fluid rounded-circle" src="/images/users/user-8.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">Sophia Turner</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold" href="#!">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <div class="col-xl-3 col-md-6 mb-3">
                            <article class="card mb-0">
                                <div class="card-body">
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="#!">The Future of AI in Everyday Apps</a>
                                    </h6>
                                    <p class="mb-3 text-muted">Artificial Intelligence is reshaping how we interact with software. From smart assistants to predictive analytics, here’s what’s coming next.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">AI</a>
                                        <a class="badge badge-label badge-default" href="#!">Technology</a>
                                        <a class="badge badge-label badge-default" href="#!">Innovation</a>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-9" class="img-fluid rounded-circle" src="/images/users/user-9.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">Noah Evans</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold" href="#!">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <div class="col-xl-3 col-md-6 mb-3">
                            <article class="card mb-0">
                                <div class="card-body">
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="#!">Top 10 JavaScript Tricks You Didn’t Know</a>
                                    </h6>
                                    <p class="mb-3 text-muted">JavaScript has plenty of hidden gems. This list goes beyond the basics, giving you shortcuts and lesser-known features to write cleaner code.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">JavaScript</a>
                                        <a class="badge badge-label badge-default" href="#!">Tips</a>
                                        <a class="badge badge-label badge-default" href="#!">Coding</a>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-10" class="img-fluid rounded-circle" src="/images/users/user-10.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">Olivia Scott</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold" href="#!">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <div class="col-xl-3 col-md-6 mb-3">
                            <article class="card mb-0">
                                <div class="card-body">
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="#!">Why Minimalism Works in Web Design</a>
                                    </h6>
                                    <p class="mb-3 text-muted">Sometimes, less is more. Discover how minimalistic design choices improve usability, reduce clutter, and create stronger focus for users across digital experiences.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">Design</a>
                                        <a class="badge badge-label badge-default" href="#!">Minimalism</a>
                                        <a class="badge badge-label badge-default" href="#!">Trends</a>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-11" class="img-fluid rounded-circle" src="/images/users/user-3.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">Ethan Brooks</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold" href="#!">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <div class="col-xl-3 col-md-6 mb-3">
                            <article class="card mb-0">
                                <div class="card-body">
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="#!">Getting Started with Tailwind CSS in 2025</a>
                                    </h6>
                                    <p class="mb-3 text-muted">Tailwind continues to dominate utility-first styling. Learn how to set up your environment and build your first responsive components quickly.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">Tailwind</a>
                                        <a class="badge badge-label badge-default" href="#!">Frontend</a>
                                        <a class="badge badge-label badge-default" href="#!">Guide</a>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-12" class="img-fluid rounded-circle" src="/images/users/user-2.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">Mia Johnson</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold" href="#!">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <div class="col-xl-3 col-md-6 mb-3">
                            <article class="card mb-0">
                                <div class="card-body">
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="#!">Dark Mode: Design Principles You Should Know</a>
                                    </h6>
                                    <p class="mb-3 text-muted">With dark mode becoming a standard feature, it’s important to understand contrast, accessibility, and design adjustments for user comfort.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">Dark Mode</a>
                                        <a class="badge badge-label badge-default" href="#!">UI</a>
                                        <a class="badge badge-label badge-default" href="#!">Accessibility</a>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-13" class="img-fluid rounded-circle" src="/images/users/user-5.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">Lucas Reed</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold" href="#!">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <div class="col-xl-3 col-md-6 mb-3">
                            <article class="card mb-0">
                                <div class="card-body">
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="#!">Why Storytelling Matters in UX Writing</a>
                                    </h6>
                                    <p class="mb-3 text-muted">Words shape user experiences. Good UX writing blends clarity with storytelling, ensuring users not only understand but enjoy every step.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">UX Writing</a>
                                        <a class="badge badge-label badge-default" href="#!">Content</a>
                                        <a class="badge badge-label badge-default" href="#!">Design</a>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-14" class="img-fluid rounded-circle" src="/images/users/user-9.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">Isabella Moore</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold" href="#!">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                        <div class="col-xl-3 col-md-6 mb-3">
                            <article class="card mb-0">
                                <div class="card-body">
                                    <h6 class="card-title fs-lg lh-base mb-2">
                                        <a class="link-reset" href="#!">Building Scalable Apps with Next.js</a>
                                    </h6>
                                    <p class="mb-3 text-muted">Next.js has quickly become the go-to framework for modern apps. Here’s how you can take advantage of its server-side rendering and API routes to build scalable projects.</p>
                                    <div>
                                        <a class="badge badge-label badge-default" href="#!">Next.js</a>
                                        <a class="badge badge-label badge-default" href="#!">Performance</a>
                                        <a class="badge badge-label badge-default" href="#!">Development</a>
                                    </div>
                                </div>
                                <div class="card-footer bg-transparent d-flex justify-content-between">
                                    <div class="d-flex justify-content-start align-items-center gap-2">
                                        <div class="avatar avatar-xs">
                                            <img alt="avatar-15" class="img-fluid rounded-circle" src="/images/users/user-2.jpg" />
                                        </div>
                                        <div>
                                            <h5 class="text-nowrap fs-sm mb-0 lh-base">
                                                <a class="link-reset" href="#!">James Bennett</a>
                                            </h5>
                                        </div>
                                    </div>
                                    <a class="link-primary fw-semibold" href="#!">
                                        Read more
                                        <i class="ti ti-arrow-right"></i>
                                    </a>
                                </div>
                            </article>
                        </div>
                    </div>
                    <!-- end row-->
                </div>

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <script src="/plugins/masonry/masonry.pkgd.min.js"></script>
    </body>
</html>
