<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'PDF Viewer')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('title' => 'PDF Viewer', 'subtitle' => 'Plugins')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-body">
                                    <div class="text-center">
                                        <div class="btn-group text-nowrap">
                                            <button class="btn btn-dark" id="prev">
                                                <i class="ti ti-arrow-left"></i>
                                                <span class="d-none d-sm-inline ms-2">Previous</span>
                                            </button>
                                            <button class="btn btn-dark" id="next">
                                                <i class="ti ti-arrow-right"></i>
                                                <span class="d-none d-sm-inline ms-2">Next</span>
                                            </button>
                                            <button class="btn btn-dark" id="zoomin">
                                                <i class="ti ti-zoom-in"></i>
                                                <span class="d-none d-sm-inline ms-2">Zoom In</span>
                                            </button>
                                            <button class="btn btn-dark" id="zoomout">
                                                <i class="ti ti-zoom-out"></i>
                                                <span class="d-none d-sm-inline ms-2">Zoom Out</span>
                                            </button>
                                            <button class="btn btn-dark rounded-end-3" id="zoomfit">100%</button>
                                            <input class="form-control rounded-end-0 ms-1" id="page_num" style="width: 50px" type="text" />
                                            <span class="input-group-text rounded-start-0 border-start-0" id="page_count">/ 00</span>
                                        </div>
                                    </div>
                                    <div class="text-center overflow-auto mt-3">
                                        <canvas class="pdfcanvas border rounded-3" id="the-canvas"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- PDF Plugin Js-->
        <script src="/plugins/pdfjs/pdf.min.js"></script>
        <!-- PDF Viewer Page Js-->
        <script src="/js/pages/plugins-pdf-viewer.js"></script>
    </body>
</html>
