<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Sortables List')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('title' => 'Sortables List', 'subtitle' => 'Plugins')) ?>

                    <div class="row">
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Sortables List</h4>
                                </div>
                                <!-- end card header -->
                                <div class="card-body">
                                    <p class="text-muted">
                                        Use
                                        <code>nested-sortable</code>
                                        classes on the
                                        <code>list-group</code>
                                        element to enable drag-and-drop sorting of hierarchical task items.
                                    </p>
                                    <div class="list-group fw-medium nested-sortable">
                                        <div class="list-group-item">Design Phase</div>
                                        <div class="list-group-item">
                                            Development Phase
                                            <div class="list-group nested-sortable">
                                                <div class="list-group-item">Frontend Implementation</div>
                                                <div class="list-group-item">
                                                    Backend API Setup
                                                    <div class="list-group nested-sortable">
                                                        <div class="list-group-item">Authentication Module</div>
                                                        <div class="list-group-item">Database Schema</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="list-group-item">
                                            Testing Phase
                                            <div class="list-group nested-sortable">
                                                <div class="list-group-item">Unit Tests</div>
                                                <div class="list-group-item">Integration Tests</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card-body -->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Sortables List with Handle</h4>
                                </div>
                                <!-- end card header -->
                                <div class="card-body">
                                    <p class="text-muted">
                                        Use
                                        <code>nested-sortable-handle</code>
                                        class to list-group class to set a nested list with sortable items.
                                    </p>
                                    <div class="list-group fw-medium nested-sortable-handle">
                                        <div class="list-group-item nested-1">
                                            <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                            Project Alpha
                                            <div class="list-group nested-sortable-handle">
                                                <div class="list-group-item nested-2">
                                                    <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                                    Design Phase
                                                </div>
                                                <div class="list-group-item nested-2">
                                                    <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                                    Development Phase
                                                    <div class="list-group nested-sortable-handle">
                                                        <div class="list-group-item nested-3">
                                                            <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                                            Frontend Module
                                                        </div>
                                                        <div class="list-group-item nested-3">
                                                            <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                                            Backend Module
                                                        </div>
                                                        <div class="list-group-item nested-3">
                                                            <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                                            API Integration
                                                        </div>
                                                        <div class="list-group-item nested-3">
                                                            <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                                            Unit Testing
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="list-group-item nested-2">
                                                    <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                                    QA Review
                                                </div>
                                                <div class="list-group-item nested-2">
                                                    <i class="ti ti-grip-horizontal align-middle sort-handle"></i>
                                                    Deployment
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card-body -->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Sortable with Icons</h4>
                                </div>
                                <!-- end card header -->
                                <div class="card-body">
                                    <p class="text-muted">
                                        Use
                                        <code>nested-sortable</code>
                                        class to list-group class to set a nested list with sortable items where icons are given within list-group-item.
                                    </p>
                                    <div class="list-group border-dashed">
                                        <div class="list-group-item">
                                            <div class="d-flex align-items-center gap-2 mb-2">
                                                <div class="avatar-xs flex-shrink-0">
                                                    <span class="avatar-title text-bg-light rounded-circle">
                                                        <i class="ti ti-layout-kanban fs-sm text-primary"></i>
                                                    </span>
                                                </div>
                                                <div>
                                                    <h5 class="mb-0">Tasks</h5>
                                                </div>
                                            </div>
                                            <div class="list-group nested-sortable border-0">
                                                <div class="list-group-item">
                                                    <i class="ti ti-list-check fs-sm me-2 text-muted"></i>
                                                    To Do
                                                </div>
                                                <div class="list-group-item">
                                                    <i class="ti ti-info-circle fs-sm me-2 text-muted"></i>
                                                    In Progress
                                                </div>
                                                <div class="list-group-item">
                                                    <i class="ti ti-circle-check fs-sm me-2 text-muted"></i>
                                                    Completed
                                                </div>
                                            </div>
                                        </div>
                                        <div class="list-group-item">
                                            <div class="d-flex align-items-center gap-2 mb-2">
                                                <div class="avatar-xs flex-shrink-0">
                                                    <span class="avatar-title text-bg-light rounded-circle">
                                                        <i class="ti ti-flag fs-sm text-primary"></i>
                                                    </span>
                                                </div>
                                                <div>
                                                    <h5 class="mb-0">Milestones</h5>
                                                </div>
                                            </div>
                                            <div class="list-group nested-sortable border-0">
                                                <div class="list-group-item">
                                                    <i class="ti ti-flag fs-sm me-2 text-muted"></i>
                                                    Project Kickoff
                                                </div>
                                                <div class="list-group-item">
                                                    <i class="ti ti-flag fs-sm me-2 text-muted"></i>
                                                    Phase 1 Completion
                                                </div>
                                                <div class="list-group-item">
                                                    <i class="ti ti-flag fs-sm me-2 text-muted"></i>
                                                    Final Delivery
                                                </div>
                                            </div>
                                        </div>
                                        <div class="list-group-item">
                                            <div class="d-flex align-items-center gap-2 mb-2">
                                                <div class="avatar-xs flex-shrink-0">
                                                    <span class="avatar-title text-bg-light rounded-circle">
                                                        <i class="ti ti-users fs-sm text-primary"></i>
                                                    </span>
                                                </div>
                                                <div>
                                                    <h5 class="mb-0">Teams</h5>
                                                </div>
                                            </div>
                                            <div class="list-group nested-sortable border-0">
                                                <div class="list-group-item">
                                                    <i class="ti ti-user fs-sm me-2 text-muted"></i>
                                                    Development Team
                                                </div>
                                                <div class="list-group-item">
                                                    <i class="ti ti-user fs-sm me-2 text-muted"></i>
                                                    Design Team
                                                </div>
                                                <div class="list-group-item">
                                                    <i class="ti ti-user fs-sm me-2 text-muted"></i>
                                                    QA Team
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card-body -->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Sortable with Icons with Labels</h4>
                                </div>
                                <!-- end card header -->
                                <div class="card-body">
                                    <p class="text-muted">
                                        Use
                                        <code>nested-sortable</code>
                                        class with the list-group class to create a nested list with sortable items where icons are placed inside list-group-item.
                                    </p>
                                    <div class="list-group border-dashed">
                                        <!-- Section 1 -->
                                        <div class="list-group-item">
                                            <div class="d-flex align-items-center justify-content-between mb-2">
                                                <div class="d-flex align-items-center gap-2">
                                                    <i class="ti ti-layout-kanban fs-4 text-primary"></i>
                                                    <h5 class="mb-0 fw-semibold">Strategy</h5>
                                                </div>
                                                <span class="badge bg-primary-subtle text-primary">Phase A</span>
                                            </div>
                                            <div class="list-group nested-sortable border-0">
                                                <div class="list-group-item">
                                                    <i class="ti ti-list-check fs-sm me-2 text-muted"></i>
                                                    Research Topics
                                                </div>
                                                <div class="list-group-item">
                                                    <i class="ti ti-info-circle fs-sm me-2 text-muted"></i>
                                                    Analysis in Progress
                                                </div>
                                                <div class="list-group-item">
                                                    <i class="ti ti-circle-check fs-sm me-2 text-muted"></i>
                                                    Insights Approved
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Section 2 -->
                                        <div class="list-group-item">
                                            <div class="d-flex align-items-center justify-content-between mb-2">
                                                <div class="d-flex align-items-center gap-2">
                                                    <i class="ti ti-flag fs-4 text-primary"></i>
                                                    <h5 class="mb-0 fw-semibold">Key Deliverables</h5>
                                                </div>
                                                <span class="badge bg-info-subtle text-info">Phase B</span>
                                            </div>
                                            <div class="list-group nested-sortable border-0">
                                                <div class="list-group-item">
                                                    <i class="ti ti-flag fs-sm me-2 text-muted"></i>
                                                    Initial Draft Release
                                                </div>
                                                <div class="list-group-item">
                                                    <i class="ti ti-flag fs-sm me-2 text-muted"></i>
                                                    User Testing Round
                                                </div>
                                                <div class="list-group-item">
                                                    <i class="ti ti-flag fs-sm me-2 text-muted"></i>
                                                    Final Launch
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Section 3 -->
                                        <div class="list-group-item">
                                            <div class="d-flex align-items-center justify-content-between mb-2">
                                                <div class="d-flex align-items-center gap-2">
                                                    <i class="ti ti-users fs-4 text-primary"></i>
                                                    <h5 class="mb-0 fw-semibold">Departments</h5>
                                                </div>
                                                <span class="badge bg-success-subtle text-success">Phase C</span>
                                            </div>
                                            <div class="list-group nested-sortable border-0">
                                                <div class="list-group-item">
                                                    <i class="ti ti-user fs-sm me-2 text-muted"></i>
                                                    Engineering Unit
                                                </div>
                                                <div class="list-group-item">
                                                    <i class="ti ti-user fs-sm me-2 text-muted"></i>
                                                    Creative Studio
                                                </div>
                                                <div class="list-group-item">
                                                    <i class="ti ti-user fs-sm me-2 text-muted"></i>
                                                    Quality Assurance
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card-body -->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row -->
                </div>

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- sortablejs -->
        <script src="/plugins/sortablejs/Sortable.min.js"></script>
        <!-- nestable init js -->
        <script src="/js/pages/plugins-nestable.js"></script>
    </body>
</html>
