<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Bootstrap Tables')) ?>

        <!-- Bootstrap Tables CSS -->
        <link href="/plugins/bootstrap-table/bootstrap-table.min.css" rel="stylesheet" type="text/css" />

        <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Tables', 'title' => 'Bootstrap Table')) ?>

                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-warning alert-dismissible fade show" role="alert">
                                <strong>Note:</strong>
                                This is a jQuery-based plugin, so you need to include jQuery for it to work.
                                <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button"></button>
                            </div>
                            <div class="card">
                                <div class="card-header justify-content-between">
                                    <h4 class="card-title">Example</h4>
                                    <a class="icon-link icon-link-hover link-secondary link-underline-secondarlink-secondary link-underline-opacity-25 fw-semibold" href="https://bootstrap-table.com/" target="_blank">
                                        View Docs
                                        <i class="ti ti-arrow-right bi align-middle fs-lg"></i>
                                    </a>
                                </div>
                                <div class="card-body py-0">
                                    <div class="table-responsive">
                                        <table class="table align-middle mb-0" data-pagination="true" data-search="true" data-show-columns="true" data-toggle="table" id="productTable">
                                            <thead class="fs-xs">
                                                <tr>
                                                    <!-- only use data-checkbox="true", no formatter -->
                                                    <th data-checkbox="true" data-field="state"></th>
                                                    <th data-field="product" data-sortable="true">Product Name</th>
                                                    <th data-field="category" data-sortable="true">Category</th>
                                                    <th data-field="price" data-sortable="true">Price</th>
                                                    <th data-field="stock" data-sortable="true">Stock</th>
                                                    <th data-field="rating" data-sortable="true">Rating</th>
                                                    <th data-field="status" data-sortable="true">Status</th>
                                                    <th data-field="actions">Actions</th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                    </div>
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>

        <!-- Jquery Required for Bootstrap Table-->
        <script src="/plugins/jquery/jquery.min.js"></script>
        <!-- Bootstrap Table JS-->
        <script src="/plugins/bootstrap-table/bootstrap-table.min.js"></script>
        <!-- Page js -->
        <script src="/js/pages/bootstrap-table.js"></script>
    </body>
</html>
