<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Bootstrap Toasts')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'UI', 'title' => 'Notifications')) ?>

                    <div class="row">
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-header">
                                    <div class="flex-grow-1">
                                        <h4 class="card-title">Basic</h4>
                                    </div>
                                    <div class="card-action">
                                        <a class="card-action-item" data-action="card-toggle" href="#!">
                                            <i class="ti ti-chevron-up align-middle"></i>
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <p class="text-muted">Toasts are as flexible as you need and have very little required markup. At a minimum, we require a single element to contain your “toasted” content and strongly encourage a dismiss button.</p>
                                    <div class="p-3">
                                        <!-- Basic -->
                                        <div aria-atomic="true" aria-live="assertive" class="toast fade show" role="alert">
                                            <div class="toast-header">
                                                <img alt="brand-logo" class="me-1" height="16" src="/images/logo-sm.png" />
                                                <strong class="me-auto fw-bold text-body">BRAND</strong>
                                                <small>11 mins ago</small>
                                                <button aria-label="Close" class="ms-2 btn-close" data-bs-dismiss="toast" type="button"></button>
                                            </div>
                                            <div class="toast-body">Hello, world! This is a toast message.</div>
                                        </div>
                                        <!--end toast-->
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card-->
                            <div class="card">
                                <div class="card-header">
                                    <div class="flex-grow-1">
                                        <h4 class="card-title">Placement</h4>
                                    </div>
                                    <div class="card-action">
                                        <a class="card-action-item" data-action="card-toggle" href="#!">
                                            <i class="ti ti-chevron-up align-middle"></i>
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <p class="text-muted">
                                        Place toasts with custom CSS as you need them. The top right is often used for notifications, as is the top middle. If you’re only ever going to show one toast at a time, put the positioning styles right on the
                                        <code>.toast</code>
                                        .
                                    </p>
                                    <div class="p-3">
                                        <div aria-atomic="true" aria-live="polite" class="d-flex justify-content-center align-items-center" style="min-height: 200px">
                                            <!-- Then put toasts within -->
                                            <div aria-atomic="true" aria-live="assertive" class="toast fade show" data-bs-toggle="toast" role="alert">
                                                <div class="toast-header">
                                                    <img alt="brand-logo" class="me-1" height="16" src="/images/logo-sm.png" />
                                                    <strong class="me-auto fw-bold text-body">BRAND</strong>
                                                    <small>11 mins ago</small>
                                                    <button aria-label="Close" class="ms-2 btn-close" data-bs-dismiss="toast" type="button"></button>
                                                </div>
                                                <div class="toast-body">Hello, world! This is a toast message.</div>
                                            </div>
                                            <!--end toast-->
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card-->
                            <div class="card">
                                <div class="card-header">
                                    <div class="flex-grow-1">
                                        <h4 class="card-title">Placement</h4>
                                    </div>
                                    <div class="card-action">
                                        <a class="card-action-item" data-action="card-toggle" href="#!">
                                            <i class="ti ti-chevron-up align-middle"></i>
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <p class="text-muted">
                                        Place toasts with custom CSS as you need them. The top right is often used for notifications, as is the top middle. If you’re only ever going to show one toast at a time, put the positioning styles right on the
                                        <code>.toast</code>
                                        .
                                    </p>
                                    <form>
                                        <div class="mb-3">
                                            <label for="selectToastPlacement">Toast placement</label>
                                            <select class="form-select mt-2" id="selectToastPlacement">
                                                <option selected="" value="">Select a position...</option>
                                                <option value="top-0 start-0">Top left</option>
                                                <option value="top-0 start-50 translate-middle-x">Top center</option>
                                                <option value="top-0 end-0">Top right</option>
                                                <option value="top-50 start-0 translate-middle-y">Middle left</option>
                                                <option value="top-50 start-50 translate-middle">Middle center</option>
                                                <option value="top-50 end-0 translate-middle-y">Middle right</option>
                                                <option value="bottom-0 start-0">Bottom left</option>
                                                <option value="bottom-0 start-50 translate-middle-x">Bottom center</option>
                                                <option value="bottom-0 end-0">Bottom right</option>
                                            </select>
                                        </div>
                                    </form>
                                    <div aria-atomic="true" aria-live="polite" class="bg-light position-relative bd-example-toasts" style="min-height: 294px">
                                        <div class="toast-container position-absolute p-3" id="toastPlacement">
                                            <div class="toast show">
                                                <div class="toast-header">
                                                    <img alt="brand-logo" class="me-1" height="16" src="/images/logo-sm.png" />
                                                    <strong class="me-auto fw-bold text-body">BRAND</strong>
                                                    <small>11 mins ago</small>
                                                </div>
                                                <div class="toast-body">Hello, world! This is a toast message.</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body -->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                        <div class="col-lg-6">
                            <div class="card">
                                <div class="card-header">
                                    <div class="flex-grow-1">
                                        <h4 class="card-title">Live Toast</h4>
                                    </div>
                                    <div class="card-action">
                                        <a class="card-action-item" data-action="card-toggle" href="#!">
                                            <i class="ti ti-chevron-up align-middle"></i>
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <p class="text-muted">Click the button below to show a toast (positioned with our utilities in the Toop Right corner) that has been hidden by default.</p>
                                    <button class="btn btn-primary" id="liveToastBtn" type="button">Show live toast</button>
                                    <div class="toast-container position-fixed top-0 end-0 p-3">
                                        <div aria-atomic="true" aria-live="assertive" class="toast" id="liveToast" role="alert">
                                            <div class="toast-header">
                                                <img alt="brand-logo" class="me-1" height="16" src="/images/logo-sm.png" />
                                                <strong class="me-auto fw-bold text-body">Chebs</strong>
                                                <small>11 mins ago</small>
                                                <button aria-label="Close" class="btn-close" data-bs-dismiss="toast" type="button"></button>
                                            </div>
                                            <div class="toast-body">Hello, world! This is a toast message.</div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card-->
                            <div class="card">
                                <div class="card-header">
                                    <div class="flex-grow-1">
                                        <h4 class="card-title">Translucent</h4>
                                    </div>
                                    <div class="card-action">
                                        <a class="card-action-item" data-action="card-toggle" href="#!">
                                            <i class="ti ti-chevron-up align-middle"></i>
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <p class="text-muted">Toasts are slightly translucent, too, so they blend over whatever they might appear over. For browsers that support the backdrop-filter CSS property, we’ll also attempt to blur the elements under a toast.</p>
                                    <div class="p-3 bg-light bg-opacity-50">
                                        <!-- Translucent -->
                                        <div aria-atomic="true" aria-live="assertive" class="toast fade show" role="alert">
                                            <div class="toast-header">
                                                <img alt="brand-logo" class="me-1" height="16" src="/images/logo-sm.png" />
                                                <strong class="me-auto fw-bold text-body">BRAND</strong>
                                                <small>11 mins ago</small>
                                                <button aria-label="Close" class="ms-2 btn-close" data-bs-dismiss="toast" type="button"></button>
                                            </div>
                                            <div class="toast-body">Hello, world! This is a toast message.</div>
                                        </div>
                                        <!--end toast-->
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card-->
                            <div class="card">
                                <div class="card-header">
                                    <div class="flex-grow-1">
                                        <h4 class="card-title">Stacking</h4>
                                    </div>
                                    <div class="card-action">
                                        <a class="card-action-item" data-action="card-toggle" href="#!">
                                            <i class="ti ti-chevron-up align-middle"></i>
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <p class="text-muted">When you have multiple toasts, we default to vertiaclly stacking them in a readable manner.</p>
                                    <div class="p-3">
                                        <div aria-atomic="true" aria-live="polite" style="position: relative; min-height: 200px">
                                            <!-- Position it -->
                                            <div class="toast-container" style="position: absolute; top: 0; right: 0">
                                                <!-- Then put toasts within -->
                                                <div aria-atomic="true" aria-live="assertive" class="toast fade show" role="alert">
                                                    <div class="toast-header">
                                                        <img alt="brand-logo" class="me-1" height="16" src="/images/logo-sm.png" />
                                                        <strong class="me-auto fw-bold text-body">BRAND</strong>
                                                        <small class="text-muted">just now</small>
                                                        <button aria-label="Close" class="ms-2 btn-close" data-bs-dismiss="toast" type="button"></button>
                                                    </div>
                                                    <div class="toast-body">See? Just like this.</div>
                                                </div>
                                                <!--end toast-->
                                                <div aria-atomic="true" aria-live="assertive" class="toast fade show" role="alert">
                                                    <div class="toast-header">
                                                        <img alt="brand-logo" class="me-1" height="16" src="/images/logo-sm.png" />
                                                        <strong class="me-auto fw-bold text-body">BRAND</strong>
                                                        <small class="text-muted">2 seconds ago</small>
                                                        <button aria-label="Close" class="ms-2 btn-close" data-bs-dismiss="toast" type="button"></button>
                                                    </div>
                                                    <div class="toast-body">Heads up, toasts will stack automatically</div>
                                                </div>
                                                <!--end toast-->
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body-->
                            </div>
                            <!-- end card-->
                            <div class="card">
                                <div class="card-header">
                                    <div class="flex-grow-1">
                                        <h4 class="card-title">Custom content</h4>
                                    </div>
                                    <div class="card-action">
                                        <a class="card-action-item" data-action="card-toggle" href="#!">
                                            <i class="ti ti-chevron-up align-middle"></i>
                                        </a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div aria-atomic="true" aria-live="assertive" class="toast show align-items-center mb-2" role="alert">
                                        <div class="d-flex">
                                            <div class="toast-body">Hello, world! This is a toast message.</div>
                                            <button aria-label="Close" class="btn-close me-2 m-auto" data-bs-dismiss="toast" type="button"></button>
                                        </div>
                                    </div>
                                    <div aria-atomic="true" aria-live="assertive" class="toast show align-items-center text-white bg-primary border-0 mb-2" role="alert">
                                        <div class="d-flex">
                                            <div class="toast-body">Hello, world! This is a toast message.</div>
                                            <button aria-label="Close" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" type="button"></button>
                                        </div>
                                    </div>
                                    <div aria-atomic="true" aria-live="assertive" class="toast show mb-2" role="alert">
                                        <div class="toast-body">
                                            Hello, world! This is a toast message.
                                            <div class="mt-2 pt-2 border-top">
                                                <button class="btn btn-primary btn-sm" type="button">Take action</button>
                                                <button class="btn btn-secondary btn-sm" data-bs-dismiss="toast" type="button">Close</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card body -->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?>
        <?= $this->include('partials/footer-scripts') ?>

        <!-- Page js -->
        <script src="/js/pages/ui-notifications.js"></script>
    </body>
</html>
