<!doctype html>

<html lang="en">
    <head>
        <?php echo view('partials/title-meta', array('title' => 'Mixed Widgets')) ?> <?= $this->include('partials/head-css') ?>
    </head>
    <body>
        <!-- Begin page -->
        <div class="wrapper">
            <?= $this->include('partials/topbar') ?> <?= $this->include('partials/sidenav') ?>

            <!-- ============================================================== -->
            <!-- Start Main Content -->
            <!-- ============================================================== -->
            <div class="content-page">
                <div class="container-fluid">
                    <?php echo view('partials/page-title', array('subtitle' => 'Widgets', 'title' => 'Mixed')) ?>

                    <div class="row row-cols-1 row-cols-sm-2 row-cols-lg-3 row-cols-xxl-5">
                        <div class="col">
                            <div class="card border-0 rounded-3 text-white" style="background-image: url(/images/stock/small-6.jpg); background-size: cover">
                                <div class="card-body bg-gradient bg-primary bg-opacity-90 rounded-3">
                                    <iconify-icon class="fs-36" icon="solar:wallet-money-bold-duotone"></iconify-icon>
                                    <p class="text-white text-opacity-75 mb-1 text-uppercase">Savings Target</p>
                                    <h3 class="fw-semibold mb-2 fs-20 text-white">Monthly Budget</h3>
                                    <h4 class="fw-medium fs-16 mb-1 text-white">
                                        $
                                        <span data-target="3200">0</span>
                                    </h4>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <div class="col">
                            <div class="card border-0 rounded-3 text-white" style="background-image: url(/images/stock/small-7.jpg); background-size: cover">
                                <div class="card-body bg-gradient bg-secondary bg-opacity-90 rounded-3">
                                    <iconify-icon class="fs-36" icon="solar:airbuds-bold-duotone"></iconify-icon>
                                    <p class="text-white text-opacity-75 mb-1 text-uppercase">Goal</p>
                                    <h3 class="fw-semibold mb-2 fs-20 text-white">Gadgets Upgrade</h3>
                                    <h4 class="fw-medium fs-16 mb-1 text-white">
                                        $
                                        <span data-target="1800">0</span>
                                    </h4>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <div class="col">
                            <div class="card border-0 rounded-3 text-white" style="background-image: url(/images/stock/small-8.jpg); background-size: cover">
                                <div class="card-body bg-gradient bg-warning bg-opacity-90 rounded-3">
                                    <iconify-icon class="fs-36" icon="solar:medal-ribbons-star-bold-duotone"></iconify-icon>
                                    <p class="text-white text-opacity-75 mb-1 text-uppercase">Milestone</p>
                                    <h3 class="fw-semibold mb-2 fs-20 text-white">Career Growth</h3>
                                    <h4 class="fw-medium fs-16 mb-1 text-white">
                                        $
                                        <span data-target="5000">0</span>
                                    </h4>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <div class="col">
                            <div class="card border-0 rounded-3 text-white" style="background-image: url(/images/stock/small-9.jpg); background-size: cover">
                                <div class="card-body bg-gradient bg-danger bg-opacity-90 rounded-3">
                                    <iconify-icon class="fs-36" icon="solar:heart-pulse-bold-duotone"></iconify-icon>
                                    <p class="text-white text-opacity-75 mb-1 text-uppercase">Health Plan</p>
                                    <h3 class="fw-semibold mb-2 fs-20 text-white">Fitness Training</h3>
                                    <h4 class="fw-medium fs-16 mb-1 text-white">
                                        $
                                        <span data-target="2400">0</span>
                                    </h4>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                        <div class="col">
                            <div class="card border-0 rounded-3 text-white" style="background-image: url(/images/stock/small-10.jpg); background-size: cover">
                                <div class="card-body bg-gradient bg-info bg-opacity-90 rounded-3">
                                    <iconify-icon class="fs-36" icon="solar:lightbulb-bolt-bold-duotone"></iconify-icon>
                                    <p class="text-white text-opacity-75 mb-1 text-uppercase">Innovation</p>
                                    <h3 class="fw-semibold mb-2 fs-20 text-white">Startup Idea</h3>
                                    <h4 class="fw-medium fs-16 mb-1 text-white">
                                        $
                                        <span data-target="15000">0</span>
                                    </h4>
                                </div>
                            </div>
                        </div>
                        <!-- end col -->
                    </div>
                    <!-- end row-->
                    <div class="row">
                        <div class="col-xxl-4 col-xl-6">
                            <div class="card card-h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start flex-wrap">
                                        <div>
                                            <h4 class="fs-13 mb-2 fw-bold text-uppercase text-muted">Total Visitors</h4>
                                            <div class="d-flex align-items-center gap-2 mb-2 py-1">
                                                <div class="avatar-md flex-shrink-0">
                                                    <span class="avatar-title text-bg-secondary rounded-circle">
                                                        <i class="ti ti-eye fs-xxl"></i>
                                                    </span>
                                                </div>
                                                <h3 class="mb-0">
                                                    <span data-target="82.3">0</span>
                                                    M
                                                </h3>
                                                <span class="badge fs-13 ms-auto badge-soft-success">
                                                    <i class="ti ti-arrow-up"></i>
                                                    6.84%
                                                </span>
                                            </div>
                                        </div>
                                        <!-- Filter -->
                                        <div class="app-search app-search-sm">
                                            <select class="form-select form-control form-select-sm">
                                                <option value="All">All Time</option>
                                                <option value="today">Today</option>
                                                <option value="last_7_days">Last 7 Days</option>
                                                <option value="last_30_days">Last 30 Days</option>
                                                <option selected="" value="last_90_days">Last 90 Days</option>
                                                <option value="this_month">This Month</option>
                                                <option value="last_month">Last Month</option>
                                            </select>
                                            <i class="ti ti-calendar app-search-icon text-muted"></i>
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-between gap-1">
                                        <div style="width: 69.4%">
                                            <p class="mb-1 mt-2 text-muted text-uppercase fs-13 fw-medium">Mobile Phone</p>
                                            <h3 class="fw-normal mb-2 fs-xl">69.40%</h3>
                                            <div class="progress progress-lg rounded-0 rounded-start mb-1">
                                                <div aria-valuenow="100" class="progress-bar bg-secondary" role="progressbar" style="width: 100%"></div>
                                            </div>
                                            <p class="text-muted mb-0">41,927 Sessions</p>
                                        </div>
                                        <div style="width: 30.6%">
                                            <p class="mb-1 mt-2 text-muted text-uppercase fs-13 fw-medium">Desktop</p>
                                            <h3 class="fw-normal mb-2 fs-xl">30.60%</h3>
                                            <div class="progress progress-lg rounded-0 rounded-end mb-1">
                                                <div aria-valuenow="100" class="progress-bar bg-info" role="progressbar" style="width: 100%"></div>
                                            </div>
                                            <p class="text-muted mb-0">18,476 Sessions</p>
                                        </div>
                                    </div>
                                    <div class="table-responsive mb-n2 mt-3">
                                        <table class="table table-sm table-nowrap table-borderless table-centered mb-0">
                                            <thead class="bg-light bg-opacity-50 thead-sm">
                                                <tr class="text-uppercase fs-xxs">
                                                    <th>Goal</th>
                                                    <th>Completed</th>
                                                    <th>Target</th>
                                                    <th>Progress</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>Total Visitors</td>
                                                    <td>824,300</td>
                                                    <td>1,000,000</td>
                                                    <td>82%</td>
                                                </tr>
                                                <tr>
                                                    <td>Mobile Traffic</td>
                                                    <td>41,927</td>
                                                    <td>60,000</td>
                                                    <td>69%</td>
                                                </tr>
                                                <tr>
                                                    <td>Desktop Traffic</td>
                                                    <td>18,476</td>
                                                    <td>30,000</td>
                                                    <td>61%</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                        <div class="col-xxl-4 col-xl-6">
                            <div class="card card-h-100">
                                <div class="card-body">
                                    <div class="d-flex justify-content-between align-items-start flex-wrap">
                                        <div>
                                            <h4 class="fs-13 mb-2 fw-bold text-uppercase text-muted">Total Subscribers</h4>
                                            <div class="d-flex align-items-center gap-2 mb-2 py-1">
                                                <div class="avatar-md flex-shrink-0">
                                                    <span class="avatar-title text-bg-info rounded-circle">
                                                        <i class="ti ti-mail fs-xxl"></i>
                                                    </span>
                                                </div>
                                                <h3 class="mb-0">
                                                    <span data-target="55.6">0</span>
                                                    k
                                                </h3>
                                                <span class="badge fs-13 ms-auto badge-soft-success">
                                                    <i class="ti ti-arrow-up"></i>
                                                    4.87%
                                                </span>
                                            </div>
                                        </div>
                                        <!-- Filter -->
                                        <div class="app-search app-search-sm">
                                            <select class="form-select form-control form-select-sm">
                                                <option value="All">All Time</option>
                                                <option value="today">Today</option>
                                                <option value="last_7_days">Last 7 Days</option>
                                                <option value="last_30_days">Last 30 Days</option>
                                                <option selected="" value="last_90_days">Last 90 Days</option>
                                                <option value="this_month">This Month</option>
                                                <option value="last_month">Last Month</option>
                                            </select>
                                            <i class="ti ti-calendar app-search-icon text-muted"></i>
                                        </div>
                                    </div>
                                    <!-- Email Marketing -->
                                    <div class="mt-2 pt-1">
                                        <div class="d-flex justify-content-between">
                                            <h5 class="fs-base mb-2">Email Marketing</h5>
                                            <div>
                                                <span>
                                                    +
                                                    <span data-target="34,920">0</span>
                                                </span>
                                                <span>
                                                    <i class="ti ti-circle-filled text-light mx-3 fs-10"></i>
                                                    27.41%
                                                </span>
                                            </div>
                                        </div>
                                        <div class="progress progress-sm mb-1">
                                            <div aria-valuemax="100" aria-valuemin="0" aria-valuenow="27.41" class="progress-bar bg-secondary" role="progressbar" style="width: 27.41%"></div>
                                        </div>
                                    </div>
                                    <!-- Social Marketing -->
                                    <div class="mt-3">
                                        <div class="d-flex justify-content-between">
                                            <h5 class="fs-base mb-2">Social Marketing</h5>
                                            <div>
                                                <span>
                                                    +
                                                    <span data-target="58,775">0</span>
                                                </span>
                                                <span>
                                                    <i class="ti ti-circle-filled text-light mx-3 fs-10"></i>
                                                    46.13%
                                                </span>
                                            </div>
                                        </div>
                                        <div class="progress progress-sm mb-1">
                                            <div aria-valuemax="100" aria-valuemin="0" aria-valuenow="46.13" class="progress-bar bg-info" role="progressbar" style="width: 46.13%"></div>
                                        </div>
                                    </div>
                                    <!-- Direct -->
                                    <div class="mt-3">
                                        <div class="d-flex justify-content-between">
                                            <h5 class="fs-base mb-2">Direct</h5>
                                            <div>
                                                <span>
                                                    +
                                                    <span data-target="33,645">0</span>
                                                </span>
                                                <span>
                                                    <i class="ti ti-circle-filled text-light mx-3 fs-10"></i>
                                                    26.46%
                                                </span>
                                            </div>
                                        </div>
                                        <div class="progress progress-sm mb-1">
                                            <div aria-valuemax="100" aria-valuemin="0" aria-valuenow="26.46" class="progress-bar bg-success" role="progressbar" style="width: 26.46%"></div>
                                        </div>
                                    </div>
                                    <!-- Milestone Card -->
                                    <div class="p-2 mt-3 border-dashed border rounded">
                                        <div class="d-flex align-items-center">
                                            <div class="avatar-xl flex-shrink-0 me-2">
                                                <span class="avatar-title bg-warning-subtle rounded-circle fs-1">
                                                    <i class="ti ti-medal text-warning"></i>
                                                </span>
                                            </div>
                                            <div class="flex-gow-1">
                                                <h5 class="mb-0 fw-semibold">Congratulations !...</h5>
                                                <p class="mb-0 text-muted">You've reached a new subscriber milestone.</p>
                                            </div>
                                            <div class="ms-auto">
                                                <h4 class="fs-16 mt-1 mb-0">29.4k</h4>
                                                <span class="text-muted fw-semibold fs-12">SUBSCRIBERS</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                        <div class="col-xxl-4">
                            <div class="card">
                                <div class="card-header justify-content-between">
                                    <h4 class="card-title">
                                        Top Traffic Sources
                                        <span data-bs-placement="top" data-bs-title="Shows which channels drive the most traffic." data-bs-toggle="tooltip"><i class="ti ti-info-circle text-muted ms-1"></i></span>
                                    </h4>
                                    <div class="dropdown ms-auto">
                                        <a class="btn btn-sm btn-default btn-icon" data-bs-toggle="dropdown" href="#">
                                            <i class="ti ti-dots-vertical fs-lg"></i>
                                        </a>
                                        <ul class="dropdown-menu dropdown-menu-end">
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-chart-bar me-2"></i>
                                                    View Detailed Report
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-download me-2"></i>
                                                    Export Traffic Data
                                                </a>
                                            </li>
                                            <li>
                                                <a class="dropdown-item" href="#">
                                                    <i class="ti ti-filter-2 me-2"></i>
                                                    Filter by Source
                                                </a>
                                            </li>
                                            <li>
                                                <hr class="dropdown-divider" />
                                            </li>
                                            <li>
                                                <a class="dropdown-item text-danger" href="#">
                                                    <i class="ti ti-trash me-2"></i>
                                                    Remove Widget
                                                </a>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col">
                                            <div class="custom-progress mb-3">
                                                <div class="progress-info d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <img alt="user-image" class="me-1" height="24" src="/images/logos/google.svg" />
                                                        <span class="align-middle fw-semibold fs-md">Google</span>
                                                    </div>
                                                    <span class="fw-semibold text-muted float-end">87.8k</span>
                                                </div>
                                                <div class="progress-data bg-warning" style="width: 72%"></div>
                                            </div>
                                            <div class="custom-progress mb-3">
                                                <div class="progress-info d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <img alt="user-image" class="me-1" height="24" src="/images/logos/instagram.svg" />
                                                        <span class="align-middle fw-semibold fs-md">Instagram</span>
                                                    </div>
                                                    <span class="fw-semibold text-muted float-end">42.9k</span>
                                                </div>
                                                <div class="progress-data bg-danger" style="width: 30%"></div>
                                            </div>
                                            <div class="custom-progress mb-3">
                                                <div class="progress-info d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <img alt="user-image" class="me-1" height="20" src="/images/logos/linkedin.svg" />
                                                        <span class="align-middle fw-semibold fs-md">LinkedIn</span>
                                                    </div>
                                                    <span class="fw-semibold text-muted float-end">58.5k</span>
                                                </div>
                                                <div class="progress-data bg-info" style="width: 43%"></div>
                                            </div>
                                            <div class="custom-progress mb-3">
                                                <div class="progress-info d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <img alt="user-image" class="me-1" height="24" src="/images/logos/dribbble.svg" />
                                                        <span class="align-middle fw-semibold fs-md">Dribbble</span>
                                                    </div>
                                                    <span class="fw-semibold text-muted float-end">2.85k</span>
                                                </div>
                                                <div class="progress-data bg-secondary" style="width: 12%"></div>
                                            </div>
                                            <div class="custom-progress">
                                                <div class="progress-info d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <img alt="user-image" class="me-1" height="24" src="/images/logos/messenger.svg" />
                                                        <span class="align-middle fw-semibold fs-md">Messenger</span>
                                                    </div>
                                                    <span class="fw-semibold text-muted float-end">9.08k</span>
                                                </div>
                                                <div class="progress-data bg-primary" style="width: 18%"></div>
                                            </div>
                                        </div>
                                        <div class="col">
                                            <div class="custom-progress mb-3">
                                                <div class="progress-info d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <img alt="user-image" class="me-1" height="18" src="/images/logos/meta.svg" />
                                                        <span class="align-middle fw-semibold fs-md">Meta</span>
                                                    </div>
                                                    <span class="fw-semibold text-muted float-end">77.7k</span>
                                                </div>
                                                <div class="progress-data bg-primary" style="width: 66%"></div>
                                            </div>
                                            <div class="custom-progress mb-3">
                                                <div class="progress-info d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <img alt="user-image" class="me-1" height="24" src="/images/logos/telegram.svg" />
                                                        <span class="align-middle fw-semibold fs-md">Telegram</span>
                                                    </div>
                                                    <span class="fw-semibold text-muted float-end">31.5k</span>
                                                </div>
                                                <div class="progress-data bg-success" style="width: 46%"></div>
                                            </div>
                                            <div class="custom-progress mb-3">
                                                <div class="progress-info d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <img alt="user-image" class="me-1" height="16" src="/images/logos/x.svg" />
                                                        <span class="align-middle fw-semibold fs-md">Twitter X</span>
                                                    </div>
                                                    <span class="fw-semibold text-muted float-end">22.6k</span>
                                                </div>
                                                <div class="progress-data bg-dark" style="width: 29%"></div>
                                            </div>
                                            <div class="custom-progress mb-3">
                                                <div class="progress-info d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <img alt="user-image" class="me-1" height="24" src="/images/logos/whatsapp.svg" />
                                                        <span class="align-middle fw-semibold fs-md">WhatsApp</span>
                                                    </div>
                                                    <span class="fw-semibold text-muted float-end">3.1k</span>
                                                </div>
                                                <div class="progress-data bg-danger" style="width: 18%"></div>
                                            </div>
                                            <div class="custom-progress">
                                                <div class="progress-info d-flex justify-content-between align-items-center">
                                                    <div>
                                                        <img alt="user-image" class="me-1" height="28" src="/images/logos/snapchat.svg" />
                                                        <span class="align-middle fw-semibold fs-md">Snapchat</span>
                                                    </div>
                                                    <span class="fw-semibold text-muted float-end">5.8k</span>
                                                </div>
                                                <div class="progress-data bg-warning" style="width: 9%"></div>
                                            </div>
                                        </div>
                                        <!-- end col-->
                                    </div>
                                    <!-- end row-->
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card -->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                    <div class="row">
                        <!-- Card 1 -->
                        <div class="col-xl-4">
                            <div class="card bg-success bg-gradient border-0">
                                <div class="card-body" style="background-image: url(/images/flower-style.svg); background-size: contain; background-repeat: no-repeat; background-position: right bottom">
                                    <h4 class="text-white">Revenue Overview</h4>
                                    <p class="text-white text-opacity-75">Get a quick snapshot of your company’s financial performance.</p>
                                    <div class="d-flex gap-1">
                                        <a class="btn btn-sm btn-success bg-white bg-opacity-10" href="#!">
                                            <i class="ti ti-chart-bar me-1"></i>
                                            Report
                                        </a>
                                        <a class="btn btn-sm btn-success bg-white bg-opacity-10" href="#!">
                                            <i class="ti ti-phone"></i>
                                        </a>
                                        <a class="btn btn-sm btn-success bg-white bg-opacity-10" href="#!" target="_blank">
                                            <i class="ti ti-world"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Card 2 -->
                        <div class="col-xl-4">
                            <div class="card bg-info bg-gradient border-0">
                                <div class="card-body" style="background-image: url(/images/flower-style.svg); background-size: contain; background-repeat: no-repeat; background-position: right bottom">
                                    <h4 class="text-white">Customer Insights</h4>
                                    <p class="text-white text-opacity-75">Analyze customer behavior and discover actionable trends.</p>
                                    <div class="d-flex gap-2">
                                        <a class="btn btn-sm btn-info bg-white bg-opacity-10" href="#!">
                                            <i class="ti ti-users me-1"></i>
                                            Insights
                                        </a>
                                        <a class="btn btn-sm btn-info bg-white bg-opacity-10" href="#!">
                                            <i class="ti ti-mail"></i>
                                        </a>
                                        <a class="btn btn-sm btn-info bg-white bg-opacity-10" href="#!">
                                            <i class="ti ti-message-circle"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Card 3 -->
                        <div class="col-xl-4">
                            <div class="card bg-danger bg-gradient border-0">
                                <div class="card-body" style="background-image: url(/images/flower-style.svg); background-size: contain; background-repeat: no-repeat; background-position: right bottom">
                                    <h4 class="text-white">Performance Alerts</h4>
                                    <p class="text-white text-opacity-75">Stay informed with real-time alerts for key business indicators.</p>
                                    <div class="d-flex gap-2">
                                        <a class="btn btn-sm btn-danger bg-white bg-opacity-10" href="#!">
                                            <i class="ti ti-bell me-1"></i>
                                            Alerts
                                        </a>
                                        <a class="btn btn-sm btn-danger bg-white bg-opacity-10" href="#!">
                                            <i class="ti ti-share"></i>
                                        </a>
                                        <a class="btn btn-sm btn-danger bg-white bg-opacity-10" href="#!">
                                            <i class="ti ti-layout-dashboard"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- end row-->
                    <div class="row">
                        <div class="col-md-6 col-xxl-3">
                            <div class="card card-h-100">
                                <div class="card-body">
                                    <div class="d-flex align-items-center mb-4">
                                        <div class="me-3 position-relative">
                                            <img alt="avatar" class="rounded-circle" height="72" src="/images/users/user-5.jpg" width="72" />
                                            <span class="position-absolute bottom-0 end-0 badge bg-warning rounded-circle p-1 shadow-sm" title="Rating 4.8">
                                                <i class="ti ti-star text-white"></i>
                                            </span>
                                        </div>
                                        <div>
                                            <h5 class="mb-1 d-flex align-items-center">
                                                <a class="link-reset" href="#!">Sophia Carter</a>
                                                <img alt="UK" class="ms-2 rounded-circle" height="16" src="/images/flags/gb.svg" />
                                            </h5>
                                            <p class="text-muted mb-1">Lead UI/UX Designer</p>
                                            <span class="badge text-bg-light badge-label">Admin</span>
                                        </div>
                                        <div class="ms-auto">
                                            <div class="dropdown">
                                                <a class="btn btn-icon btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                    <i class="ti ti-dots-vertical fs-xl"></i>
                                                </a>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-share me-2"></i>
                                                            Share
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-edit me-2"></i>
                                                            Edit
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-ban me-2"></i>
                                                            Block
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item text-danger" href="#">
                                                            <i class="ti ti-trash me-2"></i>
                                                            Delete
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <ul class="list-unstyled text-muted mb-4">
                                        <li class="mb-2">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-mail"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">
                                                    <a class="link-reset" href="#">sophia@designhub.com</a>
                                                </h5>
                                            </div>
                                        </li>
                                        <li class="mb-2">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-phone"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">
                                                    <a class="link-reset" href="#">+44 7911 123456</a>
                                                </h5>
                                            </div>
                                        </li>
                                        <li class="mb-2">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-map-pin"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">London, UK</h5>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-link"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">
                                                    <a href="#">www.sophiacarter.com</a>
                                                </h5>
                                            </div>
                                        </li>
                                    </ul>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="text-muted fs-xs">
                                            <i class="ti ti-refresh me-1"></i>
                                            Updated 30 min ago
                                        </span>
                                        <a class="btn btn-soft-primary btn-sm rounded-pill" href="#!">View Profile</a>
                                    </div>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                        <!-- Card 2 -->
                        <div class="col-md-6 col-xxl-3">
                            <div class="card card-h-100">
                                <div class="card-body">
                                    <div class="d-flex align-items-center mb-4">
                                        <div class="me-3 position-relative">
                                            <img alt="avatar" class="rounded-circle" height="72" src="/images/users/user-6.jpg" width="72" />
                                            <span class="position-absolute bottom-0 end-0 badge bg-success rounded-circle p-1 shadow-sm" title="Rating 4.5">
                                                <i class="ti ti-star text-white"></i>
                                            </span>
                                        </div>
                                        <div>
                                            <h5 class="mb-1 d-flex align-items-center">
                                                <a class="link-reset" href="#!">Marcus Lee</a>
                                                <img alt="US" class="ms-2 rounded-circle" height="16" src="/images/flags/us.svg" />
                                            </h5>
                                            <p class="text-muted mb-1">Senior Developer</p>
                                            <span class="badge text-bg-light badge-label">Team Lead</span>
                                        </div>
                                        <div class="ms-auto">
                                            <div class="dropdown">
                                                <a class="btn btn-icon btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                    <i class="ti ti-dots-vertical fs-xl"></i>
                                                </a>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-share me-2"></i>
                                                            Share
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-edit me-2"></i>
                                                            Edit
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-ban me-2"></i>
                                                            Block
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item text-danger" href="#">
                                                            <i class="ti ti-trash me-2"></i>
                                                            Delete
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <ul class="list-unstyled text-muted mb-4">
                                        <li class="mb-2">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-mail"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">
                                                    <a class="link-reset" href="#">marcus@devhub.com</a>
                                                </h5>
                                            </div>
                                        </li>
                                        <li class="mb-2">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-phone"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">
                                                    <a class="link-reset" href="#">+1 408-222-9876</a>
                                                </h5>
                                            </div>
                                        </li>
                                        <li class="mb-2">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-map-pin"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">Austin, TX</h5>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-link"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">
                                                    <a href="#">www.devhub.com</a>
                                                </h5>
                                            </div>
                                        </li>
                                    </ul>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="text-muted fs-xs">
                                            <i class="ti ti-refresh me-1"></i>
                                            Updated 1 hour ago
                                        </span>
                                        <a class="btn btn-soft-primary btn-sm rounded-pill" href="#!">View Profile</a>
                                    </div>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                        <!-- Card 3 -->
                        <div class="col-md-6 col-xxl-3">
                            <div class="card card-h-100">
                                <div class="card-body">
                                    <div class="d-flex align-items-center mb-4">
                                        <div class="me-3 position-relative">
                                            <img alt="avatar" class="rounded-circle" height="72" src="/images/users/user-7.jpg" width="72" />
                                            <span class="position-absolute bottom-0 end-0 badge bg-danger rounded-circle p-1 shadow-sm" title="Rating 3.9">
                                                <i class="ti ti-star text-white"></i>
                                            </span>
                                        </div>
                                        <div>
                                            <h5 class="mb-1">
                                                <a class="link-reset" href="#!">Emily Davis</a>
                                                <img alt="US" class="ms-2 rounded-circle" height="16" src="/images/flags/us.svg" />
                                            </h5>
                                            <p class="text-muted mb-1">Marketing Strategist</p>
                                            <span class="badge text-bg-light badge-label">Member</span>
                                        </div>
                                        <div class="ms-auto">
                                            <div class="dropdown">
                                                <a class="btn btn-icon btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                    <i class="ti ti-dots-vertical fs-xl"></i>
                                                </a>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-share me-2"></i>
                                                            Share
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-edit me-2"></i>
                                                            Edit
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-ban me-2"></i>
                                                            Block
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item text-danger" href="#">
                                                            <i class="ti ti-trash me-2"></i>
                                                            Delete
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <ul class="list-unstyled text-muted mb-4">
                                        <li class="mb-2">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-mail"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">
                                                    <a class="link-reset" href="#">emily@marketboost.com</a>
                                                </h5>
                                            </div>
                                        </li>
                                        <li class="mb-2">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-phone"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">
                                                    <a class="link-reset" href="#">+1 212-555-7890</a>
                                                </h5>
                                            </div>
                                        </li>
                                        <li class="mb-2">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-map-pin"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">New York, NY</h5>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-link"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">
                                                    <a href="#">www.marketboost.com</a>
                                                </h5>
                                            </div>
                                        </li>
                                    </ul>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="text-muted fs-xs">
                                            <i class="ti ti-refresh me-1"></i>
                                            Updated 10 min ago
                                        </span>
                                        <a class="btn btn-soft-primary btn-sm rounded-pill" href="#!">View Profile</a>
                                    </div>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                        <!-- Card 4 -->
                        <div class="col-md-6 col-xxl-3">
                            <div class="card card-h-100">
                                <div class="card-body">
                                    <div class="d-flex align-items-center mb-4">
                                        <div class="me-3 position-relative">
                                            <img alt="avatar" class="rounded-circle" height="72" src="/images/users/user-8.jpg" width="72" />
                                            <span class="position-absolute bottom-0 end-0 badge bg-info rounded-circle p-1 shadow-sm" title="Rating 4.3">
                                                <i class="ti ti-star text-white"></i>
                                            </span>
                                        </div>
                                        <div>
                                            <h5 class="mb-1">
                                                <a class="link-reset" href="#!">Daniel Smith</a>
                                                <img alt="US" class="ms-2 rounded-circle" height="16" src="/images/flags/ca.svg" />
                                            </h5>
                                            <p class="text-muted mb-1">Data Analyst</p>
                                            <span class="badge text-bg-light badge-label">Contributor</span>
                                        </div>
                                        <div class="ms-auto">
                                            <div class="dropdown">
                                                <a class="btn btn-icon btn-ghost-light text-muted" data-bs-toggle="dropdown" href="#">
                                                    <i class="ti ti-dots-vertical fs-xl"></i>
                                                </a>
                                                <ul class="dropdown-menu dropdown-menu-end">
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-share me-2"></i>
                                                            Share
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-edit me-2"></i>
                                                            Edit
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#">
                                                            <i class="ti ti-ban me-2"></i>
                                                            Block
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item text-danger" href="#">
                                                            <i class="ti ti-trash me-2"></i>
                                                            Delete
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <ul class="list-unstyled text-muted mb-4">
                                        <li class="mb-2">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-mail"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">
                                                    <a class="link-reset" href="#">daniel@analyticspro.io</a>
                                                </h5>
                                            </div>
                                        </li>
                                        <li class="mb-2">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-phone"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">
                                                    <a class="link-reset" href="#">+1 987-654-3210</a>
                                                </h5>
                                            </div>
                                        </li>
                                        <li class="mb-2">
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-map-pin"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">Toronto, Canada</h5>
                                            </div>
                                        </li>
                                        <li>
                                            <div class="d-flex align-items-center gap-2">
                                                <div class="avatar-xs avatar-img-size fs-24">
                                                    <span class="avatar-title text-bg-light fs-sm rounded-circle">
                                                        <i class="ti ti-link"></i>
                                                    </span>
                                                </div>
                                                <h5 class="fs-base mb-0 fw-medium">
                                                    <a href="#">www.analyticspro.io</a>
                                                </h5>
                                            </div>
                                        </li>
                                    </ul>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="text-muted fs-xs">
                                            <i class="ti ti-refresh me-1"></i>
                                            Updated 45 min ago
                                        </span>
                                        <a class="btn btn-soft-primary btn-sm rounded-pill" href="#!">View Profile</a>
                                    </div>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!--end row-->
                    <div class="row">
                        <div class="col-xl-4">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Chat</h4>
                                </div>
                                <!-- end card-header-->
                                <div class="card-body py-0" data-simplebar="" id="chat-container" style="height: 360px">
                                    <!-- Message 1 -->
                                    <div class="d-flex align-items-start gap-2 my-3 chat-item">
                                        <img alt="User" class="avatar-md rounded-circle" src="/images/users/user-5.jpg" />
                                        <div>
                                            <div class="chat-message py-2 px-3 bg-warning-subtle rounded">Hey! Are you available for a quick call? 📞</div>
                                            <div class="text-muted fs-xs mt-1">
                                                <i class="ti ti-clock"></i>
                                                08:55 am
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Message 2 -->
                                    <div class="d-flex align-items-start gap-2 my-3 text-end chat-item justify-content-end">
                                        <div>
                                            <div class="chat-message py-2 px-3 bg-info-subtle rounded">Sure, give me 5 minutes. Just wrapping something up.</div>
                                            <div class="text-muted fs-xs mt-1">
                                                <i class="ti ti-clock"></i>
                                                08:57 am
                                            </div>
                                        </div>
                                        <img alt="User" class="avatar-md rounded-circle" src="/images/users/user-2.jpg" />
                                    </div>
                                    <!-- Message 3 -->
                                    <div class="d-flex align-items-start gap-2 my-3 chat-item">
                                        <img alt="User" class="avatar-md rounded-circle" src="/images/users/user-5.jpg" />
                                        <div>
                                            <div class="chat-message py-2 px-3 bg-warning-subtle rounded">Perfect. Let me know when you're ready 👍</div>
                                            <div class="text-muted fs-xs mt-1">
                                                <i class="ti ti-clock"></i>
                                                08:58 am
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Message 4 -->
                                    <div class="d-flex align-items-start gap-2 my-3 text-end chat-item justify-content-end">
                                        <div>
                                            <div class="chat-message py-2 px-3 bg-info-subtle rounded">Ready now. Calling you!</div>
                                            <div class="text-muted fs-xs mt-1">
                                                <i class="ti ti-clock"></i>
                                                09:00 am
                                            </div>
                                        </div>
                                        <img alt="User" class="avatar-md rounded-circle" src="/images/users/user-2.jpg" />
                                    </div>
                                    <!-- Message 5 -->
                                    <div class="d-flex align-items-start gap-2 my-3 chat-item">
                                        <img alt="User" class="avatar-md rounded-circle" src="/images/users/user-5.jpg" />
                                        <div>
                                            <div class="chat-message py-2 px-3 bg-warning-subtle rounded">Thanks for your time earlier!</div>
                                            <div class="text-muted fs-xs mt-1">
                                                <i class="ti ti-clock"></i>
                                                09:45 am
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Message 6 -->
                                    <div class="d-flex align-items-start gap-2 my-3 text-end chat-item justify-content-end">
                                        <div>
                                            <div class="chat-message py-2 px-3 bg-info-subtle rounded">Of course! It was a productive discussion.</div>
                                            <div class="text-muted fs-xs mt-1">
                                                <i class="ti ti-clock"></i>
                                                09:46 am
                                            </div>
                                        </div>
                                        <img alt="User" class="avatar-md rounded-circle" src="/images/users/user-2.jpg" />
                                    </div>
                                    <!-- Message 7 -->
                                    <div class="d-flex align-items-start gap-2 my-3 chat-item">
                                        <img alt="User" class="avatar-md rounded-circle" src="/images/users/user-5.jpg" />
                                        <div>
                                            <div class="chat-message py-2 px-3 bg-warning-subtle rounded">I’ll send over the updated files by noon.</div>
                                            <div class="text-muted fs-xs mt-1">
                                                <i class="ti ti-clock"></i>
                                                09:50 am
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- end card-body -->
                                <div class="card-footer bg-body-secondary border-top border-dashed border-bottom-0">
                                    <div class="d-flex gap-2">
                                        <div class="app-search flex-grow-1">
                                            <input class="form-control bg-light-subtle border-light" placeholder="Enter message..." type="text" />
                                            <i class="app-search-icon text-muted" data-lucide="message-square"></i>
                                        </div>
                                        <a class="btn btn-primary btn-icon" href="#!"><i class="ti ti-send-2 fs-xl"></i></a>
                                    </div>
                                </div>
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                        <div class="col-xxl-4 col-lg-6">
                            <div class="card">
                                <div class="card-header justify-content-between align-items-center">
                                    <h5 class="card-title">Traffic Sources</h5>
                                    <div class="card-action">
                                        <a class="card-action-item" data-action="card-toggle" href="#!"><i class="ti ti-chevron-up"></i></a>
                                        <a class="card-action-item" data-action="card-refresh" href="#!"><i class="ti ti-refresh"></i></a>
                                        <a class="card-action-item" data-action="card-close" href="#!"><i class="ti ti-x"></i></a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="row mb-2">
                                        <div class="col-lg">
                                            <h3 class="mb-2 fw-bold"><span data-target="8,975">0</span></h3>
                                            <p class="mb-2 fw-semibold text-muted">Right Now</p>
                                        </div>
                                        <!--end col-->
                                        <div class="col-lg-auto align-self-center">
                                            <ul class="list-unstyled mb-0 lh-lg">
                                                <li>
                                                    <i class="ti ti-caret-right-filled fs-lg align-middle text-primary"></i>
                                                    <span class="text-muted">Organic</span>
                                                </li>
                                                <li>
                                                    <i class="ti ti-caret-right-filled fs-lg align-middle text-success"></i>
                                                    <span class="text-muted">Direct</span>
                                                </li>
                                                <li>
                                                    <i class="ti ti-caret-right-filled fs-lg align-middle"></i>
                                                    <span class="text-muted">Campaign</span>
                                                </li>
                                            </ul>
                                        </div>
                                        <!--end col-->
                                    </div>
                                    <!--end row-->
                                    <div class="progress mb-3" style="height: 10px">
                                        <div aria-valuemax="100" aria-valuemin="0" aria-valuenow="25" class="progress-bar" role="progressbar" style="width: 25%"></div>
                                        <div aria-valuemax="100" aria-valuemin="0" aria-valuenow="50" class="progress-bar bg-success" role="progressbar" style="width: 50%"></div>
                                        <div aria-valuemax="100" aria-valuemin="0" aria-valuenow="15" class="progress-bar bg-info" role="progressbar" style="width: 15%"></div>
                                    </div>
                                    <div class="table-responsive">
                                        <table class="table table-sm table-custom table-nowrap table-hover table-centered mb-0">
                                            <thead class="bg-light align-middle bg-opacity-25 thead-sm">
                                                <tr class="text-uppercase fs-xxs">
                                                    <th class="text-muted">URL</th>
                                                    <th class="text-muted text-end">Views</th>
                                                    <th class="text-muted text-end">Uniques</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td class="text-decoration-underline">/dashboard</td>
                                                    <td class="text-end">9.8k</td>
                                                    <td class="text-end">8.5k</td>
                                                </tr>
                                                <tr>
                                                    <td class="text-decoration-underline">/ecommerce-index</td>
                                                    <td class="text-end">8.2k</td>
                                                    <td class="text-end">7.1k</td>
                                                </tr>
                                                <tr>
                                                    <td class="text-decoration-underline">/apps/projects-overview</td>
                                                    <td class="text-end">7.6k</td>
                                                    <td class="text-end">6.2k</td>
                                                </tr>
                                                <tr>
                                                    <td class="text-decoration-underline">/pages/contact</td>
                                                    <td class="text-end">5.9k</td>
                                                    <td class="text-end">4.8k</td>
                                                </tr>
                                                <tr>
                                                    <td class="text-decoration-underline">/support/faq</td>
                                                    <td class="text-end">5.2k</td>
                                                    <td class="text-end">4.3k</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                    <!-- ed .table-responsive-->
                                    <div class="text-center mt-3">
                                        <a class="link-reset text-decoration-underline fw-semibold link-offset-3" href="#!">
                                            View all Links
                                            <i class="ti ti-link"></i>
                                        </a>
                                    </div>
                                </div>
                                <!-- end card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                        <div class="col-xxl-4 col-lg-6">
                            <div class="card">
                                <div class="card-header justify-content-between align-items-center">
                                    <h4 class="card-title">Top Countries</h4>
                                    <div class="card-action">
                                        <a class="card-action-item" data-action="card-toggle" href="#!"><i class="ti ti-chevron-up"></i></a>
                                        <a class="card-action-item" data-action="card-refresh" href="#!"><i class="ti ti-refresh"></i></a>
                                        <a class="card-action-item" data-action="card-close" href="#!"><i class="ti ti-x"></i></a>
                                    </div>
                                </div>
                                <div class="card-body">
                                    <div class="d-flex align-items-center gap-2 mb-3">
                                        <img alt="India" class="avatar-xxs rounded" src="/images/flags/in.svg" />
                                        <h5 class="mb-0 fw-medium">
                                            <a class="link-reset" href="#!">India</a>
                                            <small class="text-muted">Pop: 1.43B</small>
                                        </h5>
                                        <div class="ms-auto">
                                            <div class="d-flex align-items-center gap-3 text-end">
                                                <p class="mb-0 fw-medium">14,217</p>
                                                <p class="badge badge-label fs-xxs badge-soft-success mb-0">+3.2%</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 mb-3">
                                        <img alt="Germany" class="avatar-xxs rounded" src="/images/flags/de.svg" />
                                        <h5 class="mb-0 fw-medium">
                                            <a class="link-reset" href="#!">Germany</a>
                                            <small class="text-muted">Pop: 83.2M</small>
                                        </h5>
                                        <div class="ms-auto">
                                            <div class="d-flex align-items-center gap-3 text-end">
                                                <p class="mb-0 fw-medium">10,412</p>
                                                <p class="badge badge-label fs-xxs badge-soft-success mb-0">+1.5%</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 mb-3">
                                        <img alt="France" class="avatar-xxs rounded" src="/images/flags/fr.svg" />
                                        <h5 class="mb-0 fw-medium">
                                            <a class="link-reset" href="#!">France</a>
                                            <small class="text-muted">Pop: 67.5M</small>
                                        </h5>
                                        <div class="ms-auto">
                                            <div class="d-flex align-items-center gap-3 text-end">
                                                <p class="mb-0 fw-medium">8,934</p>
                                                <p class="badge badge-label fs-xxs badge-soft-danger mb-0">-0.8%</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 mb-3">
                                        <img alt="United States" class="avatar-xxs rounded" src="/images/flags/us.svg" />
                                        <h5 class="mb-0 fw-medium">
                                            <a class="link-reset" href="#!">United States</a>
                                            <small class="text-muted">Pop: 339.9M</small>
                                        </h5>
                                        <div class="ms-auto">
                                            <div class="d-flex align-items-center gap-3 text-end">
                                                <p class="mb-0 fw-medium">18,522</p>
                                                <p class="badge badge-label fs-xxs badge-soft-success mb-0">+2.1%</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 mb-3">
                                        <img alt="United Kingdom" class="avatar-xxs rounded" src="/images/flags/gb.svg" />
                                        <h5 class="mb-0 fw-medium">
                                            <a class="link-reset" href="#!">United Kingdom</a>
                                            <small class="text-muted">Pop: 67.3M</small>
                                        </h5>
                                        <div class="ms-auto">
                                            <div class="d-flex align-items-center gap-3 text-end">
                                                <p class="mb-0 fw-medium">7,614</p>
                                                <p class="badge badge-label fs-xxs badge-soft-danger mb-0">-1.2%</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 mb-3">
                                        <img alt="Canada" class="avatar-xxs rounded" src="/images/flags/ca.svg" />
                                        <h5 class="mb-0 fw-medium">
                                            <a class="link-reset" href="#!">Canada</a>
                                            <small class="text-muted">Pop: 39.6M</small>
                                        </h5>
                                        <div class="ms-auto">
                                            <div class="d-flex align-items-center gap-3 text-end">
                                                <p class="mb-0 fw-medium">6,221</p>
                                                <p class="badge badge-label fs-xxs badge-soft-success mb-0">+0.9%</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 mb-3">
                                        <img alt="Japan" class="avatar-xxs rounded" src="/images/flags/jp.svg" />
                                        <h5 class="mb-0 fw-medium">
                                            <a class="link-reset" href="#!">Japan</a>
                                            <small class="text-muted">Pop: 123.3M</small>
                                        </h5>
                                        <div class="ms-auto">
                                            <div class="d-flex align-items-center gap-3 text-end">
                                                <p class="mb-0 fw-medium">5,785</p>
                                                <p class="badge badge-label fs-xxs badge-soft-warning mb-0">0.0%</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="d-flex align-items-center gap-2 mb-3">
                                        <img alt="Australia" class="avatar-xxs rounded" src="/images/flags/au.svg" />
                                        <h5 class="mb-0 fw-medium">
                                            <a class="link-reset" href="#!">Australia</a>
                                            <small class="text-muted">Pop: 26.8M</small>
                                        </h5>
                                        <div class="ms-auto">
                                            <div class="d-flex align-items-center gap-3 text-end">
                                                <p class="mb-0 fw-medium">4,918</p>
                                                <p class="badge badge-label fs-xxs badge-soft-success mb-0">+1.1%</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="text-center mt-4">
                                        <a class="link-reset text-decoration-underline fw-semibold link-offset-3" href="#!">
                                            View all Countries
                                            <i class="ti ti-world"></i>
                                        </a>
                                    </div>
                                </div>
                                <!-- end card-body -->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                    <div class="row">
                        <div class="col-xxl-7">
                            <div class="row">
                                <div class="col-xl-6">
                                    <div class="card">
                                        <div class="card-header">
                                            <h4 class="card-title">Channels</h4>
                                        </div>
                                        <!-- card-header-->
                                        <div class="card-body">
                                            <!-- Facebook -->
                                            <div class="d-flex justify-content-between align-items-center mb-1">
                                                <div class="d-flex align-items-center gap-2">
                                                    <img alt="Meta" class="avatar-xxs rounded" src="/images/logos/meta.svg" />
                                                    <span>Facebook</span>
                                                </div>
                                                <span class="fw-semibold">78%</span>
                                            </div>
                                            <div class="progress progress-md mb-3">
                                                <div class="progress-bar bg-success" style="width: 78%"></div>
                                            </div>
                                            <!-- Instagram -->
                                            <div class="d-flex justify-content-between align-items-center mb-1">
                                                <div class="d-flex align-items-center gap-2">
                                                    <img alt="Meta" class="avatar-xxs rounded" src="/images/logos/instagram.svg" />
                                                    <span>Instagram</span>
                                                </div>
                                                <span class="fw-semibold">54%</span>
                                            </div>
                                            <div class="progress progress-md mb-3">
                                                <div class="progress-bar bg-success" style="width: 54%"></div>
                                            </div>
                                            <!-- LinkedIn -->
                                            <div class="d-flex justify-content-between align-items-center mb-1">
                                                <div class="d-flex align-items-center gap-2">
                                                    <img alt="Meta" class="avatar-xxs rounded" src="/images/logos/linkedin.svg" />
                                                    <span>LinkedIn</span>
                                                </div>
                                                <span class="fw-semibold">39%</span>
                                            </div>
                                            <div class="progress progress-md mb-3">
                                                <div class="progress-bar bg-success" style="width: 39%"></div>
                                            </div>
                                            <!-- Google -->
                                            <div class="d-flex justify-content-between align-items-center mb-1">
                                                <div class="d-flex align-items-center gap-2">
                                                    <img alt="Meta" class="avatar-xxs rounded" src="/images/logos/google.svg" />
                                                    <span>Google Search</span>
                                                </div>
                                                <span class="fw-semibold">22%</span>
                                            </div>
                                            <div class="progress progress-md mb-3">
                                                <div class="progress-bar bg-success" style="width: 22%"></div>
                                            </div>
                                            <!-- X (Twitter) -->
                                            <div class="d-flex justify-content-between align-items-center mb-1">
                                                <div class="d-flex align-items-center gap-2">
                                                    <img alt="Twitter X" class="avatar-xxs rounded" src="/images/logos/x.svg" />
                                                    <span>Twitter / X</span>
                                                </div>
                                                <span class="fw-semibold">31%</span>
                                            </div>
                                            <div class="progress progress-md mb-3">
                                                <div class="progress-bar bg-success" style="width: 31%"></div>
                                            </div>
                                            <!-- Button -->
                                            <button class="btn btn-primary w-100 mt-2">Download Reports</button>
                                        </div>
                                        <!-- end card-body-->
                                    </div>
                                    <!-- end card-->
                                    <div class="card bg-secondary bg-gradient border-0">
                                        <div class="card-body" style="background-image: url(/images/flower-style.svg); background-size: contain; background-repeat: no-repeat; background-position: right bottom">
                                            <h5 class="mb-1 text-white fw-semibold">Company Contact</h5>
                                            <p class="text-white text-opacity-75 mb-3">Get in touch with our support team.</p>
                                            <div class="mb-2 text-white text-opacity-75">
                                                <i class="ti ti-mail me-2 text-white"></i>
                                                support@company.com
                                            </div>
                                            <div class="mb-2 text-white text-opacity-75">
                                                <i class="ti ti-phone me-2 text-white"></i>
                                                +1 (234) 567-890
                                            </div>
                                            <a class="btn btn-light w-100" href="/mailto:support@company.com">Contact Support</a>
                                        </div>
                                    </div>
                                </div>
                                <!-- end col-->
                                <div class="col-xl-6">
                                    <div class="card">
                                        <div class="card-body">
                                            <!-- Title -->
                                            <div class="d-flex align-items-center mb-3 text-muted">
                                                <span class="me-1">★</span>
                                                <span>
                                                    <strong>Dane</strong>
                                                    , Your Project Progress Can
                                                    <strong>Inspire</strong>
                                                    Your Team
                                                </span>
                                            </div>
                                            <!-- Avatars -->
                                            <div class="avatar-group avatar-group-sm mb-3">
                                                <div class="avatar">
                                                    <img alt="" class="rounded-circle avatar-sm" src="/images/users/user-7.jpg" />
                                                </div>
                                                <div class="avatar">
                                                    <img alt="" class="rounded-circle avatar-sm" src="/images/users/user-8.jpg" />
                                                </div>
                                                <div class="avatar">
                                                    <img alt="" class="rounded-circle avatar-sm" src="/images/users/user-9.jpg" />
                                                </div>
                                                <div class="avatar">
                                                    <img alt="" class="rounded-circle avatar-sm" src="/images/users/user-10.jpg" />
                                                </div>
                                            </div>
                                            <!-- Text -->
                                            <p class="mb-1">
                                                <strong>5 Team Members</strong>
                                                are currently waiting for your update on this project.
                                            </p>
                                            <p class="text-muted fs-xs mb-3">Share your progress and the team will be notified instantly.</p>
                                            <!-- Button -->
                                            <button class="btn btn-info w-100 rounded-pill">Update Project</button>
                                        </div>
                                        <!-- end card-body-->
                                    </div>
                                    <!-- end card-->
                                    <div class="card">
                                        <div class="card-body">
                                            <!-- Header -->
                                            <div class="d-flex justify-content-between align-items-start mb-3">
                                                <div>
                                                    <h6 class="fw-semibold mb-1">Project Update Needed</h6>
                                                    <span class="text-muted">Your team is waiting for your input</span>
                                                </div>
                                                <span class="badge text-bg-warning fw-semibold">Pending</span>
                                            </div>
                                            <!-- Avatars + Count -->
                                            <div class="d-flex align-items-center mb-3">
                                                <div class="avatar-group avatar-group-sm me-2">
                                                    <div class="avatar">
                                                        <img class="rounded-circle avatar-sm" src="/images/users/user-2.jpg" />
                                                    </div>
                                                    <div class="avatar">
                                                        <img class="rounded-circle avatar-sm" src="/images/users/user-3.jpg" />
                                                    </div>
                                                    <div class="avatar">
                                                        <img class="rounded-circle avatar-sm" src="/images/users/user-4.jpg" />
                                                    </div>
                                                    <div class="avatar">
                                                        <img class="rounded-circle avatar-sm" src="/images/users/user-5.jpg" />
                                                    </div>
                                                </div>
                                                <small class="text-muted ms-1">+3 more reviewers</small>
                                            </div>
                                            <!-- Project Info -->
                                            <div class="mb-3">
                                                <p class="mb-1">
                                                    <strong>Design System Revamp</strong>
                                                    requires your final approval.
                                                </p>
                                                <p class="text-muted fst-italic mb-0">Once approved, the development team will begin implementing the new UI components.</p>
                                            </div>
                                            <!-- Progress -->
                                            <div class="mb-3">
                                                <div class="d-flex justify-content-between mb-2">
                                                    <small class="text-muted">Progress</small>
                                                    <small class="fw-semibold">72%</small>
                                                </div>
                                                <div class="progress progress-md">
                                                    <div class="progress-bar bg-success" style="width: 72%"></div>
                                                </div>
                                            </div>
                                            <!-- Button -->
                                            <button class="btn btn-primary w-100 rounded-pill">Review &amp; Approve</button>
                                        </div>
                                    </div>
                                </div>
                                <!-- end col-->
                            </div>
                        </div>
                        <!-- end col-->
                        <div class="col-xxl-5">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Search</h4>
                                </div>
                                <!-- card-header-->
                                <div class="card-body">
                                    <h5 class="fs-14 fw-semibold">Sizes</h5>
                                    <div class="app-search app-search-sm">
                                        <input class="form-control form-control-sm" placeholder="Search here..." type="text" />
                                        <i class="app-search-icon text-muted" data-lucide="search"></i>
                                    </div>
                                    <div class="app-search mt-3">
                                        <input class="form-control" placeholder="Search something here..." type="text" />
                                        <i class="app-search-icon text-muted" data-lucide="search"></i>
                                    </div>
                                    <div class="app-search app-search-lg mt-3">
                                        <input class="form-control form-control-lg" placeholder="Search here..." type="text" />
                                        <i class="app-search-icon text-muted" data-lucide="search"></i>
                                    </div>
                                    <h5 class="fs-14 fw-semibold mt-3">Styles</h5>
                                    <div class="app-search">
                                        <input class="form-control" placeholder="Search something here..." type="text" />
                                        <iconify-icon class="app-search-icon text-secondary fs-18" icon="solar:magic-stick-3-bold-duotone"></iconify-icon>
                                    </div>
                                    <div class="app-search input-group mt-3">
                                        <input class="form-control" placeholder="Search here..." type="text" />
                                        <i class="app-search-icon text-muted" data-lucide="search"></i>
                                        <button class="btn btn-secondary" type="button">Search</button>
                                    </div>
                                    <div class="app-search mt-3">
                                        <input class="form-control border-light bg-body" placeholder="Search something here..." type="text" />
                                        <i class="app-search-icon text-muted" data-lucide="search"></i>
                                    </div>
                                </div>
                                <!-- card-body-->
                            </div>
                            <!-- end card-->
                        </div>
                        <!-- end col-->
                    </div>
                    <!-- end row-->
                </div>
                <!-- container -->

                <?= $this->include('partials/footer') ?>
            </div>
            <!-- ============================================================== -->
            <!-- End of Main Content -->
            <!-- ============================================================== -->
        </div>
        <!-- END wrapper -->

        <?= $this->include('partials/customizer') ?> <?= $this->include('partials/footer-scripts') ?>
    </body>
</html>
