/**
 * Template Name: Paces - Multipurpose Admin & Dashboard Template
 * By (Author): Coderthemes
 * Module/App (File Name): Bootstrap Table
 */

// --- Your sample data ---
const products = [
    {
        id: 1,
        product: "Wireless Headphones",
        category: "Electronics",
        price: "$99.00",
        stock: 120,
        rating: "4.5 ★",
        status: '<span class="badge bg-success">Active</span>',
        actions: '<button class="btn btn-sm btn-primary">Edit</button> <button class="btn btn-sm btn-danger">Delete</button>',
    },
    {
        id: 2,
        product: "Running Shoes",
        category: "Footwear",
        price: "$59.99",
        stock: 80,
        rating: "4.2 ★",
        status: '<span class="badge bg-success">Active</span>',
        actions: '<button class="btn btn-sm btn-primary">Edit</button> <button class="btn btn-sm btn-danger">Delete</button>',
    },
    {
        id: 3,
        product: "Smartwatch",
        category: "Wearables",
        price: "$129.00",
        stock: 0,
        rating: "4.0 ★",
        status: '<span class="badge text-bg-warning">Out of Stock</span>',
        actions: '<button class="btn btn-sm btn-primary">Edit</button> <button class="btn btn-sm btn-danger">Delete</button>',
    },
    {
        id: 4,
        product: "Gaming Mouse",
        category: "Accessories",
        price: "$39.50",
        stock: 250,
        rating: "4.7 ★",
        status: '<span class="badge bg-success">Active</span>',
        actions: '<button class="btn btn-sm btn-primary">Edit</button> <button class="btn btn-sm btn-danger">Delete</button>',
    },
    {
        id: 5,
        product: "Office Chair",
        category: "Furniture",
        price: "$149.00",
        stock: 35,
        rating: "4.3 ★",
        status: '<span class="badge bg-success">Active</span>',
        actions: '<button class="btn btn-sm btn-primary">Edit</button> <button class="btn btn-sm btn-danger">Delete</button>',
    },

    {
        id: 6,
        product: "Bluetooth Speaker",
        category: "Electronics",
        price: "$45.00",
        stock: 60,
        rating: "4.1 ★",
        status: '<span class="badge bg-success">Active</span>',
        actions: '<button class="btn btn-sm btn-primary">Edit</button> <button class="btn btn-sm btn-danger">Delete</button>',
    },
    {
        id: 7,
        product: "Yoga Mat",
        category: "Fitness",
        price: "$25.00",
        stock: 150,
        rating: "4.6 ★",
        status: '<span class="badge bg-success">Active</span>',
        actions: '<button class="btn btn-sm btn-primary">Edit</button> <button class="btn btn-sm btn-danger">Delete</button>',
    },
    {
        id: 8,
        product: "Laptop Backpack",
        category: "Accessories",
        price: "$75.00",
        stock: 40,
        rating: "4.4 ★",
        status: '<span class="badge bg-success">Active</span>',
        actions: '<button class="btn btn-sm btn-primary">Edit</button> <button class="btn btn-sm btn-danger">Delete</button>',
    },
    {
        id: 9,
        product: "Electric Kettle",
        category: "Home Appliances",
        price: "$35.00",
        stock: 0,
        rating: "3.9 ★",
        status: '<span class="badge text-bg-warning">Out of Stock</span>',
        actions: '<button class="btn btn-sm btn-primary">Edit</button> <button class="btn btn-sm btn-danger">Delete</button>',
    },
    {
        id: 10,
        product: "Desk Lamp",
        category: "Furniture",
        price: "$29.99",
        stock: 85,
        rating: "4.2 ★",
        status: '<span class="badge bg-success">Active</span>',
        actions: '<button class="btn btn-sm btn-primary">Edit</button> <button class="btn btn-sm btn-danger">Delete</button>',
    },
    {
        id: 11,
        product: "Water Bottle",
        category: "Fitness",
        price: "$15.00",
        stock: 200,
        rating: "4.8 ★",
        status: '<span class="badge bg-success">Active</span>',
        actions: '<button class="btn btn-sm btn-primary">Edit</button> <button class="btn btn-sm btn-danger">Delete</button>',
    },
    {
        id: 12,
        product: "Smart TV",
        category: "Electronics",
        price: "$499.00",
        stock: 20,
        rating: "4.6 ★",
        status: '<span class="badge bg-success">Active</span>',
        actions: '<button class="btn btn-sm btn-primary">Edit</button> <button class="btn btn-sm btn-danger">Delete</button>',
    },
    {
        id: 13,
        product: "Microwave Oven",
        category: "Home Appliances",
        price: "$199.00",
        stock: 15,
        rating: "4.3 ★",
        status: '<span class="badge bg-success">Active</span>',
        actions: '<button class="btn btn-sm btn-primary">Edit</button> <button class="btn btn-sm btn-danger">Delete</button>',
    },
    {
        id: 14,
        product: "Gaming Keyboard",
        category: "Accessories",
        price: "$89.00",
        stock: 100,
        rating: "4.7 ★",
        status: '<span class="badge bg-success">Active</span>',
        actions: '<button class="btn btn-sm btn-primary">Edit</button> <button class="btn btn-sm btn-danger">Delete</button>',
    },
    {
        id: 15,
        product: "Air Purifier",
        category: "Home Appliances",
        price: "$159.00",
        stock: 12,
        rating: "4.5 ★",
        status: '<span class="badge bg-success">Active</span>',
        actions: '<button class="btn btn-sm btn-primary">Edit</button> <button class="btn btn-sm btn-danger">Delete</button>',
    },
]

// --- Init table ---
$("#productTable").bootstrapTable({ data: products })

// --- Style built-in checkboxes as Bootstrap 5 ---
function styleBTCheckboxes() {
    // row checkboxes
    $('.bootstrap-table td.bs-checkbox input[type="checkbox"]')
        .addClass("form-check-input")
        .each(function () {
            if (!$(this).parent().hasClass("form-check")) {
                $(this).wrap('<div class="form-check ps-0 fs-13 m-0"></div>')
            }
        })

    // header "select all" checkbox
    const $hdr = $('.bootstrap-table th.bs-checkbox .th-inner input[type="checkbox"]')
    $hdr.addClass("form-check-input")
    if ($hdr.length && !$hdr.parent().hasClass("form-check")) {
        $hdr.wrap('<div class="form-check ps-0 fs-14 m-0"></div>')
    }
}

$("#productTable").on("post-header.bs.table post-body.bs.table", styleBTCheckboxes)
styleBTCheckboxes() // first pass

// --- Replace toolbar icons with SVGs ---
$(function () {
    const svgColumns = `
<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
        viewBox="0 0 24 24" fill="none" stroke="currentColor"
        stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
    <path d="M4 6h5.5M4 10h5.5M4 14h5.5M4 18h5.5M14.5 6H20M14.5 10H20M14.5 14H20M14.5 18H20"/>
</svg>
`

    const svgRefresh = `
<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
        viewBox="0 0 24 24" fill="none" stroke="currentColor"
        stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
    <path d="M21 12a9 9 0 1 1-2.64-6.36"/><path d="M21 3v6h-6"/>
</svg>
`

    function replaceToolbarIcons() {
        // Columns dropdown
        const $columnsBtn = $(".bootstrap-table .columns .dropdown-toggle")
        $columnsBtn.find("i").remove()
        if (!$columnsBtn.find("svg").length) $columnsBtn.prepend(svgColumns)

        // Refresh button
        const $refreshBtn = $('.bootstrap-table .fixed-table-toolbar .btn[name="refresh"]')
        $refreshBtn.find("i").remove()
        if (!$refreshBtn.find("svg").length) $refreshBtn.prepend(svgRefresh)
    }

    $("#productTable").on("post-header.bs.table post-body.bs.table post-toolbar.bs.table", replaceToolbarIcons)

    replaceToolbarIcons() // first pass
})
